/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.util.Map;
import java.util.TimerTask;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.Context;
import multivalent.CursorMark;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.Span;
import multivalent.gui.VCheckbox;
import multivalent.gui.VFrame;
import multivalent.node.LeafZero;
import phelps.lang.Integers;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpeedRead
extends Behavior {
    public static final String MSG_PAUSE = "togglePause";
    public static final String MSG_DELAY = "speedreadDelay";
    public static final String MSG_FASTER = "speedreadFaster";
    public static final String MSG_SLOWER = "speedreadSlower";
    public static final String ATTR_DELAY = "delay";
    static final int DELAYINC = 10;
    static final int IDELAY = 500;
    static Color BACKGROUND = new Color(224, 224, 224);
    static int ix_ = 100;
    static int iy_ = 100;
    static int iwidth_ = 300;
    static int iheight_ = 100;
    static Font bigwordFont = new Font("Serif", 0, 24);
    Node point_ = null;
    boolean stop_ = false;
    int delay_;
    VFrame win_ = null;
    TimerTask tt = null;

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/DOCPOPUP" == string && semanticEvent.getIn() == this.win_) {
            Browser browser = this.getBrowser();
            INode iNode = (INode)semanticEvent.getOut();
            VCheckbox vCheckbox = (VCheckbox)this.createUI("checkbox", "Pause (also click in content)", new SemanticEvent(browser, MSG_PAUSE, this.win_, this, null), iNode, "SPECIFIC", false);
            vCheckbox.setState(this.stop_);
            this.createUI("button", new StringBuffer().append("Faster than ").append(this.delay_).append("ms  (also '->')").toString(), new SemanticEvent(browser, MSG_FASTER, this.win_, this, null), iNode, "EDIT", this.delay_ <= 10);
            this.createUI("button", "Slower (also '<-')", new SemanticEvent(browser, MSG_SLOWER, this.win_, this, null), iNode, "EDIT", false);
            return true;
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (this.win_ != null && this.win_ == semanticEvent.getArg()) {
            if ("frameClosed" == string) {
                this.destroy();
            } else if ("frameMoved" == string || "frameResized" == string) {
                Rectangle rectangle = this.win_.bbox;
                ix_ = rectangle.x;
                iy_ = rectangle.y;
                iwidth_ = rectangle.width;
                iheight_ = rectangle.height;
            } else if (MSG_PAUSE == string) {
                this.stop_ = !this.stop_;
            } else if (MSG_SLOWER == string) {
                this.delay_ += 10;
            } else if (MSG_FASTER == string) {
                if (this.delay_ - 10 > 0) {
                    this.delay_ -= 10;
                }
            } else if (MSG_DELAY == string) {
                // empty if block
            }
        } else if ("setCursor" == string) {
            this.setStart();
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    @Override
    public void destroy() {
        this.stop_ = true;
        this.tt.cancel();
        this.win_.deleteObserver(this);
        this.win_.remove();
        this.getBrowser().repaint(100L);
        super.destroy();
    }

    @Override
    public boolean paintBefore(Context context, Node node) {
        if (super.paintBefore(context, node)) {
            return true;
        }
        Graphics2D graphics2D = context.g;
        Rectangle rectangle = this.win_.bbox;
        graphics2D.setColor(BACKGROUND);
        graphics2D.fillRect(0, 0, rectangle.width, rectangle.height);
        return false;
    }

    @Override
    public boolean paintAfter(Context context, Node node) {
        String string = this.point_.getName();
        if (string != null && string.length() > 0) {
            Graphics2D graphics2D = context.g;
            Shape shape = graphics2D.getClip();
            Rectangle rectangle = this.win_.getContentBounds();
            rectangle.translate(-this.win_.bbox.x, -this.win_.bbox.y);
            graphics2D.clip(rectangle);
            graphics2D.setFont(bigwordFont);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(string, (rectangle.width - fontMetrics.stringWidth(string)) / 2, (rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getHeight());
            graphics2D.setClip(shape);
        }
        return super.paintAfter(context, node);
    }

    @Override
    public boolean eventBefore(AWTEvent aWTEvent, Point point, Node node) {
        if (aWTEvent.getID() == 501) {
            Rectangle rectangle = this.win_.getContentBounds();
            if (point != null && point.y > rectangle.y - this.win_.bbox.y) {
                this.getBrowser().eventq(MSG_PAUSE, this.win_);
            }
        }
        return false;
    }

    @Override
    public boolean eventAfter(AWTEvent aWTEvent, Point point, Node node) {
        if (aWTEvent.getID() == 401) {
            int n = ((KeyEvent)aWTEvent).getKeyCode();
            Browser browser = this.getBrowser();
            if (n == 39) {
                browser.eventq(MSG_FASTER, this.win_);
            } else if (n == 37) {
                browser.eventq(MSG_SLOWER, this.win_);
            }
        }
        return false;
    }

    void next() {
        if (this.point_ != null && !this.stop_) {
            this.point_ = this.point_.getNextLeaf();
            if (this.point_ == null) {
                this.destroy();
            } else {
                this.win_.getDocument().repaint(Math.min(this.delay_, 100));
            }
        }
    }

    void setStart() {
        Browser browser = this.getBrowser();
        CursorMark cursorMark = browser.getCursorMark();
        Span span = browser.getSelectionSpan();
        if (cursorMark.isSet()) {
            this.point_ = cursorMark.getMark().leaf;
            cursorMark.move(null, -1);
        } else if (browser.getSelectionSpan().isSet()) {
            this.point_ = span.getStart().leaf;
            span.moveq(null);
        } else {
            this.point_ = browser.getCurDocument().getFirstLeaf();
        }
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        this.delay_ = Integers.parseInt(this.getAttr(ATTR_DELAY), 50);
        Browser browser = this.getBrowser();
        Document document = browser.getCurDocument();
        this.win_ = new VFrame("SpeedRead", null, document);
        this.win_.setPinned(false);
        this.win_.setTitle("Speed Read");
        new LeafZero("TRANSPARENT", null, this.win_);
        this.win_.setBounds(Integers.parseInt(this.getAttr("x"), ix_), Integers.parseInt(this.getAttr("y"), iy_), Integers.parseInt(this.getAttr("width"), iwidth_), Integers.parseInt(this.getAttr("height"), iheight_));
        this.win_.addObserver(this);
        this.setStart();
        this.tt = new TimerTask(){

            public void run() {
                SpeedRead.this.next();
            }
        };
        this.getGlobal().getTimer().schedule(this.tt, 500L, (long)this.delay_);
    }
}

