/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.List;
import java.util.TimerTask;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.Context;
import multivalent.Document;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.node.Root;

public class SlideShow
extends Behavior {
    static final boolean DEBUG = false;
    public static final String MSG_START = "slideShow";
    public static final String MSG_STOP = "slideShowStop";
    static final int EDGE_MARGIN = 5;
    GraphicsDevice gd_ = null;
    Frame full_ = null;
    Document doc_ = null;
    Rectangle bboxin_ = new Rectangle();
    Root root_ = null;
    TimerTask tt_ = null;

    void start() {
        Browser browser = this.getBrowser();
        this.doc_ = browser.getCurDocument();
        this.bboxin_.setBounds(this.doc_.bbox);
        this.root_ = browser.getRoot();
        this.root_.addObserver(this);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.gd_ = graphicsEnvironment.getDefaultScreenDevice();
        this.full_ = new FrameFull();
        this.gd_.setFullScreenWindow(this.full_);
    }

    void stop() {
        if (!this.isActive()) {
            return;
        }
        if (this.isActive()) {
            this.gd_.setFullScreenWindow(null);
            this.gd_ = null;
            this.full_.dispose();
            this.full_ = null;
        }
        this.doc_.bbox.setBounds(this.bboxin_);
        this.doc_.setValid(false);
        this.doc_ = null;
        this.root_.deleteObserver(this);
        this.root_.setValid(false);
        this.root_ = null;
        if (this.tt_ != null) {
            this.tt_.cancel();
            this.tt_ = null;
        }
        Browser browser = this.getBrowser();
        browser.requestFocus();
        browser.repaint(1000L);
    }

    public boolean isActive() {
        return this.gd_ != null;
    }

    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/Go" == string) {
            this.createUI("button", "Full Screen Slide Show", "event slideShow", (INode)semanticEvent.getOut(), "GoPan", false);
        }
        return false;
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (MSG_START == string) {
            this.start();
            return true;
        }
        if (MSG_STOP == string) {
            this.stop();
            return true;
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    public boolean paintBefore(Context context, Node node) {
        return true;
    }

    public boolean paintAfter(Context context, Node node) {
        return true;
    }

    public boolean eventBefore(AWTEvent aWTEvent, Point point, Node node) {
        Object object;
        int n = aWTEvent.getID();
        String string = null;
        if (401 == n) {
            object = (KeyEvent)aWTEvent;
            switch (((KeyEvent)object).getKeyCode()) {
                case 10: 
                case 32: 
                case 34: 
                case 39: 
                case 40: 
                case 43: 
                case 110: {
                    string = "nextPage";
                    break;
                }
                case 8: 
                case 33: 
                case 37: 
                case 38: 
                case 45: 
                case 112: {
                    string = "previousPage";
                    break;
                }
                case 36: 
                case 44: 
                case 49: {
                    string = "firstDocumentPage";
                    break;
                }
                case 35: 
                case 46: {
                    string = "lastDocumentPage";
                    break;
                }
                case 27: 
                case 113: {
                    string = MSG_STOP;
                    break;
                }
            }
        } else if (500 == n) {
            object = (MouseEvent)aWTEvent;
            String string2 = ((MouseEvent)object).getClickCount() > 1 ? MSG_STOP : (string = ((MouseEvent)object).getButton() == 1 ? "nextPage" : "previousPage");
        }
        if (string != null) {
            object = this.doc_.getLayers();
            SemanticEvent semanticEvent = new SemanticEvent(this.getBrowser(), string, null);
            boolean bl = ((Layer)object).semanticEventBefore(semanticEvent, string) | ((Layer)object).semanticEventAfter(semanticEvent, string);
            if (this.isActive()) {
                this.full_.repaint(200L);
            }
        }
        return true;
    }

    public boolean eventAfter(AWTEvent aWTEvent, Point point, Node node) {
        return true;
    }

    class FrameFull
    extends Frame {
        public FrameFull() {
            this.enableEvents(-1L);
            this.setUndecorated(true);
        }

        protected void processEvent(AWTEvent aWTEvent) {
            if (SlideShow.this.doc_ != null) {
                SlideShow.this.doc_.getBrowser().event(aWTEvent);
            }
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            int n;
            Graphics2D graphics2D = (Graphics2D)graphics;
            List<Behavior> list = SlideShow.this.root_.getObservers();
            Context context = SlideShow.this.root_.getStyleSheet().getContext(graphics2D, Toolkit.getDefaultToolkit(), null);
            int n2 = 0;
            if (list != null) {
                n2 = list.size();
                for (n = 0; n < n2 && !list.get(n).paintBefore(context, SlideShow.this.root_); ++n) {
                }
            }
            Context context2 = SlideShow.this.doc_.getStyleSheet().getContext(graphics2D, Toolkit.getDefaultToolkit(), null);
            context2.valid = false;
            AffineTransform affineTransform = graphics2D.getTransform();
            int n3 = SlideShow.this.full_.getWidth();
            int n4 = SlideShow.this.full_.getHeight();
            Rectangle rectangle = new Rectangle(0, 0, n3, n4);
            int n5 = SlideShow.this.doc_.dx();
            int n6 = SlideShow.this.doc_.dy();
            graphics2D.translate(-n5, -n6);
            rectangle.translate(n5, n6);
            SlideShow.this.doc_.formatBeforeAfter(SlideShow.this.bboxin_.width, SlideShow.this.bboxin_.height, context2);
            Rectangle rectangle2 = new Rectangle(0, 0, SlideShow.this.doc_.getHsb().getMax() - SlideShow.this.doc_.getHsb().getMin(), SlideShow.this.doc_.getVsb().getMax() - SlideShow.this.doc_.getVsb().getMin());
            if (rectangle2.width != SlideShow.this.doc_.bbox.width || rectangle2.height != SlideShow.this.doc_.bbox.height) {
                SlideShow.this.doc_.setValid(false);
                SlideShow.this.doc_.bbox.setSize(rectangle2.width, rectangle2.height);
            }
            double d = (double)(n3 - 5) / (double)rectangle2.width;
            double d2 = (double)(n4 - 5) / (double)rectangle2.height;
            double d3 = Math.min(d, d2);
            if (Math.abs(d - d2) > 0.001) {
                graphics2D.setColor(Color.BLACK);
                graphics2D.fillRect(0, 0, n3, n4);
            }
            graphics2D.translate(((double)n3 - d3 * (double)rectangle2.width) / 2.0, ((double)n4 - d3 * (double)rectangle2.height) / 2.0);
            graphics2D.scale(d3, d3);
            SlideShow.this.doc_.paintBeforeAfter(rectangle, context2);
            graphics2D.translate(n5, n6);
            rectangle.translate(-n5, -n6);
            graphics2D.setTransform(affineTransform);
            while (n >= 0 && !list.get(n).paintAfter(context, SlideShow.this.root_)) {
                --n;
            }
        }
    }
}

