/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.Context;
import multivalent.DocInfo;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Leaf;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.gui.VCheckbox;
import multivalent.gui.VScrollbar;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowHeaders
extends Behavior {
    public static final String MSG_VIEW = "viewLastModified";
    static Font defaultFont_ = new Font("Serif", 0, 10);
    String[] header = null;
    String[] vals = null;
    boolean active_ = false;
    Document curdoc_ = null;
    Map<URI, Integer> doc2wcnt = new HashMap<URI, Integer>(100);

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/View" == string) {
            INode iNode = (INode)semanticEvent.getOut();
            VCheckbox vCheckbox = (VCheckbox)this.createUI("checkbox", "Show Date Last Modified", "event viewLastModified", iNode, null, false);
            vCheckbox.setState(this.active_);
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (MSG_VIEW == string) {
            this.active_ = !this.active_;
            this.getBrowser().getCurDocument().repaint();
        } else if ("openedDocument" == string) {
            Object object = semanticEvent.getArg();
            if (object instanceof DocInfo) {
                DocInfo docInfo = (DocInfo)object;
                Document document = docInfo.doc;
                if (document != null) {
                    int n = 0;
                    Leaf leaf = document.getLastLeaf();
                    for (Leaf leaf2 = document.getFirstLeaf(); leaf2 != leaf && leaf2 != null; leaf2 = leaf2.getNextLeaf()) {
                        ++n;
                    }
                    if (docInfo.uri != null) {
                        this.doc2wcnt.put(docInfo.uri, new Integer(n));
                    }
                }
            }
        } else if ("currentDocument" == string) {
            if (this.curdoc_ != null) {
                this.curdoc_.deleteObserver(this);
            }
            this.curdoc_ = (Document)semanticEvent.getArg();
            if (this.curdoc_ != null) {
                this.curdoc_.addObserver(this);
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        this.active_ = !"FALSE".equalsIgnoreCase(this.getAttr("active", "FALSE"));
    }

    void drawOnBackground(Graphics2D graphics2D, String string, int n, int n2) {
        if (null == string) {
            return;
        }
        graphics2D.setFont(defaultFont_);
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawString(string, n - 1, n2);
        graphics2D.drawString(string, n + 1, n2);
        graphics2D.drawString(string, n, n2 - 1);
        graphics2D.drawString(string, n, n2 + 1);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(string, n, n2);
    }

    @Override
    public boolean paintAfter(Context context, Node node) {
        Integer n;
        URI uRI;
        String string;
        Object object;
        Map map;
        if (!this.active_) {
            return false;
        }
        if (this.curdoc_.getVsb().getValue() != 0 || this.curdoc_.bbox.width <= 300) {
            return false;
        }
        Browser browser = this.getBrowser();
        String string2 = this.getAttr("headers", "*");
        if (string2 == "*") {
            // empty if block
        }
        if ((map = (Map)this.curdoc_.getVar("headers")) != null) {
            object = new StringTokenizer(string2);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                String string4 = (String)map.get(string3);
                if (string4 == null) continue;
            }
        }
        object = browser.getFontMetrics(defaultFont_);
        int n2 = ((FontMetrics)object).getHeight() - 2;
        int n3 = 0 + n2;
        int n4 = node.bbox.width - VScrollbar.SIZE - 2;
        Graphics2D graphics2D = context.g;
        String string5 = string = map != null ? (String)map.get("Last-Modified") : null;
        if (string != null) {
            this.drawOnBackground(graphics2D, string, n4 - ((FontMetrics)object).stringWidth(string), n3);
            n3 += n2;
        }
        if ((uRI = this.curdoc_.getURI()) != null && (n = this.doc2wcnt.get(uRI)) != null && n > 10) {
            string = new StringBuffer().append("").append(n).append(" words").toString();
            this.drawOnBackground(graphics2D, string, n4 - ((FontMetrics)object).stringWidth(string), n3);
            n3 += n2;
        }
        return false;
    }
}

