/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std;

import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.Document;
import multivalent.INode;
import multivalent.Multivalent;
import multivalent.SemanticEvent;
import multivalent.gui.VAlert;
import phelps.awt.Fonts;

public class ReportBug
extends Behavior {
    public static final String MSG_REPORT_BUG = "reportBug";
    static String form_ = null;

    void fill(StringBuffer stringBuffer) {
        int n;
        URL[] uRLArray;
        if (form_ == null) {
            try {
                uRLArray = new StringBuffer(2048);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("BugReport.txt")));
                while ((n = ((Reader)bufferedReader).read()) != -1) {
                    uRLArray.append((char)n);
                }
                ((Reader)bufferedReader).close();
                form_ = uRLArray.substring(0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        stringBuffer.insert(0, form_);
        stringBuffer.append("Report generated ").append(new Date().toString()).append("\n");
        stringBuffer.append("Multivalent version: ").append(Multivalent.VERSION).append("\n");
        stringBuffer.append("\n\n*** JARs ***\n\n");
        uRLArray = ((URLClassLoader)Multivalent.getInstance().getClass().getClassLoader()).getURLs();
        n = uRLArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(uRLArray[i]).append("\n");
        }
        stringBuffer.append("\n\n*** Current Document ***\n\n");
        Document document = this.getBrowser().getCurDocument();
        stringBuffer.append("URI: ").append(document.getURI()).append("\n");
        stringBuffer.append("layout valid? ").append(document.isValid()).append("\n");
        String[] stringArray = document.attrEntrySetIterator();
        while (stringArray.hasNext()) {
            Map.Entry<String, Object> entry = stringArray.next();
            stringBuffer.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
        }
        stringBuffer.append("\n\n*** Fonts ***\n\n");
        stringArray = Fonts.FAMILIES;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(stringArray[i]).append("\n");
        }
        stringBuffer.append("\n\n*** Java Properties ***\n\n");
        Runtime runtime = Runtime.getRuntime();
        stringBuffer.append("Memory use: ").append(runtime.freeMemory()).append(" free of ").append(runtime.totalMemory()).append("total, max=").append(runtime.maxMemory()).append("\n");
        stringBuffer.append("Processors: ").append(runtime.availableProcessors()).append("\n");
        Properties properties = System.getProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            stringBuffer.append(object).append(": ").append(properties.get(object)).append("\n");
        }
    }

    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/Help" == string) {
            SemanticEvent semanticEvent2 = new SemanticEvent(this.getBrowser(), MSG_REPORT_BUG, new StringBuffer(5000));
            this.createUI("button", "Report Bug", semanticEvent2, (INode)semanticEvent.getOut(), null, false);
        } else if (MSG_REPORT_BUG == string && semanticEvent.getArg() instanceof StringBuffer) {
            this.fill((StringBuffer)semanticEvent.getArg());
        }
        return false;
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        Browser browser = this.getBrowser();
        if (MSG_REPORT_BUG == string && semanticEvent.getArg() instanceof StringBuffer) {
            String string2 = ((StringBuffer)semanticEvent.getArg()).toString();
            StringSelection stringSelection = new StringSelection(string2);
            browser.getToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            new VAlert("alert", null, (INode)this.getDocument(), "Debugging information copied to clipboard.  Paste into e-mail.");
        }
        return super.semanticEventAfter(semanticEvent, string);
    }
}

