/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.Cache;
import multivalent.DocInfo;
import multivalent.Document;
import multivalent.Layer;
import multivalent.MediaAdaptor;
import multivalent.Multivalent;
import multivalent.SemanticEvent;
import multivalent.node.LeafAscii;

public class MediaLoader
extends Behavior {
    DocInfo di_ = null;
    boolean stop_ = false;
    boolean loading_ = false;

    public void setDocInfo(DocInfo docInfo) {
        this.di_ = docInfo;
    }

    public void load() {
        this.load(false);
    }

    public void load(boolean bl) {
        Object object;
        DocInfo docInfo = this.di_;
        if (docInfo == null) {
            return;
        }
        Multivalent multivalent = this.getGlobal();
        Browser browser = this.getBrowser();
        Document document = docInfo.doc;
        InputStream inputStream = null;
        try {
            object = multivalent.getCache();
            inputStream = ((Cache)object).getInputStream(docInfo, null, 3);
        }
        catch (Exception exception) {
            document.clear();
            new LeafAscii("Can't getInputStream() from cache for " + docInfo.uri + ": " + exception, null, document);
            exception.printStackTrace();
            return;
        }
        if (this.stop_) {
            this.getLayer().removeBehavior(this);
            return;
        }
        object = docInfo.uri;
        if (!((URI)object).isOpaque() && "".equals(((URI)object).getPath())) {
            object = ((URI)object).resolve("/");
        }
        this.loading_ = true;
        document.clear();
        document.putAttr("genre", docInfo.genre);
        document.putVar("headers", docInfo.headers);
        document.uri = object;
        document.putAttr("uri", ((URI)object).toString());
        String string = ((URI)object).getPath();
        int n = string.lastIndexOf(47);
        if (n != -1 && n < string.length() - 1) {
            string = string.substring(n + 1);
        }
        document.putAttr("title", string);
        browser.setCurDocument(document);
        Layer layer = document.getLayers();
        layer.addBehavior(this);
        Layer layer2 = layer.getInstance("base");
        MediaAdaptor mediaAdaptor = null;
        try {
            mediaAdaptor = (MediaAdaptor)Behavior.getInstance(docInfo.genre, docInfo.genre, null, layer2);
        }
        catch (ClassCastException classCastException) {
            new LeafAscii(docInfo.genre + ": genre mapped to non-MediaAdaptor class", null, document);
            return;
        }
        document.setMediaAdaptor(mediaAdaptor);
        mediaAdaptor.docURI = object;
        mediaAdaptor.putAttr("uri", ((URI)object).toString());
        if (!bl) {
            layer.getInstance(document.getAttr("genre"));
        }
        document.putAttr("loading", "loading");
        mediaAdaptor.setInputStream(inputStream);
        try {
            browser.event(new SemanticEvent(this, "buildDocument", docInfo));
            layer.buildBeforeAfter(document);
        }
        catch (Exception exception) {
            try {
                mediaAdaptor.closeInputStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            new LeafAscii("COULDN'T RESTORE BASE " + exception, null, document);
            exception.printStackTrace();
        }
        if (this.stop_) {
            document.putAttr("stop", "STOP");
        } else {
            document.removeAttr("loading");
            this.loading_ = false;
            browser.event(new SemanticEvent(this, "openedDocument", docInfo));
            browser.setCurDocument(document);
            browser.repaint(bl ? 0L : 100L);
        }
    }
}

