/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std;

import java.awt.RenderingHints;
import java.util.Map;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.Context;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.gui.VCheckbox;
import phelps.lang.Booleans;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontRender
extends Behavior {
    public static final String MSG_ANTIALIAS = "antialias";
    public static final String MSG_FRACTIONAL_METRICS = "fractional_metrics";
    public static final String ATTR_ANTIALIASING = "antialiasing";
    public static final String ATTR_FRACTIONAL_METRICS = "fractional-metrics";
    public static final String ATTR_AATITLE = "title";
    public static final String VALUE_FORCE_ON = "force-on";
    public static final String VALUE_FORCE_OFF = "force-off";
    public static final String VALUE_USER_ON = "user-on";
    public static final String VALUE_USER_OFF = "user-off";
    public static final String VALUE_USER = "user";
    public static final String VALUE_UNSET = "unset";
    static final String AATITLE_DEFAULT = "Antialiasing";
    String acont_ = "unset";
    String fcont_ = "unset";
    boolean anti_ = false;
    boolean fract_ = false;
    private Object aain_ = null;
    private Object fmin_ = null;
    String aatitle_;

    @Override
    public void buildBefore(Document document) {
        super.buildBefore(document);
        if (this.acont_ != VALUE_UNSET || this.fcont_ != VALUE_UNSET) {
            this.getDocument().addObserver(this);
        }
    }

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/View" == string) {
            VCheckbox vCheckbox;
            SemanticEvent semanticEvent2;
            INode iNode = (INode)semanticEvent.getOut();
            Browser browser = this.getBrowser();
            if (this.acont_ == VALUE_USER_ON || this.acont_ == VALUE_USER_OFF) {
                semanticEvent2 = new SemanticEvent(browser, MSG_ANTIALIAS, null, this, null);
                vCheckbox = (VCheckbox)this.createUI("checkbox", this.aatitle_, semanticEvent2, iNode, "View", false);
                vCheckbox.setState(this.anti_);
            }
            if (this.fcont_ == VALUE_USER_ON || this.fcont_ == VALUE_USER_OFF) {
                semanticEvent2 = new SemanticEvent(browser, MSG_FRACTIONAL_METRICS, null, this, null);
                vCheckbox = (VCheckbox)this.createUI("checkbox", "Fractional Metrics", semanticEvent2, iNode, "View", false);
                vCheckbox.setState(this.fract_);
            }
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (this.aatitle_ == AATITLE_DEFAULT || semanticEvent.getIn() == this) {
            if (MSG_ANTIALIAS == string) {
                if (this.acont_ == VALUE_USER_ON || this.acont_ == VALUE_USER_OFF) {
                    this.anti_ = Booleans.parseBoolean(semanticEvent.getArg(), !this.anti_);
                    this.getBrowser().repaint();
                }
            } else if (MSG_FRACTIONAL_METRICS == string && (this.fcont_ == VALUE_USER_ON || this.fcont_ == VALUE_USER_OFF)) {
                this.fract_ = Booleans.parseBoolean(semanticEvent.getArg(), !this.fract_);
                this.getBrowser().repaint();
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    @Override
    public boolean paintBefore(Context context, Node node) {
        if (super.paintBefore(context, node)) {
            return true;
        }
        this.aain_ = context.g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (this.acont_ != VALUE_UNSET) {
            context.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.anti_ ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.fmin_ = context.g.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS);
        if (this.fcont_ != VALUE_UNSET) {
            context.g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.fract_ ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
        return false;
    }

    @Override
    public boolean paintAfter(Context context, Node node) {
        if (this.acont_ != VALUE_UNSET) {
            context.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.aain_);
        }
        if (this.fcont_ != VALUE_UNSET) {
            context.g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.fmin_);
        }
        return super.paintAfter(context, node);
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        String string = this.getAttr(ATTR_ANTIALIASING, VALUE_UNSET).intern();
        if (string == VALUE_USER) {
            string = VALUE_USER_ON;
        }
        this.acont_ = string;
        this.anti_ = VALUE_FORCE_ON == string || VALUE_USER_ON == string;
        string = this.getAttr(ATTR_FRACTIONAL_METRICS, VALUE_UNSET).intern();
        if (string == VALUE_USER) {
            string = VALUE_USER_ON;
        }
        this.fcont_ = string;
        this.fract_ = VALUE_FORCE_ON == string || VALUE_USER_ON == string;
        this.aatitle_ = this.getAttr(ATTR_AATITLE, AATITLE_DEFAULT);
    }
}

