/*
 * Decompiled with CFR 0.152.
 */
package multivalent.node;

import java.awt.AWTEvent;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import multivalent.CHashMap;
import multivalent.Context;
import multivalent.INode;
import multivalent.Leaf;
import multivalent.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeafImage
extends Leaf
implements ImageObserver {
    protected static Image Broken_;
    protected static Map<URI, SoftReference<Image>> cache_;
    Image image_ = Broken_;
    boolean loaded_ = true;
    boolean stop_ = false;
    int width_ = -1;
    int height_ = -1;

    public LeafImage(String string, Map<String, Object> map, INode iNode, Image image) {
        super(string, map, iNode);
        this.image_ = image != null ? image : Broken_;
    }

    public LeafImage(String string, Map<String, Object> map, INode iNode, URI uRI) {
        super(string, map, iNode);
        this.image_ = Broken_;
        this.setImage(uRI);
    }

    public Image getImage() {
        return this.image_;
    }

    public void setImage(Image image) {
        this.stop_ = false;
        if (image != null) {
            this.image_ = image;
            this.loaded_ = false;
        } else {
            this.image_ = Broken_;
            this.loaded_ = true;
        }
    }

    public void setImage(URI uRI) {
        this.loaded_ = true;
        this.stop_ = false;
        if (uRI == null) {
            this.image_ = Broken_;
        } else {
            try {
                ImageIO.setUseCache(false);
                if ("systemresource".equals(uRI.getScheme())) {
                    SoftReference<Image> softReference = cache_.get(uRI);
                    if (softReference != null && softReference.get() != null) {
                        this.image_ = softReference.get();
                    } else {
                        this.image_ = ImageIO.read(this.getClass().getResource(uRI.getPath()));
                        cache_.put(uRI, new SoftReference<Image>(this.image_));
                    }
                } else if ("file".equals(uRI.getScheme())) {
                    this.image_ = ImageIO.read(new File(uRI.getPath()));
                } else {
                    this.image_ = Toolkit.getDefaultToolkit().getImage(uRI.toURL());
                    this.loaded_ = false;
                }
            }
            catch (Exception exception) {
                this.image_ = Broken_;
                System.out.println(new StringBuffer().append("can't load image ").append(uRI).append(" => ").append(exception).toString());
            }
        }
    }

    public void setSize(int n, int n2) {
        this.width_ = n;
        this.height_ = n2;
    }

    @Override
    public int subelementHit(Point point) {
        return point.x < this.bbox.width / 2 ? 0 : 1;
    }

    @Override
    public boolean formatNodeContent(Context context, int n, int n2) {
        if (this.image_ != null && n == 0) {
            int n3 = this.image_.getWidth(this);
            int n4 = this.image_.getHeight(this);
            if (n3 != -1 && n4 != -1) {
                this.bbox.setSize(n3, n4);
                this.baseline = n4;
            } else {
                this.valid_ = false;
                this.bbox.setSize(10, 10);
                this.baseline = 10;
            }
            if (this.width_ != -1) {
                this.bbox.width = this.width_;
            }
            if (this.height_ != -1) {
                this.bbox.height = this.baseline = this.height_;
            }
        } else {
            this.bbox.setSize(0, 0);
        }
        return !this.valid_;
    }

    @Override
    public void reformat(Node node) {
        int n = this.image_.getWidth(this);
        int n2 = this.image_.getHeight(this);
        if (n != -1 && n2 != -1 && (n != this.bbox.width || n2 != this.bbox.height)) {
            this.markDirty();
            this.getBrowser().repaint(500L);
        }
    }

    @Override
    public boolean paintNodeContent(Context context, int n, int n2) {
        if (n == 0) {
            Graphics2D graphics2D = context.g;
            int n3 = this.image_.getWidth(this);
            int n4 = this.image_.getHeight(this);
            if (n3 != -1 && n4 != -1) {
                try {
                    int n5 = 0;
                    int n6 = Math.max(this.baseline - n4, 0);
                    graphics2D.drawImage(this.image_, n5, n6, n5 + (this.width_ != -1 ? this.width_ : n3), n6 + (this.height_ != -1 ? this.height_ : n4), 0, 0, n5 + n3, n6 + n4, this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            context.x += this.bbox.width;
        }
        return false;
    }

    @Override
    public boolean eventNode(AWTEvent aWTEvent, Point point) {
        if (aWTEvent.getID() == 2003) {
            this.stop_ = true;
        }
        return super.eventNode(aWTEvent, point);
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (!this.loaded_) {
            boolean bl = this.loaded_ = (n & 0x20) != 0;
            if (this.loaded_) {
                this.reformat(this);
            }
        }
        if ((n & 0x10) != 0) {
            if (!this.stop_) {
                this.repaint(100L);
            }
        } else if ((n & 0x20) != 0) {
            this.repaint(250L);
        } else if ((n & 0x40) != 0) {
            this.loaded_ = true;
        }
        return !this.loaded_;
    }

    @Override
    public void clipboardNode(StringBuffer stringBuffer) {
    }

    static {
        try {
            Broken_ = ImageIO.read(new CHashMap().getClass().getResource("/sys/images/broken.gif"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        cache_ = new HashMap<URI, SoftReference<Image>>(20);
    }
}

