/*
 * Decompiled with CFR 0.152.
 */
package multivalent.node;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.util.Map;
import multivalent.Context;
import multivalent.INode;
import multivalent.node.Fixed;
import multivalent.node.FixedLeafImage;
import multivalent.node.LeafText;
import phelps.awt.Colors;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedLeafOCR
extends LeafText
implements Fixed,
ImageObserver {
    public static final String SIGNAL = "viewOcrAs";
    public static final String MODE_IMAGE = "image";
    public static final String MODE_OCR = "ocr";
    Rectangle ibbox_;
    public int ibaseline;
    public Font font;
    FixedLeafImage imgnode_;

    public FixedLeafOCR(String string, Map<String, Object> map, INode iNode, FixedLeafImage fixedLeafImage, Rectangle rectangle) {
        super(string, map, iNode);
        this.ibbox_ = rectangle;
        this.imgnode_ = fixedLeafImage;
    }

    @Override
    public Rectangle getIbbox() {
        return this.ibbox_;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean formatNodeContent(Context context, int n, int n2) {
        if (n == 0) {
            this.bbox.setBounds(this.ibbox_);
        } else {
            this.bbox.setBounds(this.ibbox_.x, this.ibbox_.y, 0, 0);
        }
        this.baseline = this.ibaseline;
        return false;
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0x60) == 0;
    }

    @Override
    public boolean paintNodeContent(Context context, int n, int n2) {
        if (n >= this.size()) {
            return false;
        }
        String string = (String)context.signal.get(SIGNAL);
        Graphics2D graphics2D = context.g;
        if (MODE_IMAGE.equals(string) || string == null) {
            if (context.foreground == context.background && context.foreground != Colors.COLOR_TRANSPARENT) {
                graphics2D.setColor(context.foreground);
                graphics2D.fillRect(0, 0, this.bbox.width, this.bbox.height);
            } else {
                int n3 = this.bbox.height - this.ibbox_.height;
                Rectangle rectangle = this.imgnode_.getIbbox();
                int n4 = this.ibbox_.x - rectangle.x;
                int n5 = this.ibbox_.y - rectangle.y;
                int n6 = this.ibbox_.width;
                int n7 = this.ibbox_.height;
                graphics2D.drawImage(this.imgnode_.getImage(), 0, n3, 0 + n6, n3 + n7, n4, n5, n4 + n6, n5 + n7, context.background, this);
            }
        } else if (MODE_OCR.equals(string)) {
            if (context.background != Colors.COLOR_TRANSPARENT && context.background != null && !context.background.equals(context.pagebackground)) {
                graphics2D.setColor(context.background);
                graphics2D.fillRect(0, 0 + this.bbox.height - this.ibbox_.height, this.ibbox_.width, this.ibbox_.height);
            }
            if (context.foreground != Colors.COLOR_TRANSPARENT) {
                graphics2D.setFont(this.font != null ? this.font : context.getFont());
                graphics2D.setColor(context.foreground);
                graphics2D.drawString(this.name_, 0, this.baseline);
            }
        }
        context.x += this.bbox.width;
        return false;
    }

    @Override
    public void subelementCalc(Context context) {
        FixedLeafOCR.Widths_[0] = this.bbox.width;
    }

    @Override
    public int subelementHit(Point point) {
        return point.x < this.bbox.width / 2 ? 0 : this.size();
    }

    @Override
    public void clipboardNode(StringBuffer stringBuffer) {
        stringBuffer.append(this.name_);
        stringBuffer.append(' ');
    }

    @Override
    public void clipboardBeforeAfter(StringBuffer stringBuffer, int n, int n2) {
        stringBuffer.append(this.name_.substring(Math.max(n, 0), Math.min(n2, this.size())));
    }

    @Override
    public void dump(int n, int n2) {
        for (int i = 0; i < n; ++i) {
            System.out.print("\t ");
        }
        System.out.println(new StringBuffer().append(this.name_).append("/").append(this.childNum()).append(", class=").append(this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1)).append(", bbox=").append(this.bbox.width).append("x").append(this.bbox.height).append("@(").append(this.bbox.x).append(",").append(this.bbox.y).append(")/").append(this.baseline).append(", ibbox=").append(this.ibbox_.width).append("x").append(this.ibbox_.height).append("@(").append(this.ibbox_.x).append(",").append(this.ibbox_.y).append(")/").append(", sticky=").append(this.sticky_).append(", valid=").append(this.valid_).toString());
    }
}

