/*
 * Decompiled with CFR 0.152.
 */
package multivalent.net;

import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import multivalent.Behavior;
import multivalent.DocInfo;
import multivalent.ESISNode;
import multivalent.Layer;
import multivalent.Multivalent;
import multivalent.SemanticEvent;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeaders
extends Behavior {
    public static final String ATTR_USER_AGENT = "User-Agent";
    public static final String ATTR_ACCEPT_LANGUAGE = "Accept-Language";
    String agent_;
    String language_;

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        Object object = semanticEvent.getArg();
        if ("openDocument" == string && object instanceof DocInfo) {
            DocInfo docInfo = (DocInfo)object;
            String string2 = docInfo.uri.getScheme().toLowerCase();
            if ("http".equals(string2) || "https".equals(string2)) {
                this.setHeaders(docInfo.headers, docInfo);
            }
        }
        return false;
    }

    void setHeaders(Map<String, String> map, DocInfo docInfo) {
        map.put(ATTR_USER_AGENT, this.agent_);
        String string = map.get("Accept-Encoding");
        StringBuffer stringBuffer = new StringBuffer(string == null || string.length() == 0 ? "gzip" : string.toLowerCase());
        if (stringBuffer.indexOf("gzip") == -1) {
            stringBuffer.append(", gzip");
        }
        if (stringBuffer.indexOf("deflate") == -1) {
            stringBuffer.append(", deflate");
        }
        map.put("Accept-Encoding", stringBuffer.toString());
        String string2 = map.get("Accept");
        stringBuffer = new StringBuffer(string2 == null || string2.length() == 0 ? "text/html" : string2.toLowerCase());
        Iterator<String> iterator = Multivalent.getInstance().getGenreMap().keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = iterator.next().toLowerCase();
            if (string3.indexOf(47) == -1 || stringBuffer.indexOf(string3) != -1) continue;
            stringBuffer.append(", ").append(string3);
        }
        if (stringBuffer.indexOf("*/*") == -1) {
            stringBuffer.append(", */*");
        }
        map.put("Accept", stringBuffer.toString());
        map.put(ATTR_ACCEPT_LANGUAGE, this.language_);
        map.put("Accept-Charset", "ISO-8859-1, utf-8");
        map.put("Keep-Alive", "300");
        map.put("Connection", "keep-alive");
        Iterator<String> iterator2 = iterator = docInfo.doc != null ? docInfo.doc.getURI() : null;
        if (iterator != null && "http".equalsIgnoreCase(docInfo.uri.getScheme()) && ((URI)((Object)iterator)).getHost() != null && ((URI)((Object)iterator)).getAuthority().equalsIgnoreCase(docInfo.uri.getAuthority())) {
            docInfo.headers.put("Referer", ((URI)((Object)iterator)).toString());
        }
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        this.agent_ = this.getAttr(ATTR_USER_AGENT, "Multivalent/1.0");
        this.language_ = this.getAttr(ATTR_ACCEPT_LANGUAGE, "en-us");
    }
}

