/*
 * Decompiled with CFR 0.152.
 */
package multivalent.devel;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Node;
import multivalent.SemanticEvent;
import phelps.text.Formats;

public class Stats
extends Behavior {
    public static final String MSG_DUMP = "statsDump";

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if (MSG_DUMP == string) {
            this.dump();
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    void dumpAttrs(Layer layer, String string) {
        System.out.println("*** " + string + " ***");
        ArrayList<Layer> arrayList = new ArrayList<Layer>(10);
        arrayList.add(layer);
        boolean bl = false;
        boolean bl2 = false;
        while (!arrayList.isEmpty()) {
            Layer layer2 = (Layer)arrayList.remove(0);
            int n = layer2.size();
            for (int i = 0; i < n; ++i) {
                Behavior behavior = layer2.getBehavior(i);
                System.out.print(behavior.getName());
                Map<String, Object> map = behavior.getAttributes();
                if (map != null) {
                    int n2 = map.size();
                    System.out.print("\t");
                    System.out.print(n2);
                    if (n2 > 0) {
                        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<String, Object> entry = iterator.next();
                            System.out.print(",  " + entry.getKey() + "=" + entry.getValue());
                        }
                    } else {
                        System.out.print("\u0007");
                    }
                }
                System.out.println();
                if (!(behavior instanceof Layer)) continue;
                arrayList.add((Layer)behavior);
            }
        }
    }

    void dumpTree(INode iNode) {
        Node node;
        int n;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = iNode.size();
        for (n = 0; n < n2; ++n) {
            node = iNode.childAt(n);
            if (node instanceof INode) continue;
            Map<String, Object> map = node.getAttributes();
        }
        n2 = iNode.size();
        for (n = 0; n < n2; ++n) {
            node = iNode.childAt(n);
            if (!(node instanceof INode)) continue;
            this.dumpTree((INode)node);
        }
    }

    public void dump() {
        Browser browser = this.getBrowser();
        System.out.println(new Date());
        System.out.println();
        Runtime runtime = Runtime.getRuntime();
        System.out.println("Memory (pre-gc): " + Formats.prettySize(runtime.freeMemory()) + " free, " + Formats.prettySize(runtime.totalMemory()) + "  total");
        System.gc();
        System.out.println("Memory (post-gc): " + Formats.prettySize(runtime.freeMemory()) + " free, " + Formats.prettySize(runtime.totalMemory()) + " total");
        this.dumpAttrs(this.getDocument().getRoot().getLayers(), "System");
        this.dumpAttrs(this.getDocument().getLayers(), "Document");
    }
}

