/*
 * Decompiled with CFR 0.152.
 */
package multivalent.devel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import phelps.io.FileFilterPattern;
import phelps.io.FileList;
import phelps.lang.reflect.ClassFile;
import phelps.lang.reflect.Field_info;
import phelps.lang.reflect.Method_info;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Check {
    public static final String USAGE = "java devel.Check <class-or-directory...>";
    public static final String VERSION = "1.0";
    static String[] protonames;
    static ClassFile[][] protosigs;
    static String[] nprotonames;
    static ClassFile[][] nprotosigs;
    static final int LEVEL_ERROR = 0;
    static final int LEVEL_WARNING = 1;
    static final int LEVEL_PEDANTIC = 2;
    static final int LEVEL_VERBOSE = 4;
    static final int LEVEL_DISTRIB = 5;
    List<ClassFile> classes_;
    boolean[] shownote = new boolean[10];
    int level = 5;
    static final String[] census;
    static final String[] Census;
    ClassFile[] gcf_;
    List[] group_;
    List<String> seml_;
    static final Comparator<ClassFile> CFC;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$multivalent$devel$Check;

    public Check(FileList fileList) {
        long l = System.currentTimeMillis();
        this.classes_ = this.collect(fileList);
        long l2 = System.currentTimeMillis();
        System.out.println(new StringBuffer().append("class collection took ").append(l2 - l).append(" ms").toString());
        if (ClassFile.forName("multivalent.Behavior") == null) {
            // empty if block
        }
        if (this.classes_.size() == 0) {
            System.err.println("no classes");
        }
    }

    List<ClassFile> collect(FileList fileList) {
        ArrayList<ClassFile> arrayList = new ArrayList<ClassFile>(200);
        Iterator<File> iterator = fileList.breadthFirstIterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            String string = file.getName();
            try {
                if (string.endsWith(".jar")) {
                    this.collectJar(file, arrayList);
                    continue;
                }
                this.collectClassFile(new ClassFile(file), arrayList);
            }
            catch (IOException iOException) {
                System.out.println(new StringBuffer().append("can't load ").append(file).append(": ").append(iOException).toString());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectJar(File file, List<ClassFile> list) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (!zipEntry.getName().endsWith(".class")) continue;
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            try {
                this.collectClassFile(new ClassFile(inputStream), list);
            }
            catch (IOException iOException) {
                System.out.println(new StringBuffer().append("can't load ").append(file).append(" / ").append(zipEntry.getName()).toString());
            }
            finally {
                inputStream.close();
            }
        }
        zipFile.close();
    }

    private void collectClassFile(ClassFile classFile, List<ClassFile> list) {
        String string = classFile.getName();
        if (string.indexOf(36) != -1) {
            return;
        }
        list.add(classFile);
        ClassFile.putPool(classFile);
    }

    boolean warning(boolean bl, String string) {
        return this.warning(bl, string, -1);
    }

    boolean warning(boolean bl, String string, int n) {
        if (!bl && this.level >= 1) {
            System.out.print(new StringBuffer().append("\tWARNING: ").append(string).toString());
            if (n >= 0) {
                System.out.print(new StringBuffer().append("  (note ").append(n).append(")").toString());
                this.shownote[n] = true;
            }
            System.out.println();
        }
        return bl;
    }

    boolean error(boolean bl, String string) {
        return this.error(bl, string, -1);
    }

    boolean error(boolean bl, String string, int n) {
        if (!bl && this.level >= 0) {
            System.out.print(new StringBuffer().append("\tERROR: ").append(string).toString());
            if (n >= 0) {
                System.out.print(new StringBuffer().append("  (note ").append(n).append(")").toString());
                this.shownote[n] = true;
            }
            System.out.println();
        }
        return bl;
    }

    void selfcheck(boolean bl, String string) {
        if (!bl) {
            System.out.println(new StringBuffer().append("SELFCHECK: ").append(string).toString());
        }
    }

    void dump(Class clazz) {
        System.out.println(new StringBuffer().append(clazz.getName()).append(" ").append(clazz.getClasses().length).append("/").append(clazz.getDeclaredClasses().length).append(", methods ").append(clazz.getMethods().length).append("/").append(clazz.getDeclaredMethods().length).toString());
    }

    void check() {
        this.shownote[0] = true;
        ClassFile classFile = ClassFile.forName("multivalent.Behavior");
        if (!$assertionsDisabled && classFile == null) {
            throw new AssertionError();
        }
        Arrays.sort(protonames);
        for (Method_info method_info : classFile.getDeclaredMethods()) {
            int n = Arrays.binarySearch(protonames, method_info.name);
            if (n < 0) continue;
            if (!$assertionsDisabled && protosigs[n] != null) {
                throw new AssertionError((Object)new StringBuffer().append("multivalent.Behavior overloads ").append(method_info.name).toString());
            }
            Check.protosigs[n] = method_info.getParameterTypes();
        }
        int n = protonames.length;
        for (int i = 0; i < n; ++i) {
            if (!$assertionsDisabled && protosigs[i] == null) {
                throw new AssertionError((Object)new StringBuffer().append("protocol ").append(protonames[i]).append(" not defined as method").toString());
            }
        }
        ClassFile classFile2 = ClassFile.forName("multivalent.Node");
        if (!$assertionsDisabled && classFile2 == null) {
            throw new AssertionError();
        }
        Arrays.sort(nprotonames);
        for (Method_info method_info : classFile2.getDeclaredMethods()) {
            int n2 = Arrays.binarySearch(nprotonames, method_info.name);
            if (n2 < 0) continue;
            if (!$assertionsDisabled && nprotosigs[n2] != null) {
                throw new AssertionError((Object)new StringBuffer().append("multivalent.Node overloads ").append(method_info.name).toString());
            }
            Check.nprotosigs[n2] = method_info.getParameterTypes();
        }
        int n3 = nprotonames.length;
        for (n = 0; n < n3; ++n) {
            if (!$assertionsDisabled && nprotosigs[n] == null) {
                throw new AssertionError((Object)new StringBuffer().append("protocol ").append(nprotonames[n]).append(" not defined as method").toString());
            }
        }
        n3 = this.classes_.size();
        for (n = 0; n < n3; ++n) {
            ClassFile classFile3 = this.classes_.get(n);
            this.checkClass(classFile3);
            if (classFile.isAssignableFrom(classFile3)) {
                this.checkBehavior(classFile3);
                continue;
            }
            if (!classFile2.isAssignableFrom(classFile3)) continue;
            this.checkNode(classFile3);
        }
    }

    void checkClass(ClassFile classFile) {
        for (Field_info field_info : classFile.fields) {
            if (!field_info.name.startsWith("MSG_")) continue;
            if ((field_info.access_flags & 1) != 0) {
                if ((field_info.access_flags & 8) != 0) {
                    if ((field_info.access_flags & 0x10) != 0 && "Ljava/lang/String;".equals(field_info.descriptor)) continue;
                }
            }
            this.warning(false, new StringBuffer().append(classFile.getName()).append(" ").append(field_info.name).append(" not 'public static final String'").toString());
        }
    }

    void checkBehavior(ClassFile classFile) {
        System.out.println(new StringBuffer().append("behavior ").append(classFile.getName()).toString());
        int n = classFile.getModifiers();
        this.error(Modifier.isAbstract(n) || Modifier.isPublic(n), "class must be public", 1);
        Method_info[] method_infoArray = classFile.getDeclaredMethods();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = method_infoArray.length;
        for (int i = 0; i < n2; ++i) {
            Method_info method_info = method_infoArray[i];
            if (!"<init>".equals(method_info.name)) continue;
            if ("()V".equals(method_info.descriptor)) {
                bl = true;
                continue;
            }
            bl2 = true;
            this.warning(false, "don't define non-null constructors on behaviors", 1);
        }
        if (!bl2 || !bl) {
            // empty if block
        }
        this.checkProto(method_infoArray, protonames, protosigs);
    }

    void checkNode(ClassFile classFile) {
        System.out.println(new StringBuffer().append("node ").append(classFile.getName()).toString());
        Method_info[] method_infoArray = classFile.getDeclaredMethods();
        this.checkProto(method_infoArray, nprotonames, nprotosigs);
    }

    void checkProto(Method_info[] method_infoArray, String[] stringArray, ClassFile[][] classFileArray) {
        for (Method_info method_info : method_infoArray) {
            ClassFile[] classFileArray2;
            String string = method_info.name;
            int n = Arrays.binarySearch(stringArray, string);
            if (n < 0) continue;
            boolean bl = false;
            ClassFile[] classFileArray3 = method_info.getParameterTypes();
            bl = classFileArray3.length != (classFileArray2 = classFileArray[n]).length;
            int n2 = classFileArray3.length;
            for (int i = 0; i < n2 && !bl; ++i) {
                bl = !classFileArray2[i].isAssignableFrom(classFileArray3[i]);
            }
            if (!bl) continue;
            String string2 = new StringBuffer().append("overloaded protocol ").append(string).append("(").append(method_info.descriptor).append(") -- system won't call it").toString();
            this.warning(!bl, string2, 2);
        }
    }

    void inspect() {
        int n;
        int n2 = census.length;
        this.gcf_ = new ClassFile[n2];
        for (n = 0; n < n2; ++n) {
            this.gcf_[n] = ClassFile.forName(census[n]);
        }
        this.group_ = new List[n2];
        for (n = 0; n < n2; ++n) {
            this.group_[n] = new ArrayList(100);
        }
        this.seml_ = new ArrayList<String>(200);
        int n3 = this.classes_.size();
        for (n = 0; n < n3; ++n) {
            ClassFile classFile = this.classes_.get(n);
            String string = classFile.getName();
            for (int i = 0; i < n2; ++i) {
                if (!classFile.isAssignableFrom(this.gcf_[i])) continue;
                this.group_[i].add(classFile);
                break;
            }
            ArrayList<String> arrayList = new ArrayList<String>(10);
            for (Field_info field_info : classFile.fields) {
                String string2 = field_info.name;
                if (!string2.startsWith("MSG_")) continue;
                arrayList.add(string2);
            }
            if (arrayList.size() <= 0) continue;
            this.seml_.add(string);
            this.seml_.addAll(arrayList);
        }
    }

    void report(PrintStream printStream) {
        int n;
        this.inspect();
        printStream.println("<html>\n<body>\n");
        int n2 = census.length;
        for (int i = 0; i < n2; ++i) {
            List list = this.group_[i];
            if (list.size() == 0) continue;
            Collections.sort(list, CFC);
            printStream.println(new StringBuffer().append("\n\n<h3>").append(Census[i]).append(" (").append(list.size()).append(")</h3>").toString());
            int n3 = list.size();
            for (n = 0; n < n3; ++n) {
                ClassFile classFile = (ClassFile)list.get(n);
                if (n > 0) {
                    printStream.println(", ");
                }
                String string = classFile.getName();
                int n4 = string.lastIndexOf(46);
                printStream.print(new StringBuffer().append("<a href='").append(string.replace('.', '/')).append("'>").append(n4 != -1 ? string.substring(n4 + 1) : string).append("</a>").toString());
            }
        }
        if (this.seml_.size() > 0) {
            printStream.println("\n\n<h2>Semantic Events</h2>\n");
            printStream.println("<ul>\n");
            String string = null;
            int n5 = this.seml_.size();
            n = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                String string2 = this.seml_.get(n2);
                if (string2.startsWith("MSG_")) {
                    if (n > 0) {
                        printStream.print(", ");
                    }
                    printStream.print(new StringBuffer().append("<a href='").append(string).append("#").append(string2).append("'>").append(string2.substring("MSG_".length())).append("</a>").toString());
                    ++n;
                    continue;
                }
                if (string != null) {
                    printStream.println();
                }
                string = string2.replace('.', '/');
                n = 0;
                printStream.println(new StringBuffer().append("<li>").append(string2).append(":").toString());
            }
            printStream.println("</ul>\n");
        }
        printStream.println("");
        printStream.println("");
        printStream.println("");
        printStream.println("</body>\n</html>");
    }

    public static void main(String[] stringArray) {
        Object object;
        int n;
        PrintStream printStream = System.out;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && ((String)(object = stringArray[n])).startsWith("-"); ++n) {
            if (!((String)object).startsWith("-out")) {
                try {
                    printStream = new PrintStream(new FileOutputStream(stringArray[++n]));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(new StringBuffer().append("can't write to ").append(stringArray[n]).append(": ").append(fileNotFoundException).toString());
                    System.exit(1);
                }
                continue;
            }
            if (((String)object).startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (((String)object).startsWith("-help")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println(USAGE);
            System.exit(1);
        }
        object = new FileList(stringArray, n, new FileFilterPattern("\\.(class|jar)$"));
        Check check = new Check((FileList)object);
        check.check();
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$multivalent$devel$Check == null ? (class$multivalent$devel$Check = Check.class$("multivalent.devel.Check")) : class$multivalent$devel$Check).desiredAssertionStatus();
        protonames = new String[]{"restore", "save", "buildBefore", "buildAfter", "formatBefore", "formatAfter", "paintBefore", "paintAfter", "eventBefore", "eventAfter", "clipboardBefore", "clipboardAfter", "undo", "redo", "destroy", "checkRep"};
        protosigs = new ClassFile[protonames.length][];
        nprotonames = new String[]{"formatBeforeAfter", "formatNode", "paintBeforeAfter", "paintNode", "clipboardBeforeAfter", "clipboardNode", "eventBeforeAfter", "eventNode", "checkRep"};
        nprotosigs = new ClassFile[nprotonames.length][];
        census = new String[]{"multivalent.Span", "multivalent.std.lens.Lens", "multivalent.MediaAdaptor", "multivalent.Behavior", "multivalent.Node"};
        Census = new String[]{"Spans", "Lenses", "Media Adaptors", "Other Behaviors", "Nodes"};
        CFC = new Comparator<ClassFile>(){

            @Override
            public int compare(ClassFile classFile, ClassFile classFile2) {
                String string = classFile.getName();
                String string2 = classFile2.getName();
                int n = string.lastIndexOf(46);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                if ((n = string2.lastIndexOf(46)) != -1) {
                    string2 = string2.substring(n + 1);
                }
                return String.CASE_INSENSITIVE_ORDER.compare(string, string2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.compare((ClassFile)object, (ClassFile)object2);
            }
        };
    }
}

