/*
 * Decompiled with CFR 0.152.
 */
package multivalent;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import javax.imageio.ImageIO;
import multivalent.Browser;
import multivalent.CHashMap;
import multivalent.Cache;
import phelps.net.URIs;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Multivalent {
    public static final boolean DEVEL = false;
    public static final String VERSION;
    public static final boolean MONITOR = false;
    public static final String MSG_EXIT = "EXIT";
    public static final String FILENAME_PREFERENCES = "Preferences.txt";
    public static final String PREF_CACHEDIR = "CACHEDIR";
    public static final URI HOME_SITE;
    private static Multivalent instance_;
    private static boolean standalone_;
    private static ClassLoader cl_;
    CHashMap<String> defadaptor_;
    CHashMap<String> adaptor_ = new CHashMap(100);
    HashMap<String, String> defberemap_;
    HashMap<String, String> beremap_ = new HashMap(100);
    CHashMap<String> defpref_;
    CHashMap<String> pref_ = new CHashMap(100);
    List<Browser> browsers_ = new ArrayList<Browser>(5);
    Cache cache_ = null;
    Timer timer_ = null;
    static /* synthetic */ Class class$multivalent$Multivalent;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Multivalent() {
    }

    public static Multivalent getInstance() {
        if (instance_ == null) {
            if (standalone_) {
                System.out.println(new StringBuffer().append("VERSION = ").append(VERSION).toString());
            }
            cl_ = new URLClassLoader(Multivalent.findJARs(), (class$multivalent$Multivalent == null ? (class$multivalent$Multivalent = Multivalent.class$("multivalent.Multivalent")) : class$multivalent$Multivalent).getClassLoader());
            instance_ = new Multivalent();
            instance_.readTables();
        }
        return instance_;
    }

    private static URL[] findJARs() {
        String string;
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                String string2 = string.toLowerCase();
                return string2.endsWith(".jar") && !string2.startsWith("multivalent") && new File(file, string).canRead();
            }
        };
        String string2 = URIs.decode((class$multivalent$Multivalent == null ? (class$multivalent$Multivalent = Multivalent.class$("multivalent.Multivalent")) : class$multivalent$Multivalent).getResource("Multivalent.class").toString());
        if (string2.startsWith("jar:")) {
            string2 = string2.substring("jar:file:".length(), string2.indexOf(33));
            string = string2.substring(0, string2.lastIndexOf(47) + 1);
        } else {
            int n = string2.lastIndexOf(47);
            n = string2.lastIndexOf(47, n - 1);
            string = string2 = string2.substring("file:".length(), n + 1);
        }
        ArrayList<URL> arrayList = new ArrayList<URL>(20);
        if (standalone_) {
            System.out.println(new StringBuffer().append("Searching for JARs in ").append(string).toString());
        }
        try {
            File[] fileArray = new File(string).listFiles(filenameFilter);
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList.add(fileArray[i].toURL());
                if (!standalone_) continue;
                System.out.println(new StringBuffer().append("\t").append(fileArray[i]).toString());
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(malformedURLException);
            System.err.println("Move to different directory");
            System.exit(1);
        }
        return arrayList.toArray(new URL[0]);
    }

    public Map<String, String> getGenreMap() {
        return this.adaptor_;
    }

    public ClassLoader getJARsClassLoader() {
        return cl_;
    }

    public Cache getCache() {
        return this.cache_;
    }

    public Timer getTimer() {
        if (this.timer_ == null) {
            this.timer_ = new Timer();
        }
        return this.timer_;
    }

    public String remapBehavior(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        String string2 = this.beremap_.get(string);
        return string2 != null ? string2 : string;
    }

    public final String getPreference(String string, String string2) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        String string3 = this.pref_.get(string);
        if (string3 == null && string2 != null) {
            string3 = string2;
            this.putPreference(string, string3);
        }
        return string3;
    }

    public final void putPreference(String string, String string2) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        this.pref_.put(string, string2);
    }

    public final void removePreference(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        this.pref_.remove(string);
    }

    public final Iterator<String> prefKeyIterator() {
        return this.pref_.keySet().iterator();
    }

    void readPreferences(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.resetSyntax();
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.wordChars(33, 126);
        streamTokenizer.commentChar(35);
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.slashStarComments(true);
        streamTokenizer.quoteChar(34);
        try {
            int n = streamTokenizer.nextToken();
            while (n != -1) {
                if (n == 10) {
                    n = streamTokenizer.nextToken();
                    continue;
                }
                String string = streamTokenizer.sval;
                if (string != null) {
                    string = string.intern();
                }
                streamTokenizer.nextToken();
                String string2 = streamTokenizer.sval;
                streamTokenizer.nextToken();
                String string3 = streamTokenizer.sval;
                if ("mediaadaptor" == string) {
                    this.adaptor_.put(string2.toLowerCase(), string3);
                } else if ("remap" == string) {
                    this.beremap_.put(string2, string3);
                } else if ("set" == string) {
                    this.putPreference(string2, string3);
                }
                while ((n = streamTokenizer.nextToken()) != 10 && n != 59 && n != -1) {
                }
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println(new StringBuffer().append("can't read prefs ").append(iOException).toString());
        }
    }

    void writePreferences() {
        try {
            File file = this.getCache().mapTo(null, FILENAME_PREFERENCES, 2);
            System.out.println(new StringBuffer().append("writing preferences to ").append(file).toString());
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("# If line begins with '#', command is commented out\n\n\n");
            this.writePrefTable(bufferedWriter, this.adaptor_, this.defadaptor_, "mediaadaptor");
            bufferedWriter.write("# ... otherwise interpreted as ASCII\n\n\n");
            this.writePrefTable(bufferedWriter, this.beremap_, this.defberemap_, "remap");
            bufferedWriter.write("\n\n\n");
            this.writePrefTable(bufferedWriter, this.pref_, this.defpref_, "set");
            bufferedWriter.write("\n\n\n");
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            System.err.println(new StringBuffer().append("Couldn't write Preferences: ").append(iOException).toString());
        }
    }

    void writePrefTable(Writer writer, Map<String, String> map, Map<String, String> map2, String string) throws IOException {
        if (!($assertionsDisabled || writer != null && map != null && map2 != null && string != null)) {
            throw new AssertionError();
        }
        Object[] objectArray = map.keySet().toArray();
        Arrays.sort(objectArray);
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            String string2;
            String string3 = (String)objectArray[i];
            String string4 = map.get(string3);
            if (string4.equals(string2 = map2.get(string3))) {
                writer.write("#");
            }
            String string5 = string4.indexOf(32) == -1 ? "" : "\"";
            writer.write(new StringBuffer().append(string).append("\t").append(string3).append("\t").append(string5).append(string4).append(string5).append("\n").toString());
        }
    }

    public Browser getBrowser(String string) {
        return this.getBrowser(string, "System");
    }

    public Browser getBrowser(String string, String string2) {
        if (!$assertionsDisabled && string2 == null) {
            throw new AssertionError();
        }
        if (string != null && !"_NEW".equals(string)) {
            int n = this.browsers_.size();
            for (int i = 0; i < n; ++i) {
                Browser browser = this.browsers_.get(i);
                if (!string.equals(browser.getName())) continue;
                return browser;
            }
        }
        Browser browser = new Browser(string, string2, standalone_);
        this.browsers_.add(browser);
        if (standalone_) {
            // empty if block
        }
        return browser;
    }

    public Iterator<Browser> browsersIterator() {
        return this.browsers_.iterator();
    }

    void removeBrowser(Browser browser) {
        if (!$assertionsDisabled && this.browsers_.indexOf(browser) == -1) {
            throw new AssertionError();
        }
        this.browsers_.remove(browser);
        if (this.browsers_.size() == 0) {
            this.destroy();
        }
    }

    private void readTables() {
        String string;
        File file;
        Object object;
        Object object2;
        int n;
        String[] stringArray = ImageIO.getReaderMIMETypes();
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            this.adaptor_.put(stringArray[n].toLowerCase(), "RawImage");
        }
        stringArray = ImageIO.getReaderFormatNames();
        n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            object2 = stringArray[n].toLowerCase();
            if (this.adaptor_.get((String)object2) != null) continue;
            this.adaptor_.put((String)object2, "RawImage");
        }
        if (this.adaptor_.get("jpeg2000") != null && this.adaptor_.get("jp2") == null) {
            this.adaptor_.put("jp2", "RawImage");
        }
        this.putPreference("homedir", System.getProperty("user.home"));
        try {
            object = new HashMap<Object, Object>(13);
            Enumeration<URL> enumeration = cl_.getResources("sys/Preferences.txt");
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                if (object.get(object2) != null) continue;
                object.put(object2, object2);
                this.readPreferences(((URL)object2).openStream());
            }
        }
        catch (IOException iOException) {
            System.err.println(new StringBuffer().append("startup: ").append(iOException).toString());
        }
        this.defadaptor_ = (CHashMap)this.adaptor_.clone();
        this.defberemap_ = (HashMap)this.beremap_.clone();
        this.defpref_ = (CHashMap)this.pref_.clone();
        object = System.getProperty("user.home");
        String string2 = System.getProperty("user.name");
        if (!((String)object).endsWith(string2)) {
            object = new StringBuffer().append((String)object).append(File.separatorChar).append(string2).toString();
        }
        object = new StringBuffer().append((String)object).append(File.separatorChar).append(".Multivalent").toString();
        object2 = new File((String)object);
        File file2 = new File((File)object2, FILENAME_PREFERENCES);
        if (standalone_) {
            System.out.println(new StringBuffer().append("HOME = ").append((String)object).toString());
        }
        if (file2.exists()) {
            try {
                this.readPreferences(new FileInputStream(file2));
            }
            catch (IOException iOException) {
                System.out.println(new StringBuffer().append("couldn't read user prefs: ").append(iOException).toString());
            }
        } else if (!((File)object2).exists()) {
            ((File)object2).mkdirs();
        }
        if (!(file = new File(string = this.getPreference(PREF_CACHEDIR, System.getProperty("java.io.tmpdir")))).exists()) {
            file.mkdirs();
        }
        this.cache_ = new Cache((String)object, string, this.adaptor_);
    }

    void destroy() {
        int n = this.browsers_.size();
        for (int i = 0; i < n; ++i) {
            this.browsers_.get(i).destroy();
        }
        this.writePreferences();
        File file = new File(System.getProperty("java.io.tmpdir"));
        for (String string : file.list()) {
            if ((!string.startsWith("font") || !string.endsWith(".ttf")) && !string.startsWith("+~JF") && (!string.startsWith("imageio") || !string.endsWith(".tmp"))) continue;
            new File(file, string).delete();
        }
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0 && stringArray[0].startsWith("-v")) {
            System.out.println(new StringBuffer().append("Multivalent Browser v").append(VERSION).toString());
            System.out.println(new StringBuffer().append("Home web site: ").append(HOME_SITE).toString());
            System.exit(0);
        }
        standalone_ = true;
        Multivalent multivalent = Multivalent.getInstance();
        Browser browser = multivalent.getBrowser("STARTUP");
        browser.eventq("goHome", null);
        File file = new File(".");
        for (String string : stringArray) {
            URI uRI = null;
            File file2 = new File(file, string);
            if (file2.canRead()) {
                uRI = file2.toURI();
            } else {
                try {
                    uRI = new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    System.out.println(new StringBuffer().append("not a File or URI: ").append(string).toString());
                }
            }
            if (uRI == null) continue;
            browser.eventq("openDocument", uRI);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$multivalent$Multivalent == null ? (class$multivalent$Multivalent = Multivalent.class$("multivalent.Multivalent")) : class$multivalent$Multivalent).desiredAssertionStatus();
        VERSION = (class$multivalent$Multivalent == null ? (class$multivalent$Multivalent = Multivalent.class$("multivalent.Multivalent")) : class$multivalent$Multivalent).getPackage().getSpecificationVersion();
        HOME_SITE = URI.create("http://www.cs.berkeley.edu/~phelps/Multivalent/");
        instance_ = null;
        standalone_ = false;
    }
}

