/*
 * Decompiled with CFR 0.152.
 */
package multivalent;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import multivalent.Behavior;
import multivalent.Document;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.node.LeafAscii;

public abstract class MediaAdaptor
extends Behavior
implements Runnable {
    public static final int HINT_NO_TEXT = 1;
    public static final int HINT_NO_IMAGE = 2;
    public static final int HINT_NO_SHAPE = 4;
    public static final int HINT_EXACT = 8;
    public static final int HINT_FAST = 16;
    public static final int HINT_NO_DISPLAY = 32;
    public static final int HINT_NO_TRANSCLUSIONS = 256;
    public static final int HINT_DEFAULTS = 0;
    private int hints_ = 0;
    private InputStream is_ = null;
    public URI docURI = null;
    volatile boolean shown_ = false;
    volatile boolean loading_ = true;
    private boolean stop_ = false;

    public int getHints() {
        return this.hints_;
    }

    public void setHints(int n) {
        this.hints_ = n;
    }

    public void setInputStream(InputStream inputStream) {
        this.is_ = inputStream;
    }

    public void setInputStream(String string) {
        this.setInputStream(new ByteArrayInputStream(string.getBytes()));
    }

    protected InputStream getInputStream() {
        return this.is_;
    }

    public void closeInputStream() throws IOException {
        if (this.is_ != null) {
            this.is_.close();
            this.is_ = null;
        }
    }

    public abstract Object parse(INode var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parseHelper(String string, String string2, Layer layer, INode iNode) {
        MediaAdaptor mediaAdaptor = (MediaAdaptor)Behavior.getInstance("helper", string2, null, layer);
        Node node = null;
        try {
            mediaAdaptor.setInputStream(string);
            node = (Node)mediaAdaptor.parse(iNode);
        }
        catch (Exception exception) {
            new LeafAscii("ERROR " + exception, null, iNode);
            exception.printStackTrace();
        }
        finally {
            try {
                mediaAdaptor.closeInputStream();
            }
            catch (IOException iOException) {}
        }
        return node;
    }

    public boolean isAuthorized() {
        return true;
    }

    public void setPassword(String string) {
    }

    public void buildBefore(Document document) {
        try {
            this.parse(document);
        }
        catch (Exception exception) {
            new LeafAscii("build before " + exception, null, document);
            exception.printStackTrace();
        }
    }

    public void buildAfter(Document document) {
        try {
            this.closeInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if ("stopDocument" == string && semanticEvent.getArg() == this.getDocument()) {
            this.stop();
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    public void run() {
        this.loading_ = true;
        this.shown_ = false;
        this.stop_ = false;
        Object object = new LeafAscii("failed", null, null);
        try {
            object = this.parse(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loading_ = false;
        this.show(object);
    }

    void show(Object object) {
        Document document = this.getDocument();
        if (!this.shown_) {
            this.shown_ = true;
            if (object != null) {
                document.clear();
                document.appendChild((Node)object);
            }
        }
        document.repaint(100L);
    }

    public synchronized boolean isStopped() {
        return this.stop_;
    }

    public synchronized void stop() {
        if (this.isStopped() && this.loading_) {
            this.stop_ = true;
            this.getDocument().putAttr("stop", "stop");
        }
    }
}

