/*
 * Decompiled with CFR 0.152.
 */
package multivalent;

import java.awt.AWTEvent;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.util.Map;
import multivalent.Browser;
import multivalent.Context;
import multivalent.Document;
import multivalent.INode;
import multivalent.Leaf;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.gui.VScrollbar;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IScrollPane
extends INode {
    public static final String MSG_SCROLL_TO = "scrollTo";
    public static final String MSG_FORMATTED = "formattedPane";
    public Rectangle ibbox = new Rectangle();
    public boolean editable = false;
    protected int wchars_ = 0;
    protected int hchars_ = 0;
    boolean wexp_ = false;
    boolean hexp_ = false;
    VScrollbar vsb_ = new VScrollbar(0);
    VScrollbar hsb_ = new VScrollbar(1);
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$multivalent$IScrollPane;

    public IScrollPane(String string, Map<String, Object> map, INode iNode) {
        super(string, map, iNode);
        this.vsb_.setParentNode(this);
        this.hsb_.setParentNode(this);
        this.bbox.setSize(0, 0);
    }

    @Override
    public IScrollPane getIScrollPane() {
        return this;
    }

    @Override
    public int dx() {
        return super.dx() - this.getHsb().getValue();
    }

    @Override
    public int dy() {
        return super.dy() - this.getVsb().getValue();
    }

    public VScrollbar getVsb() {
        return this.vsb_;
    }

    public VScrollbar getHsb() {
        return this.hsb_;
    }

    public void setScrollbarShowPolicy(byte by) {
        this.getVsb().setShowPolicy(by);
        this.getHsb().setShowPolicy(by);
    }

    public void setSizeChars(int n, int n2) {
        if (!($assertionsDisabled || n >= 0 && n2 >= 0)) {
            throw new AssertionError((Object)new StringBuffer().append(n).append("x").append(n2).toString());
        }
        this.wchars_ = n;
        if (n == 0) {
            this.bbox.width = 0;
            this.wexp_ = false;
        }
        this.hchars_ = n2;
        if (n2 == 0) {
            this.bbox.height = 0;
            this.hexp_ = false;
        }
    }

    @Override
    public boolean formatNode(int n, int n2, Context context) {
        boolean bl;
        byte by = this.getVsb().getShowPolicy();
        byte by2 = this.getVsb().getShowPolicy();
        boolean bl2 = by != 0;
        boolean bl3 = by2 != 0;
        int n3 = this.bbox.x;
        int n4 = this.bbox.y;
        int n5 = this.bbox.width;
        int n6 = this.bbox.height;
        if (this.wchars_ >= 1) {
            n5 = this.wchars_ * context.getFontMetrics().charWidth('X') + (bl2 ? VScrollbar.SIZE : 0);
        } else if (this.wexp_ || n5 <= 0) {
            n5 = n;
            this.wexp_ = true;
        }
        if (this.hchars_ >= 1) {
            n6 = this.hchars_ * context.getFontMetrics().getHeight() + (bl3 ? VScrollbar.SIZE : 0);
        } else if (this.hexp_ || n6 <= 0) {
            n6 = n2;
            this.hexp_ = true;
        }
        int n7 = n5 - (bl2 ? VScrollbar.SIZE : 0);
        int n8 = n6 - (bl3 ? VScrollbar.SIZE : 0);
        boolean bl4 = super.formatNode(n7, n8, context);
        int n9 = this.bbox.x + this.bbox.width;
        int n10 = this.bbox.y + this.bbox.height;
        this.ibbox.setBounds(0, 0, n9, n10);
        this.bbox.setBounds(n3, n4, n5, n6);
        boolean bl5 = 2 == by || 1 == by && this.ibbox.height > n8;
        boolean bl6 = bl = 2 == by2 || 1 == by2 && this.ibbox.width > n7;
        if (1 == by2 && 1 == by && this.ibbox.width <= n5 && this.ibbox.height <= n6) {
            bl = false;
            bl5 = false;
        } else {
            if (1 == by && !bl) {
                boolean bl7 = bl5 = this.ibbox.height > n6;
            }
            if (1 == by2 && !bl5) {
                bl = this.ibbox.width > n5;
            }
        }
        this.vsb_.markDirtySubtreeDown(true);
        this.vsb_.formatBeforeAfter(VScrollbar.SIZE, bl ? n8 : n6, context);
        this.vsb_.bbox.setLocation(n7, 0);
        this.vsb_.setMinMax(0, this.ibbox.height);
        this.hsb_.markDirtySubtreeDown(true);
        this.hsb_.formatBeforeAfter(bl5 ? n7 : n5, VScrollbar.SIZE, context);
        this.hsb_.bbox.setLocation(0, n8);
        this.hsb_.setMinMax(0, this.ibbox.width);
        Browser browser = this.getBrowser();
        browser.event(new SemanticEvent(browser, MSG_FORMATTED, this));
        return bl4;
    }

    @Override
    public void paintBeforeAfter(Rectangle rectangle, Context context) {
        if (!this.isValid()) {
            if (this.size() == 0) {
                new Leaf("", null, this);
            }
            this.formatBeforeAfter(this.bbox.width, this.bbox.height, context);
        }
        super.paintBeforeAfter(rectangle, context);
    }

    @Override
    public void paintNode(Rectangle rectangle, Context context) {
        Graphics2D graphics2D = context.g;
        int n = this.bbox.width;
        int n2 = this.bbox.height;
        Rectangle rectangle2 = graphics2D.getClipBounds();
        int n3 = this.getHsb().getValue();
        int n4 = this.getVsb().getValue();
        int n5 = this.padding.left;
        int n6 = this.padding.right;
        int n7 = this.padding.top;
        int n8 = this.padding.bottom;
        int n9 = this.border.left;
        int n10 = this.border.right;
        int n11 = this.border.top;
        int n12 = this.border.bottom;
        if (context.background != null) {
            graphics2D.setColor(context.background);
            graphics2D.fillRect(n3 - n5, n4 - n7, n - n9 - n10, n2 - n11 - n12);
        }
        graphics2D.clipRect(n3 - n9 - n5, n4 - n11 - n7, n, n2);
        super.paintNode(rectangle, context);
        graphics2D.setClip(rectangle2);
        graphics2D.translate(n3, n4);
        rectangle.translate(-n3, -n4);
        this.vsb_.paintBeforeAfter(rectangle, context);
        this.hsb_.paintBeforeAfter(rectangle, context);
        graphics2D.translate(-n3, -n4);
        rectangle.translate(n3, n4);
    }

    @Override
    public boolean eventNode(AWTEvent aWTEvent, Point point) {
        boolean bl = false;
        int n = this.getHsb().getValue();
        int n2 = this.getVsb().getValue();
        if (point != null) {
            point.translate(-n, -n2);
        }
        bl = bl || this.vsb_.eventBeforeAfter(aWTEvent, point);
        boolean bl2 = bl = bl || this.hsb_.eventBeforeAfter(aWTEvent, point);
        if (point != null) {
            point.translate(n, n2);
        }
        if (!bl) {
            bl = super.eventNode(aWTEvent, point);
        }
        if (!bl) {
            Browser browser;
            int n3 = aWTEvent.getID();
            if (n3 == 507) {
                MouseWheelEvent mouseWheelEvent = (MouseWheelEvent)aWTEvent;
                int n4 = mouseWheelEvent.getScrollType();
                int n5 = n4 == 0 ? this.vsb_.getLineIncrement() : (n4 == 1 ? this.vsb_.getBlockIncrement() : 1);
                this.vsb_.setValue(this.vsb_.getValue() + n5 * mouseWheelEvent.getWheelRotation());
                bl = true;
            } else if (n3 == 501 && this.editable && (browser = this.getBrowser()).getScope() == null) {
                browser.setScope(this);
            }
        }
        return bl;
    }

    public void scrollBy(int n, int n2) {
        this.hsb_.setValue(this.hsb_.getValue() + n);
        this.vsb_.setValue(this.vsb_.getValue() + n2);
    }

    public void scrollTo(int n, int n2) {
        this.scrollTo(null, n, n2, false);
    }

    public void scrollTo(Node node, int n, int n2, boolean bl) {
        Document document = this.getDocument();
        if (!document.isValid()) {
            document.formatBeforeAfter(document.bbox.width, document.bbox.height, null);
        }
        if (node != null && this.contains(node)) {
            Point point = node.getRelLocation(this);
            n += point.x;
            n2 += point.y;
        }
        this.vsb_.setValue(n2, bl);
        this.hsb_.setValue(n, bl);
    }

    @Override
    public boolean checkRep() {
        if (!$assertionsDisabled && !super.checkRep()) {
            throw new AssertionError();
        }
        return true;
    }

    @Override
    public void dump(int n, int n2) {
        super.dump(n, n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$multivalent$IScrollPane == null ? (class$multivalent$IScrollPane = IScrollPane.class$("multivalent.IScrollPane")) : class$multivalent$IScrollPane).desiredAssertionStatus();
    }
}

