/*
 * Decompiled with CFR 0.152.
 */
package multivalent;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TimerTask;
import multivalent.Behavior;
import multivalent.Context;
import multivalent.ESISNode;
import multivalent.Layer;
import multivalent.Leaf;
import multivalent.Mark;
import multivalent.Multivalent;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.std.SyncTimerTask;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CursorMark
extends Behavior
implements Observer {
    public static final String MSG_SET = "setCursor";
    static SyncTimerTask stt = new SyncTimerTask();
    static boolean viz_;
    Mark posn_ = new Mark(null, -1, this);

    public Mark getMark() {
        return this.posn_;
    }

    public boolean isSet() {
        return this.posn_.isSet();
    }

    public void move(Mark mark) {
        if (mark == null) {
            this.move(null, -1);
        } else {
            this.move(mark.leaf, mark.offset);
        }
    }

    public void move(Leaf leaf, int n) {
        if (this.posn_.isSet()) {
            this.repaint(100L);
        }
        this.posn_.move(leaf, n);
        this.moved(50L);
    }

    public void move(int n) {
        if (this.posn_.isSet()) {
            this.repaint(100L);
        }
        this.posn_.move(n);
        this.moved(10L);
    }

    private void moved(long l) {
        if (this.posn_.isSet()) {
            viz_ = true;
            this.repaint(10L);
            this.getBrowser().eventq(MSG_SET, this);
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable == stt.getObservable()) {
            viz_ = (Boolean)object;
            this.repaint(100L);
        }
    }

    @Override
    public boolean paintAfter(Context context, Node node) {
        if (viz_) {
            Rectangle rectangle = node.bbox;
            Graphics2D graphics2D = context.g;
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawLine(context.x, 0, context.x, node.bbox.height);
        }
        return false;
    }

    public int getPriority() {
        return 100010;
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        stt.getObservable().addObserver(this);
    }

    @Override
    public void destroy() {
        this.move(null);
        stt.getObservable().deleteObserver(this);
        super.destroy();
    }

    public void repaint() {
        this.repaint(0L);
    }

    public void repaint(long l) {
        if (this.isSet()) {
            this.posn_.leaf.repaint(l);
        }
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        if ("closeDocument" == string && this.isSet() && this.getMark().leaf.getDocument() == semanticEvent.getArg()) {
            this.move(null);
        }
        return false;
    }

    static {
        Multivalent.getInstance().getTimer().schedule((TimerTask)stt, 1000L, 500L);
        viz_ = true;
    }
}

