/*
 * Decompiled with CFR 0.152.
 */
package multivalent;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import multivalent.ContextListener;
import multivalent.Document;
import multivalent.INode;
import multivalent.Leaf;
import multivalent.Mark;
import multivalent.Node;
import multivalent.StyleSheet;
import multivalent.node.LeafShadow;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Context {
    public static final int INT_INVALID = Integer.MIN_VALUE;
    public static final float FLOAT_INVALID = Float.MIN_VALUE;
    public static final float[] FLOATARRAY_INVALID;
    public static final Object OBJECT_INVALID;
    public static final String STRING_INVALID;
    public static final Color COLOR_INHERIT;
    public static final Color COLOR_INVALID;
    public static final byte BOOL_FALSE = 0;
    public static final byte BOOL_TRUE = 1;
    public static final byte BOOL_INHERIT = 2;
    public static final byte BOOL_INVALID = 3;
    public static final BasicStroke DEFAULT_STROKE;
    Toolkit toolkit_;
    private static Font defaultFont_;
    private static final int FONTCACHEMAX = 10;
    private static final int MAXDEPTH = 100;
    int cachelen_ = 0;
    Font[] fontcache_ = new Font[10];
    String[] fontfamreq_ = new String[10];
    FontMetrics[] fmcache_ = new FontMetrics[10];
    private List[] nodeCLs_ = new List[100];
    private int depth_ = 0;
    public boolean valid = false;
    public List<ContextListener> vactive_ = new ArrayList<ContextListener>(30);
    public Graphics2D g = null;
    List<ContextListener> base_ = new ArrayList<ContextListener>(10);
    public StyleSheet styleSheet = null;
    List<FloatContext> fcstack = new ArrayList<FloatContext>();
    FloatContext fc = new FloatContext();
    public double zoom;
    public int x;
    public int baseline;
    public int xdelta;
    public int ydelta;
    public Color xor;
    public Color foreground;
    public Color background;
    public Color strokeColor;
    public Color pagebackground;
    public float linewidth;
    public int linecap;
    public int linejoin;
    public float miterlimit;
    public float[] dasharray;
    public float dashphase;
    BasicStroke stroke;
    public String family;
    public float size;
    public int style;
    public AffineTransform textAT;
    public String texttransform;
    public String display;
    public Color underline;
    public Color underline2;
    public Color overline;
    public Color overstrike;
    public boolean elide;
    public int justify;
    public int spaceabove;
    public int spacebelow;
    public byte align;
    public byte valign;
    public byte floats;
    public byte flush = 0;
    Font font;
    FontMetrics fm;
    public int marginleft;
    public int marginright;
    public int margintop;
    public int marginbottom;
    public int paddingleft;
    public int paddingright;
    public int paddingtop;
    public int paddingbottom;
    public int borderleft;
    public int borderright;
    public int bordertop;
    public int borderbottom;
    public Map<Object, Object> signal = new HashMap<Object, Object>(10);
    private int lastx = -1;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$multivalent$Context;

    public Stroke getStroke() {
        if (this.stroke == null) {
            this.stroke = new BasicStroke(this.linewidth, this.linecap, this.linejoin, this.miterlimit, this.dasharray, this.dashphase);
        }
        return this.stroke;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    public Context(Toolkit toolkit) {
        this.toolkit_ = toolkit;
        this.fontcache_[0] = defaultFont_;
        this.fontfamreq_[0] = defaultFont_.getFamily();
        this.fmcache_[0] = this.toolkit_.getFontMetrics(defaultFont_);
        this.cachelen_ = 1;
        this.clear();
        this.valid = false;
    }

    public void clear() {
        this.zoom = 1.0;
        this.ydelta = 0;
        this.xdelta = 0;
        this.foreground = Color.BLACK;
        this.background = null;
        this.stroke = null;
        this.linewidth = DEFAULT_STROKE.getLineWidth();
        this.linecap = DEFAULT_STROKE.getEndCap();
        this.linejoin = DEFAULT_STROKE.getLineJoin();
        this.miterlimit = DEFAULT_STROKE.getMiterLimit();
        this.dasharray = DEFAULT_STROKE.getDashArray();
        this.dashphase = DEFAULT_STROKE.getDashPhase();
        this.family = defaultFont_.getFamily();
        this.size = defaultFont_.getSize2D();
        this.style = defaultFont_.getStyle();
        this.texttransform = STRING_INVALID;
        this.underline2 = this.overline = COLOR_INVALID;
        this.underline = this.overline;
        this.overstrike = COLOR_INVALID;
        this.elide = false;
        this.justify = 10;
        this.spacebelow = 0;
        this.spaceabove = 0;
        this.xor = null;
        this.signal.clear();
    }

    public void clearNonInherited() {
        this.marginbottom = 0;
        this.margintop = 0;
        this.marginright = 0;
        this.marginleft = 0;
        this.borderbottom = 0;
        this.bordertop = 0;
        this.borderright = 0;
        this.borderleft = 0;
        this.paddingbottom = 0;
        this.paddingtop = 0;
        this.paddingright = 0;
        this.paddingleft = 0;
        this.floats = 0;
        this.valign = 0;
        this.align = 0;
    }

    public void reset() {
        Serializable serializable;
        int n;
        int n2;
        int n3;
        this.clear();
        int n4 = n3 = this.vactive_ == null ? 0 : this.vactive_.size();
        for (n2 = 0; n2 < n3; ++n2) {
            this.vactive_.get(n2).appearance(this, false);
        }
        n2 = 0;
        float f = this.size * (float)this.toolkit_.getScreenResolution() / 72.0f;
        for (n = 0; n < this.cachelen_; ++n) {
            serializable = this.fontcache_[n];
            if (!this.fontfamreq_[n].equals(this.family) || ((Font)serializable).getStyle() != this.style || !((double)Math.abs(((Font)serializable).getSize2D() - f) < 0.01)) continue;
            this.font = serializable;
            this.fm = this.fmcache_[n];
            n2 = 1;
            break;
        }
        if (n2 == 0 && this.g != null) {
            n = Math.min(this.cachelen_, 9);
            System.arraycopy(this.fontcache_, 0, this.fontcache_, 1, n);
            System.arraycopy(this.fmcache_, 0, this.fmcache_, 1, n);
            System.arraycopy(this.fontfamreq_, 0, this.fontfamreq_, 1, n);
            serializable = new HashMap(5);
            serializable.put(TextAttribute.FAMILY, this.family);
            if ((this.style & 1) != 0) {
                serializable.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if ((this.style & 2) != 0) {
                serializable.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            serializable.put(TextAttribute.SIZE, new Float(f));
            this.fontcache_[0] = this.font = defaultFont_.deriveFont((Map<? extends AttributedCharacterIterator.Attribute, ?>)((Object)serializable));
            this.fontfamreq_[0] = this.family;
            this.fmcache_[0] = this.fm = this.g.getFontMetrics(this.font);
            if (this.cachelen_ < 10) {
                ++this.cachelen_;
            }
        }
        this.valid = true;
    }

    public void addBase(ContextListener contextListener) {
        if (this.base_.indexOf(contextListener) == -1) {
            Context.priorityInsert(contextListener, this.base_);
        }
        this.valid = false;
    }

    public void deleteBase(ContextListener contextListener) {
        this.base_.remove(contextListener);
        this.valid = false;
    }

    public void clearBase() {
        this.base_.clear();
        this.valid = false;
    }

    public void reset(Node node) {
        this.reset(node, -1);
    }

    public void reset(Mark mark) {
        this.reset(mark.leaf, mark.offset);
    }

    public void reset(Node node, int n) {
        if (node != null) {
            this.vactive_ = node.getActivesAt(n, this.base_, false);
            this.x = node.bbox.x;
            this.baseline = node.baseline;
        }
        this.reset();
    }

    public int floatStackSize() {
        return this.fc.q.size();
    }

    public void pushFloat() {
        this.fcstack.add(this.fc);
        this.fc = new FloatContext();
    }

    public void popFloat() {
        this.fc = this.fcstack.remove(this.fcstack.size() - 1);
    }

    void addFloat(Node node) {
        Document document;
        Node[] nodeArray;
        if (!$assertionsDisabled && node.floats == 10 && node.floats == 11) {
            throw new AssertionError(this.floats);
        }
        int n = node.bbox.height;
        if (this.fc.size == this.fc.act.length) {
            int n2 = this.fc.act.length + 5;
            nodeArray = new Node[n2];
            System.arraycopy(this.fc.act, 0, nodeArray, 0, this.fc.act.length);
            this.fc.act = nodeArray;
            int[] nArray = new int[n2];
            System.arraycopy(this.fc.htg, 0, nArray, 0, this.fc.htg.length);
            this.fc.htg = nArray;
        }
        if ((nodeArray = (document = node.getDocument()).getVisualLayer("floats", "multivalent.node.IRootAbs")).childNum() != 1) {
            nodeArray.remove();
            nodeArray.getParentNode().insertChildAt((Node)nodeArray, 1);
        }
        boolean bl = false;
        int n3 = nodeArray.size();
        for (int i = 0; i < n3; ++i) {
            Node node2 = nodeArray.childAt(i);
            if (!(node2 instanceof LeafShadow) || ((LeafShadow)node2).getShadowed() != node) continue;
            bl = true;
            break;
        }
        if (!bl) {
            new LeafShadow(node.getName(), null, (INode)nodeArray, node);
        }
        this.fc.act[this.fc.size] = node;
        this.fc.htg[this.fc.size] = n;
        if (node.floats == 10) {
            this.fc.leftw += node.bbox.width;
        } else {
            this.fc.rightw += node.bbox.width;
        }
        ++this.fc.size;
    }

    public void queueFloat(Node node) {
        this.fc.q.add(node);
    }

    public void flowFloats(int n, int n2) {
        int n3 = this.fc.q.size();
        for (int i = 0; i < n3; ++i) {
            Node node = this.fc.q.get(i);
            node.bbox.setLocation(node.floats == 10 ? this.fc.leftw : n2 - this.fc.rightw - node.bbox.width, n);
            this.addFloat(node);
        }
        this.fc.q.clear();
    }

    public int flushFloats(int n) {
        int n2 = 0;
        if (this.flush != 0) {
            n2 = this.getFloatHeightToGo(this.flush);
            this.eatHeight(n2, null, -1);
            this.flush = 0;
        }
        return n2;
    }

    public int getFloatWidth(int n) {
        if (n == 10) {
            return this.fc.leftw;
        }
        if (n == 11) {
            return this.fc.rightw;
        }
        if (n == 12) {
            return this.fc.leftw + this.fc.rightw;
        }
        return -1;
    }

    public int getFloatHeightToGo(int n) {
        int n2 = 0;
        int n3 = this.fc.size;
        for (int i = 0; i < n3; ++i) {
            if (n != 12 && n != this.fc.act[i].floats) continue;
            n2 = Math.max(n2, this.fc.htg[i]);
        }
        return n2;
    }

    public void eatHeight(int n, Node node, int n2) {
        int n3;
        int n4 = this.fc.size;
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.fc.htg[n3] <= 0) continue;
            int n5 = n3;
            this.fc.htg[n5] = this.fc.htg[n5] - n;
        }
        n3 = 1;
        n4 = 1;
        for (int i = this.fc.size - 1; i >= 0 && (n3 != 0 || n4 != 0); --i) {
            int n6;
            Node node2 = this.fc.act[i];
            byte by = node2.floats;
            int n7 = n6 = this.fc.htg[i] <= 0 ? 1 : 0;
            if (by == 10) {
                if (n6 != 0 && n3 != 0) {
                    this.fc.leftw -= node2.bbox.width;
                } else {
                    n6 = 0;
                    n3 = 0;
                }
            } else {
                if (!$assertionsDisabled && by != 11) {
                    throw new AssertionError(by);
                }
                if (n6 != 0 && n4 != 0) {
                    this.fc.rightw -= node2.bbox.width;
                } else {
                    n6 = 0;
                    n4 = 0;
                }
            }
            if (n6 == 0) continue;
            System.arraycopy(this.fc.act, i + 1, this.fc.act, i, this.fc.size - i - 1);
            System.arraycopy(this.fc.htg, i + 1, this.fc.htg, i, this.fc.size - i - 1);
            --this.fc.size;
        }
    }

    public static final int priorityInsert(ContextListener contextListener, List<ContextListener> list) {
        int n;
        int n2 = contextListener.getPriority();
        for (n = list.size(); n > 0 && n2 < list.get(n - 1).getPriority(); --n) {
        }
        list.add(n, contextListener);
        return n;
    }

    public final void add(ContextListener contextListener) {
        if (!$assertionsDisabled && contextListener == null) {
            throw new AssertionError();
        }
        int n = Context.priorityInsert(contextListener, this.vactive_);
        if (n + 1 == this.vactive_.size()) {
            contextListener.appearance(this, false);
        } else {
            this.reset();
        }
    }

    public final void remove(ContextListener contextListener) {
        int n = this.vactive_.indexOf(contextListener);
        if (n != -1) {
            this.vactive_.remove(n);
            this.reset();
        }
    }

    public final void addq(ContextListener contextListener) {
        Context.priorityInsert(contextListener, this.vactive_);
        this.valid = false;
    }

    public final void removeq(ContextListener contextListener) {
        this.vactive_.remove(contextListener);
        this.valid = false;
    }

    public boolean paintBefore(Context context, INode iNode) {
        Insets insets;
        int n;
        ArrayList<ContextListener> arrayList = this.nodeCLs_[this.depth_];
        if (arrayList == null) {
            this.nodeCLs_[this.depth_] = arrayList = new ArrayList<ContextListener>(5);
        } else {
            arrayList.clear();
        }
        Color color = COLOR_INVALID;
        if (iNode.name_ != null) {
            this.styleSheet.activesAdd(arrayList, iNode, iNode.getParentNode());
            if (arrayList.size() > 0) {
                this.clearNonInherited();
                this.background = COLOR_INVALID;
                n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    ContextListener contextListener = (ContextListener)arrayList.get(i);
                    this.addq(contextListener);
                    contextListener.appearance(context, true);
                }
                color = this.background;
                this.reset();
            }
        }
        Rectangle rectangle = iNode.bbox;
        n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (color != COLOR_INVALID) {
            if (color != null) {
                this.g.setColor(color);
                this.g.fillRect(n, n2, n3, n4);
            }
            this.pagebackground = color;
        }
        if ((insets = iNode.border) != INode.INSETS_ZERO) {
            this.g.setColor(this.foreground == Color.BLACK && this.background != Color.LIGHT_GRAY ? Color.LIGHT_GRAY : this.foreground);
            if (insets.left > 0) {
                this.g.fillRect(n, n2, insets.left, n4);
            }
            if (insets.right > 0) {
                this.g.fillRect(n + n3 - insets.right, n2, insets.right, n4);
            }
            if (insets.top > 0) {
                this.g.fillRect(n, n2, n3, insets.top);
            }
            if (insets.bottom > 0) {
                this.g.fillRect(n, n2 + n4 - insets.bottom, n3, insets.bottom);
            }
        }
        ++this.depth_;
        return false;
    }

    public boolean paintAfter(Context context, INode iNode) {
        --this.depth_;
        List list = this.nodeCLs_[this.depth_];
        if (list.size() > 0) {
            List<ContextListener> list2 = this.vactive_;
            for (int i = list.size() - 1; i >= 0; --i) {
                list2.remove(list.get(i));
            }
            if (this.valid) {
                this.reset();
            } else {
                this.valid = false;
            }
        }
        return false;
    }

    public void paintBefore(Context context, Leaf leaf) {
        this.lastx = context.x;
        if (this.xor == null) {
            this.g.setPaintMode();
        } else {
            this.g.setXORMode(this.xor);
        }
    }

    public void paintAfter(Context context, Leaf leaf) {
        if (this.xor != null) {
            this.g.setPaintMode();
        }
        this.baseline = leaf.baseline;
        if (this.underline != COLOR_INVALID) {
            this.g.setStroke(DEFAULT_STROKE);
            this.g.setColor(this.underline == COLOR_INHERIT ? this.foreground : this.underline);
            this.g.drawLine(this.lastx, this.baseline + 1, this.x, this.baseline + 1);
        }
        if (this.underline2 != COLOR_INVALID) {
            this.g.setStroke(DEFAULT_STROKE);
            this.g.setColor(this.underline2 == COLOR_INHERIT ? this.foreground : this.underline2);
            this.g.drawLine(this.lastx, this.baseline + 3, this.x, this.baseline + 3);
        }
        if (this.overline != COLOR_INVALID) {
            this.g.setStroke(DEFAULT_STROKE);
            this.g.setColor(this.overline == COLOR_INHERIT ? this.foreground : this.overline);
            this.g.drawLine(this.lastx, 0, this.x, 0);
        }
        if (this.overstrike != COLOR_INVALID) {
            int n = this.baseline - 4;
            this.g.setStroke(DEFAULT_STROKE);
            this.g.setColor(this.overstrike == COLOR_INHERIT ? this.foreground : this.overstrike);
            this.g.drawLine(this.lastx, n, this.x, n);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append(this.family).append(':').append(this.size).append('|').append(this.font.getSize2D()).append(':').append(this.style);
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$multivalent$Context == null ? (class$multivalent$Context = Context.class$("multivalent.Context")) : class$multivalent$Context).desiredAssertionStatus();
        FLOATARRAY_INVALID = new float[0];
        OBJECT_INVALID = new Object();
        STRING_INVALID = new String();
        COLOR_INHERIT = new Color(0, 0, 0);
        COLOR_INVALID = new Color(0, 0, 0);
        DEFAULT_STROKE = new BasicStroke(1.0f);
        defaultFont_ = new Font("Serif", 0, 10);
    }

    static class FloatContext {
        List<Node> q;
        Node[] act;
        int[] htg;
        int size = 0;
        int leftw;
        int rightw;
        int fcnulls = 0;

        FloatContext() {
            this.reset();
        }

        void reset() {
            this.q = new ArrayList<Node>(10);
            this.act = new Node[10];
            this.htg = new int[10];
            this.size = 0;
            this.rightw = 0;
            this.leftw = 0;
        }
    }
}

