/*
 * Decompiled with CFR 0.152.
 */
package berkeley.biblio;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.Layer;
import multivalent.Leaf;
import multivalent.Node;
import multivalent.VObject;
import multivalent.node.IVBox;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Biblio
extends Behavior {
    static final boolean DEBUG = true;
    int active = 0;
    boolean affected = false;
    List<Node> bibentry;
    static final String[] attrsBib_ = new String[]{"uid", "type", "title", "author", "journal", "month", "year", "volume", "pagestart", "pageend", "comment"};
    protected static String[] titles = new String[]{"OCR"};
    List<Leaf> spanlist;

    public List<Node> getBibs() {
        return (List)((ArrayList)this.bibentry).clone();
    }

    public void command(int n, Object object) {
        Browser browser = this.getBrowser();
        if (n == titles.length) {
            this.affected = !this.affected;
            browser.repaint();
        } else {
            this.active = n;
            browser.clipboard();
        }
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        this.bibentry = this.makeBibI(eSISNode);
    }

    List<Node> makeBibI(ESISNode eSISNode) {
        ArrayList<Node> arrayList = new ArrayList<Node>(10);
        ESISNode.trimTree(eSISNode, 1);
        boolean bl = false;
        boolean bl2 = false;
        int n = eSISNode.size();
        for (int i = 0; i < n; ++i) {
            ESISNode eSISNode2 = (ESISNode)eSISNode.childAt(i);
            ESISNode.trimTree(eSISNode2, 1);
            VObject vObject = null;
            vObject.putAttr("type", eSISNode2.getGI());
            arrayList.add((Node)vObject);
            for (int j = 0; j < eSISNode2.size(); ++j) {
                String string;
                ESISNode eSISNode3 = (ESISNode)eSISNode2.childAt(j);
                String string2 = eSISNode3.getGI().toLowerCase();
                if (string2.equals("START") || string2.equals("END")) {
                    vObject.putAttr(string2, eSISNode3);
                    continue;
                }
                if (string2.equals("PAGES")) {
                    string = null;
                    Object var13_13 = null;
                    String string3 = (String)eSISNode3.childAt(0);
                    int n2 = string3.indexOf(32);
                    if (n2 >= -1) {
                        vObject.putAttr("pageend", string3.substring(n2 + 1));
                    } else {
                        n2 = string3.length();
                    }
                    vObject.putAttr("pagestart", string3.substring(0, n2));
                    continue;
                }
                string = (String)eSISNode3.childAt(0);
                vObject.putAttr(string2, string);
            }
        }
        return arrayList;
    }

    @Override
    public void buildBefore(Document document) {
        this.spanlist = new ArrayList<Leaf>(this.bibentry.size() * 2);
        int n = this.bibentry.size();
        for (int i = 0; i < n; ++i) {
            IVBox iVBox = (IVBox)this.bibentry.get(i);
        }
    }

    @Override
    public void buildAfter(Document document) {
    }
}

