/*
 * Decompiled with CFR 0.152.
 */
package berkeley.adaptor;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;
import phelps.Utility;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lisp {
    static final boolean DEBUG = true;
    StreamTokenizer in;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$berkeley$adaptor$Lisp;

    Lisp(InputStream inputStream) {
        this.in = new StreamTokenizer(new BufferedReader(new InputStreamReader(inputStream)));
        this.in.resetSyntax();
        this.in.parseNumbers();
        this.in.commentChar(59);
        this.in.quoteChar(34);
        this.in.whitespaceChars(0, 32);
        this.in.wordChars(65, 90);
        this.in.wordChars(97, 122);
        this.in.wordChars(46, 46);
        this.in.wordChars(95, 95);
        this.in.lowerCaseMode(false);
    }

    public List<Object> parse() {
        List<Object> list = null;
        try {
            list = this.parse(0);
        }
        catch (IOException iOException) {
            Utility.error(new StringBuffer().append("error parsing Lisp: ").append(iOException).toString());
        }
        return list;
    }

    public List<Object> parse(int n) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        this.in.nextToken();
        if (this.in.ttype != 40) {
            Utility.error("Lisp: looking for opening left parenthesis");
        }
        this.in.nextToken();
        while (this.in.ttype != -1) {
            switch (this.in.ttype) {
                case 40: {
                    this.in.pushBack();
                    arrayList.add(this.parse(n + 1));
                    break;
                }
                case 41: {
                    int n2;
                    for (n2 = 0; n2 < n; ++n2) {
                        System.out.print(" ");
                    }
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        System.out.print(new StringBuffer().append(arrayList.get(n2)).append(" ").toString());
                    }
                    System.out.println();
                    return arrayList;
                }
                case 39: {
                    int n2 = 0;
                    StringBuffer stringBuffer = new StringBuffer(30);
                    do {
                        this.in.nextToken();
                        if (this.in.ttype == 40) {
                            ++n2;
                        } else if (this.in.ttype == 41) {
                            --n2;
                        }
                        if (this.in.ttype == -3) {
                            stringBuffer.append(this.in.sval);
                        } else if (this.in.ttype == -2) {
                            stringBuffer.append(this.in.nval);
                        } else {
                            if ((char)this.in.ttype == '(') {
                                stringBuffer.append('(');
                                continue;
                            }
                            if ((char)this.in.ttype == ')') {
                                int n3 = stringBuffer.length();
                                if (n3 > 0 && stringBuffer.charAt(n3 - 1) == ' ') {
                                    stringBuffer.setLength(n3 - 1);
                                }
                                stringBuffer.append(')');
                            } else {
                                stringBuffer.append((char)this.in.ttype);
                            }
                        }
                        stringBuffer.append(' ');
                    } while (n2 > 0);
                    stringBuffer.setLength(stringBuffer.length() - 1);
                    arrayList.add(stringBuffer.substring(0));
                    break;
                }
                case 34: {
                    arrayList.add(this.in.sval);
                    break;
                }
                case -3: {
                    arrayList.add(this.in.sval);
                    break;
                }
                case -2: {
                    arrayList.add(new Double(this.in.nval));
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((char)this.in.ttype);
                    }
                    break;
                }
            }
            this.in.nextToken();
        }
        Utility.error("missing right paren when hit EOF");
        return null;
    }

    public static void main(String[] stringArray) {
        try {
            FileInputStream fileInputStream = new FileInputStream("mathbox.lisp");
            Lisp lisp = new Lisp(fileInputStream);
            lisp.parse();
        }
        catch (Exception exception) {
            Utility.error(new StringBuffer().append("").append(exception).toString());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$berkeley$adaptor$Lisp == null ? (class$berkeley$adaptor$Lisp = Lisp.class$("berkeley.adaptor.Lisp")) : class$berkeley$adaptor$Lisp).desiredAssertionStatus();
    }
}

