/*
 * Decompiled with CFR 0.152.
 */
package berkeley;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import multivalent.Behavior;
import multivalent.Context;
import multivalent.Document;
import multivalent.EventListener;
import multivalent.INode;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.gui.VCheckbox;
import phelps.lang.Booleans;

public class COG
extends Behavior
implements EventListener {
    public static final String MSG_SHOW = "cogShow";
    INode cogp_ = null;
    boolean fshow_ = false;
    int x0_;
    int y0_;
    Node cog_;
    Rectangle bbox0_ = new Rectangle();

    public boolean paintAfter(Context context, Node node) {
        if (this.fshow_) {
            Graphics2D graphics2D = context.g;
            graphics2D.setColor(Color.ORANGE);
            int n = this.cogp_.size();
            for (int i = 0; i < n; ++i) {
                Node node2 = this.cogp_.childAt(i);
                Rectangle rectangle = node2.bbox;
                graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        return super.paintAfter(context, node);
    }

    public void buildAfter(Document document) {
        this.cogp_ = this.findCogP(document);
        if (this.cogp_ != null) {
            document.addObserver(this);
        }
        super.buildAfter(document);
    }

    private INode findCogP(INode iNode) {
        if (iNode.getName().startsWith("cog0")) {
            return iNode.getParentNode();
        }
        if (iNode.childAt(0).isStruct()) {
            return this.findCogP((INode)iNode.childAt(0));
        }
        return null;
    }

    public boolean eventBefore(AWTEvent aWTEvent, Point point, Node node) {
        int n = aWTEvent.getID();
        if (super.eventBefore(aWTEvent, point, node)) {
            return true;
        }
        if (this.fshow_ && 500 <= n && n <= 507) {
            if (501 == n) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                int n2 = point.x;
                int n3 = point.y;
                int n4 = this.cogp_.size();
                for (int i = 0; i < n4; ++i) {
                    Node node2 = this.cogp_.childAt(i);
                    Rectangle rectangle = node2.bbox;
                    if (!rectangle.contains(n2, n3)) continue;
                    this.x0_ = mouseEvent.getX();
                    this.y0_ = mouseEvent.getY();
                    this.cog_ = node2;
                    this.bbox0_.setBounds(rectangle);
                    this.getBrowser().setGrab(this);
                }
            }
            return true;
        }
        return false;
    }

    public void event(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        if (506 == n) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            Rectangle rectangle = this.cog_.bbox;
            rectangle.setLocation(this.bbox0_.x + n2 - this.x0_, this.bbox0_.y + n3 - this.y0_);
            this.getBrowser().repaint(100L);
        } else if (502 == n) {
            this.cog_ = null;
            this.getBrowser().releaseGrab(this);
        }
    }

    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if (this.cogp_ != null && "createWidget/View" == string) {
            INode iNode = (INode)semanticEvent.getOut();
            VCheckbox vCheckbox = (VCheckbox)this.createUI("checkbox", "Show COGs", "event cogShow", iNode, "medium", false);
            vCheckbox.setState(this.fshow_);
        }
        return false;
    }

    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        boolean bl;
        if (this.cogp_ != null && MSG_SHOW == string && (bl = Booleans.parseBoolean(semanticEvent.getArg(), !this.fshow_)) != this.fshow_) {
            this.fshow_ = bl;
            this.getBrowser().repaint(100L);
        }
        return super.semanticEventAfter(semanticEvent, string);
    }
}

