/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.Time;
import edu.sc.seis.fissuresUtil.xml.XMLNetworkId;
import edu.sc.seis.fissuresUtil.xml.XMLTime;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLStationId {
    public static void insert(XMLStreamWriter writer, StationId stationId) throws XMLStreamException {
        writer.writeStartElement("network_id");
        XMLNetworkId.insert(writer, stationId.network_id);
        XMLUtil.writeEndElementWithNewLine(writer);
        XMLUtil.writeTextElement(writer, "station_code", stationId.station_code);
        writer.writeStartElement("begin_time");
        XMLTime.insert(writer, stationId.begin_time);
        XMLUtil.writeEndElementWithNewLine(writer);
    }

    public static void insert(Element element, StationId stationId) {
        Document doc = element.getOwnerDocument();
        Element network_id = doc.createElement("network_id");
        XMLNetworkId.insert(network_id, stationId.network_id);
        element.appendChild(network_id);
        element.appendChild(XMLUtil.createTextElement(doc, "station_code", stationId.station_code));
        Element begin_time = doc.createElement("begin_time");
        XMLTime.insert(begin_time, stationId.begin_time);
        element.appendChild(begin_time);
    }

    public static StationId getStationId(Element base) {
        Element network_id_node = XMLUtil.getElement(base, "network_id");
        NetworkId network_id = null;
        if (network_id_node != null) {
            network_id = XMLNetworkId.getNetworkId(network_id_node);
        }
        String station_code = XMLUtil.getText(XMLUtil.getElement(base, "station_code"));
        Element begin_time_node = XMLUtil.getElement(base, "begin_time");
        Time begin_time = new Time();
        if (begin_time_node != null) {
            begin_time = XMLTime.getFissuresTime(begin_time_node);
        }
        return new StationId(network_id, station_code, begin_time);
    }
}

