/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.iris.Fissures.Orientation;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLOrientation {
    public static void insert(XMLStreamWriter writer, Orientation orientation) throws XMLStreamException {
        XMLUtil.writeTextElement(writer, "azimuth", "" + orientation.azimuth);
        XMLUtil.writeTextElement(writer, "dip", "" + orientation.dip);
    }

    public static void insert(Element element, Orientation orientation) {
        Document doc = element.getOwnerDocument();
        element.appendChild(XMLUtil.createTextElement(doc, "azimuth", "" + orientation.azimuth));
        element.appendChild(XMLUtil.createTextElement(doc, "dip", "" + orientation.dip));
    }

    public static Orientation getOrientation(Element base) {
        float dip;
        float azimuth;
        try {
            azimuth = Float.parseFloat(XMLUtil.getText(XMLUtil.getElement(base, "azimuth")));
        }
        catch (NumberFormatException nfe) {
            azimuth = 0.0f;
        }
        try {
            dip = Float.parseFloat(XMLUtil.getText(XMLUtil.getElement(base, "dip")));
        }
        catch (NumberFormatException nfe) {
            dip = 0.0f;
        }
        return new Orientation(azimuth, dip);
    }
}

