/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.iris.Fissures.IfSeismogramDC.Property;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.sac.SacToFissures;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.SeismogramFileTypes;
import edu.sc.seis.fissuresUtil.xml.SimpleXLink;
import edu.sc.seis.fissuresUtil.xml.URLDataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.XMLParameter;
import edu.sc.seis.fissuresUtil.xml.XMLSeismogramAttr;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Category;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XMLDataSet
implements DataSet,
Serializable {
    static DocumentBuilderFactory factory = null;
    static DocumentBuilder staticDocBuilder = null;
    private Map dataSetSeismograms = new HashMap();
    private List dssNames = new LinkedList();
    private XPathAPI xpath = new XPathAPI();
    private PrefixResolver prefixResolver;
    protected URL base;
    protected Element config;
    protected DocumentBuilder docBuilder;
    protected HashMap parameterCache = new HashMap();
    protected String[] parameterNameCache = null;
    protected String[] dataSetIdCache = null;
    protected HashMap dataSetCache = new HashMap();
    protected HashMap seismogramCache = new HashMap();
    protected String[] seismogramNameCache = null;
    private static final String dquote = "\"";
    private static final String xlinkNS = "http://www.w3.org/1999/xlink";
    private static final String seisNameKey = "Name";
    static Category logger = Category.getInstance((String)(class$edu$sc$seis$fissuresUtil$xml$XMLDataSet == null ? (class$edu$sc$seis$fissuresUtil$xml$XMLDataSet = XMLDataSet.class$("edu.sc.seis.fissuresUtil.xml.XMLDataSet")) : class$edu$sc$seis$fissuresUtil$xml$XMLDataSet).getName());
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$xml$XMLDataSet;

    public XMLDataSet(DocumentBuilder docBuilder, URL datasetURL) {
        this.base = datasetURL;
        this.docBuilder = docBuilder;
        Document doc = docBuilder.newDocument();
        this.config = doc.createElement("dataset");
        this.config.setAttribute("xmlns:xlink", xlinkNS);
        this.prefixResolver = new PrefixResolverDefault((Node)this.config);
    }

    public static XMLDataSet load(URL datasetURL) {
        XMLDataSet dataset = null;
        try {
            DocumentBuilder docBuilder = XMLDataSet.getDocumentBuilder();
            Document doc = docBuilder.parse(new BufferedInputStream(datasetURL.openStream()));
            Element docElement = doc.getDocumentElement();
            if (docElement.getTagName().equals("dataset")) {
                dataset = new XMLDataSet(docBuilder, datasetURL, docElement);
            }
        }
        catch (IOException e) {
            logger.error((Object)"Error loading XMLDataSet", (Throwable)e);
        }
        catch (SAXException e) {
            logger.error((Object)"Error loading XMLDataSet", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)"Error loading XMLDataSet", (Throwable)e);
        }
        return dataset;
    }

    public XMLDataSet(DocumentBuilder docBuilder, URL base, String id, String name, String owner) {
        this(docBuilder, base);
        Document doc = this.config.getOwnerDocument();
        Element nameE = doc.createElement("name");
        Text text = doc.createTextNode(name);
        nameE.appendChild(text);
        Element ownerE = doc.createElement("owner");
        text = doc.createTextNode(owner);
        ownerE.appendChild(text);
        this.config.setAttribute("datasetid", id);
        this.config.appendChild(nameE);
        this.config.appendChild(ownerE);
    }

    public XMLDataSet(DocumentBuilder docBuilder, URL base, Element config) {
        this(docBuilder, base);
        this.config = config;
        this.checkForLegacySeismograms();
    }

    protected void checkForLegacySeismograms() {
        if (this.getDataSetSeismogramNames().length == 0) {
            String[] names = this.getSeismogramNames();
            logger.info((Object)("No DataSetSeismograms in dataset " + this.getName() + ", using legacy dataset option: creating DataSetSeismogram per LocalSeismogram. LS length=" + names.length));
            for (int i = 0; i < names.length; ++i) {
                URL sacURL = this.getSeismogramURL(names[i]);
                if (sacURL == null) continue;
                URLDataSetSeismogram dsstemp = new URLDataSetSeismogram(sacURL, SeismogramFileTypes.SAC, (DataSet)this, names[i]);
                this.addDataSetSeismogram(dsstemp, new AuditInfo[0]);
            }
        }
    }

    public String getId() {
        return XMLUtil.evalString(this.config, "@datasetid");
    }

    public URL getBase() {
        return this.base;
    }

    public void setBase(URL base) {
        this.base = base;
    }

    public String getName() {
        return XMLUtil.evalString(this.config, "name/text()");
    }

    public void setName(String name) {
        Element nameElement = XMLUtil.evalElement(this.config, "name");
        Text text = this.config.getOwnerDocument().createTextNode(name);
        nameElement.appendChild(text);
        this.config.appendChild(nameElement);
    }

    public String getOwner() {
        return XMLUtil.evalString(this.config, "owner/text()");
    }

    public void setOwner(String owner) {
        Element nameElement = XMLUtil.evalElement(this.config, "owner");
        Text text = this.config.getOwnerDocument().createTextNode(owner);
        nameElement.appendChild(text);
        this.config.appendChild(nameElement);
    }

    public String[] getParameterNames() {
        if (this.parameterNameCache == null) {
            this.parameterNameCache = this.cacheParameterNames();
        }
        return this.parameterNameCache;
    }

    public String[] cacheParameterNames() {
        String[] params = XMLUtil.getAllAsStrings(this.config, "parameter/name/text()");
        ArrayList<String> referenceNames = new ArrayList<String>();
        NodeList paramRefsList = XMLUtil.evalNodeList(this.config, "parameterRef");
        if (paramRefsList != null && paramRefsList.getLength() != 0) {
            for (int counter = 0; counter < paramRefsList.getLength(); ++counter) {
                Node n = paramRefsList.item(counter);
                if (!(n instanceof Element)) continue;
                String str = ((Element)n).getAttribute("name");
                referenceNames.add(str);
            }
        }
        String[] paramRefs = new String[referenceNames.size()];
        paramRefs = referenceNames.toArray(paramRefs);
        String[] all = new String[params.length + paramRefs.length];
        System.arraycopy(params, 0, all, 0, params.length);
        System.arraycopy(paramRefs, 0, all, params.length, paramRefs.length);
        return all;
    }

    public Object getParameter(String name) {
        NodeList nList;
        if (this.parameterCache.containsKey(name)) {
            Object obj = this.parameterCache.get(name);
            if (obj instanceof SoftReference) {
                SoftReference softReference = (SoftReference)obj;
                if (softReference.get() != null) {
                    return softReference.get();
                }
                this.parameterCache.remove(name);
            } else {
                return obj;
            }
        }
        if ((nList = XMLUtil.evalNodeList(this.config, "parameter[name/text()=\"" + name + dquote + "]")) != null && nList.getLength() != 0) {
            Node n = nList.item(0);
            if (n instanceof Element) {
                Object r = XMLParameter.getParameter((Element)n);
                this.parameterCache.put(name, new SoftReference<Object>(r));
                return r;
            }
        } else {
            logger.debug((Object)("THE NODE LIST IS NULL for parameter " + name));
        }
        nList = XMLUtil.evalNodeList(this.config, "parameterRef");
        if (nList != null && nList.getLength() != 0) {
            for (int counter = 0; counter < nList.getLength(); ++counter) {
                Node n = nList.item(counter);
                if (!(n instanceof Element) || !((Element)n).getAttribute("name").equals(name)) continue;
                SimpleXLink sl = new SimpleXLink(this.docBuilder, (Element)n, this.getBase());
                try {
                    Element e = sl.retrieve();
                    Object obj = XMLParameter.getParameter(e);
                    this.parameterCache.put(name, new SoftReference<Object>(obj));
                    return obj;
                }
                catch (Exception e) {
                    logger.error((Object)("can't get paramterRef for " + name), (Throwable)e);
                }
            }
        }
        logger.warn((Object)("can't find paramter for " + name));
        return null;
    }

    public void addParameter(String name, Object value, AuditInfo[] audit) {
        String[] oldNames = this.getParameterNames();
        this.parameterCache.put(name, value);
        Element parameter = this.config.getOwnerDocument().createElement("parameter");
        XMLParameter.insert(parameter, name, value);
        this.config.appendChild(parameter);
        this.updateParameterNameCache(name);
    }

    public void addParameterRef(URL paramURL, String name, Object object, AuditInfo[] audit) {
        String baseStr = this.base.toString();
        String paramStr = paramURL.toString();
        if (paramStr.startsWith(baseStr)) {
            paramStr = paramStr.substring(baseStr.length());
        }
        Document doc = this.config.getOwnerDocument();
        Element param = doc.createElement("parameterRef");
        XMLParameter.insertParameterRef(param, name, paramStr, object);
        this.config.appendChild(param);
        this.updateParameterNameCache(name);
    }

    public String[] getDataSetIds() {
        if (this.dataSetIdCache == null) {
            String[] internal = XMLUtil.getAllAsStrings(this.config, "*/@datasetid");
            String[] external = this.getDataSetRefIds();
            String[] tmp = new String[internal.length + external.length];
            System.arraycopy(internal, 0, tmp, 0, internal.length);
            System.arraycopy(external, 0, tmp, internal.length, external.length);
            this.dataSetIdCache = tmp;
        }
        return this.dataSetIdCache;
    }

    String[] getDataSetRefIds() {
        String[] xlinktmps = XMLUtil.getAllAsStrings(this.config, "datasetRef");
        String xlinkNS = xlinkNS;
        NodeList nodes = XMLUtil.evalNodeList(this.config, "datasetRef");
        if (nodes == null) {
            return new String[0];
        }
        String[] xlinks = new String[nodes.getLength()];
        String[] ids = new String[nodes.getLength()];
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            NamedNodeMap map = n.getAttributes();
            for (int j = 0; j < map.getLength(); ++j) {
            }
            try {
                if (n instanceof Element) {
                    Element e = (Element)n;
                    String href = e.getAttribute("xlink:href");
                    SimpleXLink sl = new SimpleXLink(this.docBuilder, e, this.getBase());
                    Element referredElement = sl.retrieve();
                    XMLDataSet ds = new XMLDataSet(this.docBuilder, new URL(this.getBase(), href), referredElement);
                    this.dataSetCache.put(ds.getId(), ds);
                    ids[i] = ds.getId();
                    continue;
                }
                ids[i] = null;
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("can't get dataset for " + xlinks[i]), (Throwable)e);
                ids[i] = null;
            }
        }
        return ids;
    }

    public String[] getDataSetNames() {
        String[] ids = this.getDataSetIds();
        String[] names = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            DataSet ds = this.getDataSetById(ids[i]);
            this.dataSetCache.put(ds.getId(), ds);
            names[i] = ds.getName();
        }
        return names;
    }

    public DataSet getDataSet(String name) {
        String[] ids = this.getDataSetIds();
        for (int i = 0; i < ids.length; ++i) {
            DataSet ds = this.getDataSetById(ids[i]);
            if (!name.equals(ds.getName())) continue;
            return ds;
        }
        return null;
    }

    public void addDataSet(DataSet dataset, AuditInfo[] audit) {
        if (dataset instanceof XMLDataSet) {
            XMLDataSet xds = (XMLDataSet)dataset;
            Element element = xds.getElement();
            if (element.getOwnerDocument().equals(this.config.getOwnerDocument())) {
                this.config.appendChild(element);
                logger.debug((Object)("dataset append " + this.config.getChildNodes().getLength()));
            } else {
                Node copyNode = this.config.getOwnerDocument().importNode(element, true);
                this.config.appendChild(copyNode);
                logger.debug((Object)("dataset import " + this.config.getChildNodes().getLength()));
                NodeList nl = this.config.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                }
            }
            this.dataSetCache.put(dataset.getId(), dataset);
            String[] ids = this.getDataSetIds();
            this.dataSetIdCache = null;
            String[] tmp = new String[ids.length + 1];
            System.arraycopy(ids, 0, tmp, 0, ids.length);
            tmp[tmp.length - 1] = dataset.getId();
            this.dataSetIdCache = tmp;
        } else {
            logger.warn((Object)"Attempt to add non-XML dataset");
        }
    }

    public void addDataSetRef(URL datasetURL, AuditInfo[] audit) {
        this.dataSetIdCache = null;
        String baseStr = this.base.toString();
        String datasetStr = datasetURL.toString();
        if (datasetStr.startsWith(baseStr)) {
            datasetStr = datasetStr.substring(baseStr.length());
        }
        Document doc = this.config.getOwnerDocument();
        Element datasetElement = doc.createElement("datasetRef");
        datasetElement.setAttributeNS(xlinkNS, "xlink:type", "simple");
        datasetElement.setAttributeNS(xlinkNS, "xlink:href", datasetStr);
        this.config.appendChild(datasetElement);
    }

    public DataSet createChildDataSet(String id, String name, String owner, AuditInfo[] audit) {
        name = XMLUtil.getUniqueName(this.getDataSetNames(), name);
        XMLDataSet dataset = new XMLDataSet(this.docBuilder, this.base, id, name, owner);
        this.addDataSet(dataset, audit);
        return dataset;
    }

    public DataSet getDataSetById(String id) {
        Node n;
        if (this.dataSetCache.containsKey(id)) {
            return (DataSet)this.dataSetCache.get(id);
        }
        NodeList nList = XMLUtil.evalNodeList(this.config, "//dataset[@datasetid=\"" + id + dquote + "]");
        if (nList != null && nList.getLength() != 0 && (n = nList.item(0)) instanceof Element) {
            XMLDataSet dataset = new XMLDataSet(this.docBuilder, this.base, (Element)n);
            this.dataSetCache.put(id, dataset);
            return dataset;
        }
        NodeList nodes = XMLUtil.evalNodeList(this.config, "datasetRef");
        if (nodes == null) {
            return null;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n2 = nodes.item(i);
            NamedNodeMap map = n2.getAttributes();
            try {
                if (n2 instanceof Element) {
                    Element e = (Element)n2;
                    String href = e.getAttribute("xlink:href");
                    SimpleXLink sl = new SimpleXLink(this.docBuilder, e, this.getBase());
                    Element referredElement = sl.retrieve();
                    XMLDataSet ds = new XMLDataSet(this.docBuilder, new URL(this.getBase(), href), referredElement);
                    if (!id.equals(ds.getId())) continue;
                    this.dataSetCache.put(ds.getId(), ds);
                    return ds;
                }
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        String[] ids = this.getDataSetRefIds();
        if (this.dataSetCache.containsKey(id)) {
            return (DataSet)this.dataSetCache.get(id);
        }
        logger.error((Object)("Couldn't get datasetRef :" + id));
        return null;
    }

    public String[] getSeismogramNames() {
        if (this.seismogramNameCache == null) {
            this.seismogramNameCache = this.cacheSeismogramNames();
        }
        return this.seismogramNameCache;
    }

    protected String[] cacheSeismogramNames() {
        String[] names = XMLUtil.getAllAsStrings(this.config, "localSeismogram/seismogramAttr/property[name=\"Name\"]/value/text()");
        return names;
    }

    public SeismogramAttr[] getSeismogramAttrs() {
        NodeList nList = XMLUtil.evalNodeList(this.config, "localSeismogram/seismogramAttr");
        SeismogramAttr[] seismogramAttrs = new SeismogramAttr[]{};
        if (nList != null && nList.getLength() != 0) {
            seismogramAttrs = new SeismogramAttr[nList.getLength()];
            for (int counter = 0; counter < nList.getLength(); ++counter) {
                seismogramAttrs[counter] = XMLSeismogramAttr.getSeismogramAttr((Element)nList.item(counter));
            }
        }
        return seismogramAttrs;
    }

    public ChannelId[] getChannelIds() {
        List channels = this.getChannels();
        ChannelId[] ids = new ChannelId[channels.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = ((Channel)channels.get(i)).get_id();
        }
        return ids;
    }

    private List getChannels() {
        String[] paramNames = this.getParameterNames();
        ArrayList<Object> chans = new ArrayList<Object>();
        for (int i = 0; i < paramNames.length; ++i) {
            if (!paramNames[i].startsWith("edu.sc.seis.fissuresUtil.xml#CHANNEL_")) continue;
            chans.add(this.getParameter(paramNames[i]));
        }
        return chans;
    }

    private void updateParameterNameCache(String paramName) {
        String[] temp = this.parameterNameCache;
        if (temp == null) {
            temp = new String[]{paramName};
        } else {
            temp = new String[this.parameterNameCache.length + 1];
            System.arraycopy(this.parameterNameCache, 0, temp, 0, this.parameterNameCache.length);
            temp[this.parameterNameCache.length] = paramName;
        }
        this.parameterNameCache = temp;
    }

    private URL getSeismogramURL(String name) {
        String urlString = "NONE";
        NodeList nList = XMLUtil.evalNodeList(this.config, "localSeismogram/seismogramAttr/property[name=\"Name\"][value=\"" + name + dquote + "]" + "/../../data");
        if (nList == null || nList == null || nList.getLength() == 0) {
            // empty if block
        }
        if (nList != null && nList.getLength() != 0) {
            try {
                Node n = nList.item(0);
                if (n instanceof Element) {
                    Element e = (Element)n;
                    urlString = e.getAttribute("xlink:href");
                    if (urlString == null || urlString == "") {
                        throw new MalformedURLException(name + " does not have an xlink:href attribute");
                    }
                    URL sacURL = new URL(this.base, urlString);
                    return sacURL;
                }
            }
            catch (MalformedURLException e) {
                logger.error((Object)("Couldn't get seismogram " + name), (Throwable)e);
                logger.error((Object)urlString);
            }
            catch (Exception e) {
                logger.error((Object)("Couldn't get seismogram " + name), (Throwable)e);
                logger.error((Object)urlString);
            }
        }
        return null;
    }

    public LocalSeismogramImpl getSeismogram(String name) {
        URL sacURL = this.getSeismogramURL(name);
        if (sacURL != null) {
            NodeList nList = XMLUtil.evalNodeList(this.config, "localSeismogram/seismogramAttr/property[name=\"Name\"][value=\"" + name + dquote + "]" + "/../../data");
            Node n = nList.item(0);
            Element e = (Element)n;
            try {
                DataInputStream dis = new DataInputStream(new BufferedInputStream(sacURL.openStream()));
                SacTimeSeries sac = new SacTimeSeries();
                sac.read(dis);
                NodeList seisAttrNode = XMLUtil.evalNodeList(e, "../seismogramAttr");
                SeismogramAttr seisAttr = null;
                if (seisAttrNode != null && seisAttrNode.getLength() != 0) {
                    seisAttr = XMLSeismogramAttr.getSeismogramAttr((Element)seisAttrNode.item(0));
                }
                NodeList propList = XMLUtil.evalNodeList(e, "property");
                int numDSProps = 0;
                numDSProps = propList != null && propList.getLength() != 0 ? nList.getLength() : 0;
                LocalSeismogramImpl seis = seisAttr != null ? SacToFissures.getSeismogram(sac, seisAttr) : SacToFissures.getSeismogram(sac);
                return seis;
            }
            catch (Exception ex) {
                logger.error((Object)("Couldn't get seismogram " + name), (Throwable)ex);
            }
        }
        return null;
    }

    public void addSeismogram(LocalSeismogramImpl seis, AuditInfo[] audit) {
        this.seismogramNameCache = null;
        Document doc = this.config.getOwnerDocument();
        Element localSeismogram = doc.createElement("localSeismogram");
        String name = seis.getProperty(seisNameKey);
        if (name == null || name.length() == 0) {
            name = seis.channel_id.network_id.network_code + "." + seis.channel_id.station_code + "." + seis.channel_id.channel_code;
        }
        name = XMLUtil.getUniqueName(this.getSeismogramNames(), name);
        seis.setName(name);
        Element seismogramAttr = doc.createElement("seismogramAttr");
        XMLSeismogramAttr.insert(seismogramAttr, (SeismogramAttr)seis);
        localSeismogram.appendChild(seismogramAttr);
        this.config.appendChild(localSeismogram);
        this.seismogramNameCache = null;
    }

    public void addSeismogramRef(LocalSeismogramImpl seis, URL seisURL, String name, Property[] props, ParameterRef[] parm_ids, AuditInfo[] audit) {
        this.seismogramNameCache = null;
        String baseStr = this.base.toString();
        String seisStr = seisURL.toString();
        if (seisStr.startsWith(baseStr)) {
            seisStr = seisStr.substring(baseStr.length());
        }
        Document doc = this.config.getOwnerDocument();
        Element localSeismogram = doc.createElement("localSeismogram");
        if (name == null || name.length() == 0) {
            name = seis.getProperty(seisNameKey);
        }
        if (name == null || name.length() == 0) {
            name = ChannelIdUtil.toStringNoDates((ChannelId)seis.channel_id);
        }
        name = XMLUtil.getUniqueName(this.getSeismogramNames(), name);
        seis.setName(name);
        Element seismogramAttr = doc.createElement("seismogramAttr");
        XMLSeismogramAttr.insert(seismogramAttr, (SeismogramAttr)seis);
        localSeismogram.appendChild(seismogramAttr);
        Element data = doc.createElement("data");
        data.setAttributeNS(xlinkNS, "xlink:type", "simple");
        data.setAttributeNS(xlinkNS, "xlink:href", seisStr);
        data.setAttribute("seisType", "sac");
        localSeismogram.appendChild(data);
        this.config.appendChild(localSeismogram);
    }

    public void addDataSetSeismogram(DataSetSeismogram dss, AuditInfo[] audit) {
        String name = dss.getName();
        if (name == null || name.length() == 0) {
            name = ChannelIdUtil.toStringNoDates((ChannelId)dss.getRequestFilter().channel_id);
        }
        if (!(name = XMLUtil.getUniqueName(this.getDataSetSeismogramNames(), name)).equals(dss.getName())) {
            dss.setName(name);
        }
        this.dssNames.add(name);
        this.dataSetSeismograms.put(name, dss);
        dss.setDataSet(this);
    }

    public DataSetSeismogram getDataSetSeismogram(String name) {
        return (DataSetSeismogram)this.dataSetSeismograms.get(name);
    }

    public String[] getDataSetSeismogramNames() {
        return this.dssNames.toArray(new String[this.dssNames.size()]);
    }

    public void remove(DataSetSeismogram dss) {
        this.dataSetSeismograms.remove(dss.getName());
        this.dssNames.remove(dss.getName());
    }

    public String toString() {
        return this.getName();
    }

    public Element getElement() {
        return this.config;
    }

    public EventAccessOperations getEvent() {
        return (EventAccessOperations)this.getParameter("edu.sc.seis.fissuresUtil.xml#EVENT");
    }

    public Channel getChannel(ChannelId channelId) {
        List channels = this.getChannels();
        Iterator it = channels.iterator();
        while (it.hasNext()) {
            Channel cur = (Channel)it.next();
            if (!ChannelIdUtil.areEqualExceptForBeginTime((ChannelId)cur.get_id(), (ChannelId)channelId)) continue;
            return cur;
        }
        return null;
    }

    public void write(OutputStream out) throws Exception {
        XMLDataSet.write(out, this.getElement());
    }

    public static void write(OutputStream out, Element el) throws Exception {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer serializer = tfactory.newTransformer();
        Properties oprops = new Properties();
        oprops.put("method", "xml");
        oprops.put("indent", "yes");
        serializer.setOutputProperties(oprops);
        serializer.transform(new DOMSource(el), new StreamResult(out));
    }

    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        if (factory == null) {
            factory = DocumentBuilderFactory.newInstance();
        }
        return factory;
    }

    public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return XMLDataSet.getDocumentBuilderFactory().newDocumentBuilder();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

