/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.Property;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.mseed.FissuresConvert;
import edu.sc.seis.fissuresUtil.psn.PSNToFissures;
import edu.sc.seis.fissuresUtil.sac.FissuresToSac;
import edu.sc.seis.fissuresUtil.sac.SacToFissures;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.SeisDataChangeListener;
import edu.sc.seis.fissuresUtil.xml.SeismogramFileTypes;
import edu.sc.seis.fissuresUtil.xml.StdAuxillaryDataNames;
import edu.sc.seis.fissuresUtil.xml.URLDataSetSeismogramSaver;
import edu.sc.seis.fissuresUtil.xml.UnsupportedFileTypeException;
import edu.sc.seis.fissuresUtil.xml.XMLProperty;
import edu.sc.seis.fissuresUtil.xml.XMLRequestFilter;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.MiniSeedRead;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.psn.PSNDataFile;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class URLDataSetSeismogram
extends DataSetSeismogram {
    public static final String PROPERTY = "property";
    public static final String NAMED_VALUE = "namedValue";
    private URL[] url;
    private SeismogramFileTypes[] fileType;
    private HashMap urlToLSMap = new HashMap();

    public URLDataSetSeismogram(URL url, SeismogramFileTypes fileType, DataSet dataset, String name) {
        this(new URL[]{url}, new SeismogramFileTypes[]{fileType}, dataset, name);
    }

    public URLDataSetSeismogram(URL[] url, SeismogramFileTypes[] fileType, DataSet dataset, String name) {
        this(url, fileType, dataset, name, null);
    }

    public URLDataSetSeismogram(URL[] url, SeismogramFileTypes[] fileType, DataSet dataset, String name, RequestFilter requestFilter) {
        super(dataset, name, requestFilter);
        this.url = url;
        this.fileType = fileType;
    }

    public URLDataSetSeismogram(URL url, SeismogramFileTypes fileType, DataSet dataset) {
        this(new URL[]{url}, new SeismogramFileTypes[]{fileType}, dataset);
    }

    public URLDataSetSeismogram(URL[] url, SeismogramFileTypes[] fileType, DataSet dataset) {
        this(url, fileType, dataset, "");
    }

    public URLDataSetSeismogram(URL url, SeismogramFileTypes fileType) {
        this(new URL[]{url}, new SeismogramFileTypes[]{fileType});
    }

    public URLDataSetSeismogram(URL url, SeismogramFileTypes fileType, String name) {
        this(new URL[]{url}, new SeismogramFileTypes[]{fileType}, name);
    }

    public URLDataSetSeismogram(URL[] url, SeismogramFileTypes[] fileType) {
        this(url, fileType, (DataSet)null);
    }

    public URLDataSetSeismogram(URL[] url, SeismogramFileTypes[] fileType, String name) {
        this(url, fileType, null, name);
    }

    public URLDataSetSeismogram(URL[] url, SeismogramFileTypes[] fileType, String name, RequestFilter requestFilter) {
        this(url, fileType, null, name, requestFilter);
    }

    public void retrieveData(final SeisDataChangeListener dataListener) {
        WorkerThreadPool.getDefaultPool().invokeLater(new Runnable(){

            public void run() {
                for (int i = 0; i < URLDataSetSeismogram.this.url.length; ++i) {
                    try {
                        LocalSeismogramImpl[] seismos;
                        LocalSeismogramImpl seis = URLDataSetSeismogram.this.getSeismogram(i);
                        if (seis != null) {
                            seismos = new LocalSeismogramImpl[]{seis};
                            URLDataSetSeismogram.this.pushData(seismos, dataListener);
                            continue;
                        }
                        seismos = new LocalSeismogramImpl[]{};
                        continue;
                    }
                    catch (Exception e) {
                        URLDataSetSeismogram.this.error(dataListener, e);
                    }
                }
                URLDataSetSeismogram.this.finished(dataListener);
            }
        });
    }

    public LocalSeismogramImpl[] getSeismograms() throws Exception {
        ArrayList<LocalSeismogramImpl> seismos = new ArrayList<LocalSeismogramImpl>();
        for (int i = 0; i < this.url.length; ++i) {
            LocalSeismogramImpl seis = this.getSeismogram(i);
            if (seis == null) continue;
            seismos.add(seis);
        }
        return seismos.toArray(new LocalSeismogramImpl[0]);
    }

    public RequestFilter getRequestFilter() {
        if (this.requestFilter == null) {
            for (int i = 0; i < this.url.length; ++i) {
                try {
                    this.getSeismogram(i);
                    continue;
                }
                catch (Exception e) {
                    GlobalExceptionHandler.handle("Cannot get seismogram for " + this.url[i].toString(), e);
                }
            }
        }
        return this.requestFilter;
    }

    public URL[] getURLs() {
        return this.url;
    }

    public static URLDataSetSeismogram localize(DataSetSeismogram dss, File directory, SeismogramFileTypes fileType) throws MalformedURLException {
        URL fileURL = directory.toURL();
        if (dss instanceof URLDataSetSeismogram) {
            URLDataSetSeismogram urlDSS = (URLDataSetSeismogram)dss;
            URL[] url = urlDSS.getURLs();
            boolean isLocal = true;
            for (int i = 0; i < url.length; ++i) {
                if (url[i].getProtocol().equals("file") || url[i].getProtocol().equals("")) {
                    if (url[i].getPath().startsWith(fileURL.getPath())) continue;
                    isLocal = false;
                    continue;
                }
                isLocal = false;
            }
            if (isLocal) {
                return urlDSS;
            }
        }
        URLDataSetSeismogramSaver saver = new URLDataSetSeismogramSaver(dss, directory, fileType);
        URLDataSetSeismogram out = saver.getURLDataSetSeismogram();
        while (!saver.isFinished()) {
            logger.debug((Object)"Waiting for saver to finish");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        if (saver.isError()) {
            String dssName = "dss is null";
            if (dss != null) {
                dssName = dss.getName();
            }
            GlobalExceptionHandler.handle("A problem occured trying to localize the " + dssName + " dataset seismogram.", saver.getError());
        }
        return out;
    }

    public static URLDataSetSeismogram saveLocally(DataSet dataset, File directory, LocalSeismogramImpl[] seismograms, Channel channel, EventAccessOperations event, AuditInfo[] audit, SeismogramFileTypes seisFileType) throws CodecException, IOException, NoPreferredOrigin, SeedFormatException, UnsupportedFileTypeException {
        URL[] seisURL = new URL[seismograms.length];
        for (int i = 0; i < seismograms.length; ++i) {
            seisURL[i] = URLDataSetSeismogram.saveAs(seismograms[i], directory, channel, event, seisFileType).toURI().toURL();
            logger.debug((Object)("Save as locally for " + seisURL[i]));
        }
        SeismogramFileTypes[] seisFileTypeArray = new SeismogramFileTypes[seismograms.length];
        for (int i = 0; i < seisFileTypeArray.length; ++i) {
            seisFileTypeArray[i] = seisFileType;
        }
        URLDataSetSeismogram urlDSS = new URLDataSetSeismogram(seisURL, seisFileTypeArray, dataset);
        dataset.addDataSetSeismogram(urlDSS, audit);
        dataset.addParameter("edu.sc.seis.fissuresUtil.xml#CHANNEL_" + ChannelIdUtil.toString((ChannelId)channel.get_id()), channel, audit);
        urlDSS.addAuxillaryData(StdAuxillaryDataNames.NETWORK_BEGIN, channel.get_id().network_id.begin_time.date_time);
        urlDSS.addAuxillaryData(StdAuxillaryDataNames.CHANNEL_BEGIN, channel.get_id().begin_time.date_time);
        for (int i = 0; i < seisURL.length; ++i) {
            urlDSS.addToCache(seisURL[i], seisFileType, seismograms[i]);
        }
        return urlDSS;
    }

    public static File saveAsSac(LocalSeismogramImpl seis, File directory) throws IOException, CodecException {
        try {
            return URLDataSetSeismogram.saveAsSac(seis, directory, null, null);
        }
        catch (NoPreferredOrigin noPreferredOrigin) {
            return null;
        }
    }

    public static File saveAs(LocalSeismogramImpl seis, File directory, Channel channel, EventAccessOperations event, SeismogramFileTypes saveFileType) throws IOException, NoPreferredOrigin, CodecException, UnsupportedFileTypeException, SeedFormatException {
        if (saveFileType.equals(SeismogramFileTypes.SAC)) {
            return URLDataSetSeismogram.saveAsSac(seis, directory, channel, event);
        }
        if (saveFileType.equals(SeismogramFileTypes.MSEED)) {
            return URLDataSetSeismogram.saveAsMSeed(seis, directory, channel, event);
        }
        throw new UnsupportedFileTypeException("Unsupported File Type " + saveFileType.getValue());
    }

    public static File getUnusedFileName(File directory, Channel channel, String suffix) throws IOException, NoPreferredOrigin, CodecException {
        if (channel == null) {
            throw new IllegalArgumentException("Channel cannot be null");
        }
        String seisFilename = "";
        seisFilename = ChannelIdUtil.toStringNoDates((ChannelId)channel.get_id());
        seisFilename = seisFilename.replace(' ', '_');
        seisFilename = seisFilename + suffix;
        File seisFile = new File(directory, seisFilename);
        int n = 0;
        while (seisFile.exists()) {
            seisFilename = ChannelIdUtil.toStringNoDates((ChannelId)channel.get_id()) + "." + ++n;
            seisFilename = seisFilename.replace(' ', '_');
            seisFilename = seisFilename + suffix;
            seisFile = new File(directory, seisFilename);
        }
        return seisFile;
    }

    public static File saveAsMSeed(LocalSeismogramImpl seis, File directory, Channel channel, EventAccessOperations event) throws IOException, NoPreferredOrigin, CodecException, SeedFormatException {
        File seisFile = URLDataSetSeismogram.getUnusedFileName(directory, channel, ".mseed");
        DataRecord[] dr = FissuresConvert.toMSeed((LocalSeismogram)seis);
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(seisFile)));
        for (int i = 0; i < dr.length; ++i) {
            dr[i].write(dos);
        }
        dos.close();
        return seisFile;
    }

    public static File saveAsSac(LocalSeismogramImpl seis, File directory, Channel channel, EventAccessOperations event) throws IOException, NoPreferredOrigin, CodecException {
        File seisFile = URLDataSetSeismogram.getUnusedFileName(directory, channel, ".sac");
        SacTimeSeries sac = FissuresToSac.getSAC(seis, channel, event != null ? event.get_preferred_origin() : null);
        sac.write(seisFile);
        return seisFile;
    }

    private void setRequestFilter(LocalSeismogramImpl seis) {
        MicroSecondDate begin = seis.getBeginTime();
        MicroSecondDate end = seis.getEndTime();
        ChannelId chanId = seis.getChannelID();
        if (this.requestFilter != null) {
            MicroSecondDate tmp = new MicroSecondDate(this.requestFilter.start_time);
            if (tmp.before((Date)begin)) {
                begin = tmp;
            }
            if ((tmp = new MicroSecondDate(this.requestFilter.end_time)).after((Date)end)) {
                end = tmp;
            }
            seis.channel_id = chanId = this.requestFilter.channel_id;
        }
        this.requestFilter = new RequestFilter(chanId, begin.getFissuresTime(), end.getFissuresTime());
    }

    /*
     * WARNING - void declaration
     */
    private LocalSeismogramImpl getSeismogram(int seisNum) throws IOException, FissuresException, SeedFormatException, UnsupportedFileTypeException {
        void var4_4;
        Object chanBegin;
        LocalSeismogramImpl seis;
        URL seisURL = this.url[seisNum];
        Object obj = this.urlToLSMap.get(seisURL);
        if (obj instanceof SoftReference) {
            Object ref = ((SoftReference)obj).get();
            if (ref != null) {
                obj = ref;
            } else {
                this.urlToLSMap.remove(seisURL);
                obj = null;
            }
        }
        if (obj != null) {
            return (LocalSeismogramImpl)obj;
        }
        if (this.isPSN(seisNum)) {
            URL psnURL = URLDataSetSeismogram.getURLfromPSNURL(seisURL);
            PSNDataFile psnDataFile = new PSNDataFile(new DataInputStream(new BufferedInputStream(psnURL.openStream())));
            int evRecIndex = URLDataSetSeismogram.getIndexFromPSNURL(seisURL);
            seis = PSNToFissures.getSeismograms(psnDataFile)[evRecIndex];
        } else if (this.isMSeed(seisNum)) {
            MiniSeedRead mseedRead = new MiniSeedRead((DataInput)new DataInputStream(new BufferedInputStream(seisURL.openStream())));
            LinkedList<DataRecord> list = new LinkedList<DataRecord>();
            try {
                while (true) {
                    DataRecord dr = mseedRead.getNextRecord();
                    list.add(dr);
                }
            }
            catch (EOFException e) {
                seis = FissuresConvert.toFissures(list.toArray(new DataRecord[0]));
            }
        } else if (this.isSac(seisNum)) {
            SacTimeSeries sacTime = new SacTimeSeries();
            sacTime.read(new DataInputStream(new BufferedInputStream(seisURL.openStream())));
            seis = SacToFissures.getSeismogram(sacTime);
        } else {
            throw new UnsupportedFileTypeException("File type " + this.fileType[seisNum].getValue() + " is not supported");
        }
        Object netBegin = this.getAuxillaryData(StdAuxillaryDataNames.NETWORK_BEGIN);
        if (netBegin != null && netBegin instanceof String) {
            var4_4.channel_id.network_id.begin_time = new Time((String)netBegin, -1);
        }
        if ((chanBegin = this.getAuxillaryData(StdAuxillaryDataNames.CHANNEL_BEGIN)) != null && chanBegin instanceof String) {
            var4_4.channel_id.begin_time = new Time((String)chanBegin, -1);
        }
        this.addToCache(seisURL, this.fileType[seisNum], (LocalSeismogramImpl)var4_4);
        return var4_4;
    }

    public boolean isSac(int seisNum) {
        return this.fileType[seisNum].equals(SeismogramFileTypes.SAC);
    }

    public boolean isMSeed(int seisNum) {
        return this.fileType[seisNum].equals(SeismogramFileTypes.MSEED);
    }

    public boolean isPSN(int seisNum) {
        return this.fileType[seisNum].equals(SeismogramFileTypes.PSN);
    }

    public void addToCache(URL seisurl, SeismogramFileTypes seisFileType, LocalSeismogramImpl seis) {
        this.setRequestFilter(seis);
        this.addToCache(seis);
        this.urlToLSMap.put(seisurl, new SoftReference<LocalSeismogramImpl>(seis));
        boolean found = false;
        for (int i = 0; i < this.url.length; ++i) {
            if (!seisurl.equals(this.url[i])) continue;
            found = true;
        }
        if (!found) {
            URL[] tmp = new URL[this.url.length + 1];
            System.arraycopy(this.url, 0, tmp, 0, this.url.length);
            this.url = tmp;
            this.url[this.url.length - 1] = seisurl;
            SeismogramFileTypes[] tmpTypes = new SeismogramFileTypes[this.fileType.length + 1];
            System.arraycopy(this.fileType, 0, tmpTypes, 0, this.fileType.length);
            this.fileType = tmpTypes;
            this.fileType[this.fileType.length - 1] = seisFileType;
        }
    }

    public void insertInto(XMLStreamWriter writer, URL base) throws XMLStreamException {
        XMLUtil.writeTextElement(writer, "name", this.getName());
        writer.writeStartElement("requestFilter");
        XMLRequestFilter.insert(writer, this.getRequestFilter());
        XMLUtil.writeEndElementWithNewLine(writer);
        logger.debug((Object)("Saving " + this.url.length + " urls for " + this.getName()));
        String baseStr = base.toString();
        for (int i = 0; i < this.url.length; ++i) {
            String outStr = this.url[i].toString();
            logger.debug((Object)("base=" + baseStr + " outStr=" + outStr));
            if (outStr.startsWith(baseStr)) {
                outStr = outStr.substring(baseStr.length());
            }
            writer.writeStartElement("url");
            writer.writeAttribute("xlink:type", "simple");
            writer.writeAttribute("xlink:href", outStr);
            writer.writeAttribute("xlink:role", this.fileType[i].getURLValue().toString());
            XMLUtil.writeEndElementWithNewLine(writer);
        }
        Iterator it = this.getAuxillaryDataKeys().iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (next instanceof String) {
                if (this.getAuxillaryData(next) instanceof String) {
                    writer.writeStartElement(PROPERTY);
                    XMLProperty.insert(writer, (String)next, (String)this.getAuxillaryData(next));
                    XMLUtil.writeEndElementWithNewLine(writer);
                    continue;
                }
                if (!(this.getAuxillaryData(next) instanceof Element)) continue;
                logger.debug((Object)"namedValue insert placeholder");
                continue;
            }
            logger.warn((Object)("try to save aux data " + next + " " + this.getAuxillaryData(next).getClass() + ": " + this.getAuxillaryData(next) + " but don't know how."));
        }
    }

    public void insertInto(Element element, URL base) {
        Document doc = element.getOwnerDocument();
        element.appendChild(XMLUtil.createTextElement(doc, "name", this.getName()));
        Element rf = doc.createElement("requestFilter");
        XMLRequestFilter.insert(rf, this.getRequestFilter());
        element.appendChild(rf);
        logger.debug((Object)("Saving " + this.url.length + " urls for " + this.getName()));
        String baseStr = base.toString();
        for (int i = 0; i < this.url.length; ++i) {
            String outStr = this.url[i].toString();
            logger.debug((Object)("base=" + baseStr + " outStr=" + outStr));
            if (outStr.startsWith(baseStr)) {
                outStr = outStr.substring(baseStr.length());
            }
            Element urlElement = doc.createElement("url");
            urlElement.setAttribute("xlink:type", "simple");
            urlElement.setAttribute("xlink:href", outStr);
            urlElement.setAttribute("xlink:role", this.fileType[i].getURLValue().toString());
            element.appendChild(urlElement);
        }
        Iterator it = this.getAuxillaryDataKeys().iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (next instanceof String) {
                if (this.getAuxillaryData(next) instanceof String) {
                    Element prop = doc.createElement(PROPERTY);
                    XMLProperty.insert(prop, (String)next, (String)this.getAuxillaryData(next));
                    continue;
                }
                if (!(this.getAuxillaryData(next) instanceof Element)) continue;
                Element namedValue = doc.createElement(NAMED_VALUE);
                namedValue.appendChild(XMLUtil.createTextElement(doc, "name", (String)next));
                Element valueElement = doc.createElement("value");
                valueElement.appendChild(doc.importNode((Element)this.getAuxillaryData(next), true));
                namedValue.appendChild(valueElement);
                element.appendChild(namedValue);
                continue;
            }
            logger.warn((Object)("try to save aux data " + next + " " + this.getAuxillaryData(next).getClass() + ": " + this.getAuxillaryData(next) + " but don't know how."));
        }
    }

    public static URLDataSetSeismogram getURLDataSetSeismogram(URL base, Element element) throws UnsupportedFileTypeException {
        int i;
        String name = XMLUtil.getText(XMLUtil.getElement(element, "name"));
        RequestFilter request = XMLRequestFilter.getRequestFilter(XMLUtil.getElement(element, "requestFilter"));
        NodeList children = element.getElementsByTagName("url");
        LinkedList<SeismogramFileTypes> fileTypeList = new LinkedList<SeismogramFileTypes>();
        LinkedList<URL> urlList = new LinkedList<URL>();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            NamedNodeMap attrList = children.item(i2).getAttributes();
            Node urlNode = attrList.getNamedItem("xlink:href");
            Node fileTypeNode = attrList.getNamedItem("xlink:role");
            if (urlNode != null && fileTypeNode != null) {
                try {
                    urlList.add(new URL(base, urlNode.getNodeValue()));
                    fileTypeList.add(SeismogramFileTypes.fromString(fileTypeNode.getNodeValue()));
                }
                catch (MalformedURLException e) {
                    GlobalExceptionHandler.handle("MalformedURLException should never happen", e);
                }
                continue;
            }
            GlobalExceptionHandler.handle(new UnsupportedFileTypeException("File type for " + urlNode.getNodeValue() + " is null, skipping."));
        }
        URL[] urls = new URL[children.getLength()];
        urls = urlList.toArray(urls);
        SeismogramFileTypes[] seisTypes = fileTypeList.toArray(new SeismogramFileTypes[0]);
        URLDataSetSeismogram urlDSS = new URLDataSetSeismogram(urls, seisTypes, name, request);
        children = element.getElementsByTagName(NAMED_VALUE);
        for (i = 0; i < children.getLength(); ++i) {
            Element nameElement = (Element)((Element)children.item(i)).getElementsByTagName("name").item(0);
            String auxName = XMLUtil.getText(nameElement);
            urlDSS.addAuxillaryData(auxName, ((Element)children.item(i)).getElementsByTagName("value").item(0).getFirstChild());
        }
        children = element.getElementsByTagName(PROPERTY);
        for (i = 0; i < children.getLength(); ++i) {
            Property p = XMLProperty.getProperty((Element)children.item(i));
            urlDSS.addAuxillaryData(p.name, p.value);
        }
        return urlDSS;
    }

    public static URL createPSNURL(URL psnUrl, int index) throws MalformedURLException {
        return new URL(psnUrl.toString() + "#edu.sc.seis.fissuresUtil.psn.PSNEventRecord=" + index);
    }

    public static URL getURLfromPSNURL(URL psnURL) throws MalformedURLException {
        String urlString = psnURL.toString();
        return new URL(urlString.substring(0, urlString.indexOf(35)));
    }

    public static int getIndexFromPSNURL(URL psnURL) {
        String urlString = psnURL.toString();
        return Integer.parseInt(urlString.substring(urlString.indexOf(61) + 1));
    }
}

