/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class MemoryDataSet
implements DataSet {
    protected String name;
    protected String owner;
    protected String id;
    private Map chanIdStringsToChannels = new HashMap();
    protected LinkedList datasetSeismogramNames = new LinkedList();
    protected LinkedList parameterNames = new LinkedList();
    protected LinkedList datasetNames = new LinkedList();
    protected HashMap datasetSeismograms = new HashMap();
    protected HashMap parameters = new HashMap();
    protected HashMap datasets = new HashMap();

    public MemoryDataSet(String id, String name, String owner, AuditInfo[] audit) {
        this.id = id;
        this.setName(name);
        this.setOwner(owner);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getId() {
        return this.id;
    }

    public String[] getDataSetNames() {
        return this.datasetNames.toArray(new String[0]);
    }

    public DataSet getDataSet(String dsName) {
        return (DataSet)this.datasets.get(dsName);
    }

    public DataSet createChildDataSet(String newId, String newName, String newOwner, AuditInfo[] audit) {
        MemoryDataSet child = new MemoryDataSet(newId, newName, newOwner, audit);
        this.addDataSet(child, audit);
        return child;
    }

    public void addDataSet(DataSet dataset, AuditInfo[] audit) {
        this.datasets.put(dataset.getName(), dataset);
        this.datasetNames.add(dataset.getName());
    }

    public String[] getDataSetSeismogramNames() {
        return this.datasetSeismogramNames.toArray(new String[0]);
    }

    public void addDataSetSeismogram(DataSetSeismogram dss, AuditInfo[] audit) {
        if (this.datasetSeismogramNames.contains(dss.getName())) {
            int n = 1;
            String tmpName = dss.getName();
            while (this.datasetSeismogramNames.contains(tmpName)) {
                tmpName = dss.getName() + "." + ++n;
            }
            dss.setName(tmpName);
        }
        dss.setDataSet(this);
        this.datasetSeismograms.put(dss.getName(), dss);
        this.datasetSeismogramNames.add(dss.getName());
    }

    public DataSetSeismogram getDataSetSeismogram(String seismogramName) {
        return (DataSetSeismogram)this.datasetSeismograms.get(seismogramName);
    }

    public void remove(DataSetSeismogram dss) {
        if (dss != null) {
            this.datasetSeismograms.remove(dss.getName());
            this.datasetSeismogramNames.remove(dss.getName());
        }
    }

    public String[] getParameterNames() {
        return this.parameterNames.toArray(new String[0]);
    }

    public Object getParameter(String paramName) {
        return this.parameters.get(paramName);
    }

    public void addParameter(String paramName, Object param, AuditInfo[] audit) {
        if (paramName.startsWith("edu.sc.seis.fissuresUtil.xml#CHANNEL_")) {
            Channel chan = (Channel)param;
            this.chanIdStringsToChannels.put(ChannelIdUtil.toString((ChannelId)chan.get_id()), chan);
        }
        this.parameters.put(paramName, param);
        this.parameterNames.add(paramName);
    }

    public ChannelId[] getChannelIds() {
        String[] paramNames = this.getParameterNames();
        LinkedList<ChannelId> out = new LinkedList<ChannelId>();
        for (int counter = 0; counter < paramNames.length; ++counter) {
            if (!paramNames[counter].startsWith("edu.sc.seis.fissuresUtil.xml#CHANNEL_")) continue;
            Channel channel = (Channel)this.getParameter(paramNames[counter]);
            out.add(channel.get_id());
        }
        ChannelId[] channelIds = new ChannelId[out.size()];
        channelIds = out.toArray(channelIds);
        return channelIds;
    }

    public Channel getChannel(ChannelId channelId) {
        return (Channel)this.chanIdStringsToChannels.get(ChannelIdUtil.toString((ChannelId)channelId));
    }

    public EventAccessOperations getEvent() {
        return (EventAccessOperations)this.getParameter("edu.sc.seis.fissuresUtil.xml#EVENT");
    }
}

