/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.database.LocalDataCenterCallBack;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.RequestFilterChangeListener;
import edu.sc.seis.fissuresUtil.xml.SeisDataChangeEvent;
import edu.sc.seis.fissuresUtil.xml.SeisDataChangeListener;
import edu.sc.seis.fissuresUtil.xml.SeisDataErrorEvent;
import edu.sc.seis.fissuresUtil.xml.StdAuxillaryDataNames;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;

public abstract class DataSetSeismogram
implements LocalDataCenterCallBack,
Cloneable,
StdAuxillaryDataNames {
    private int MIN_NAME_LENGTH = 5;
    private List dssDataListeners;
    private List rfChangeListeners;
    protected List seisCache = Collections.synchronizedList(new ArrayList());
    RequestFilter requestFilter;
    private DataSet dataSet = null;
    private String name = null;
    private HashMap auxillaryData = new HashMap();
    static Category logger = Category.getInstance((String)(class$edu$sc$seis$fissuresUtil$xml$DataSetSeismogram == null ? (class$edu$sc$seis$fissuresUtil$xml$DataSetSeismogram = DataSetSeismogram.class$("edu.sc.seis.fissuresUtil.xml.DataSetSeismogram")) : class$edu$sc$seis$fissuresUtil$xml$DataSetSeismogram).getName());
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$xml$DataSetSeismogram;

    public DataSetSeismogram(DataSet ds, String name) {
        this(ds, name, null);
    }

    public DataSetSeismogram(DataSet ds, String name, RequestFilter requestFilter) {
        this.dssDataListeners = new LinkedList();
        this.rfChangeListeners = new LinkedList();
        this.requestFilter = requestFilter;
        this.dataSet = ds;
        this.name = name;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"Caught clone not supported, but this cannot happen!");
            return null;
        }
    }

    public boolean equals(Object other) {
        MicroSecondDate thisE;
        MicroSecondDate thisB;
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        if (super.equals(other)) {
            return true;
        }
        DataSetSeismogram otherDSS = (DataSetSeismogram)other;
        if (!otherDSS.getName().equals(this.getName())) {
            return false;
        }
        if (!ChannelIdUtil.areEqual((ChannelId)otherDSS.getRequestFilter().channel_id, (ChannelId)this.getRequestFilter().channel_id)) {
            return false;
        }
        MicroSecondDate otherB = otherDSS.getBeginMicroSecondDate();
        if (!otherB.equals((Object)(thisB = this.getBeginMicroSecondDate()))) {
            return false;
        }
        MicroSecondDate otherE = otherDSS.getEndMicroSecondDate();
        if (!otherE.equals((Object)(thisE = this.getEndMicroSecondDate()))) {
            return false;
        }
        return otherDSS.getDataSet() == this.getDataSet();
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public Channel getChannel() {
        return this.getDataSet().getChannel(this.getChannelId());
    }

    public EventAccessOperations getEvent() {
        return this.getDataSet().getEvent();
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public String getName() {
        if (!this.isNameAutogenerated()) {
            return this.name;
        }
        return this.getAutogeneratedName();
    }

    public void setName(String name) {
        if (name.length() < this.MIN_NAME_LENGTH) {
            throw new IllegalArgumentException("name must be at least " + this.MIN_NAME_LENGTH + " characters, " + name);
        }
        this.name = name;
    }

    public boolean isNameAutogenerated() {
        return this.name == null || this.name.length() <= this.MIN_NAME_LENGTH;
    }

    protected String getAutogeneratedName() {
        Channel chan;
        String autoname = "";
        ChannelId channelId = this.getRequestFilter().channel_id;
        if (channelId != null && this.getDataSet() != null && (chan = this.getDataSet().getChannel(channelId)) != null) {
            autoname = chan.my_site.my_station.name + " " + channelId.channel_code;
        }
        if (autoname == null || autoname.length() <= this.MIN_NAME_LENGTH) {
            autoname = ChannelIdUtil.toStringNoDates((ChannelId)this.getRequestFilter().channel_id);
        }
        return autoname;
    }

    public String toString() {
        return this.getName();
    }

    public MicroSecondDate getBeginMicroSecondDate() {
        return new MicroSecondDate(this.getBeginTime());
    }

    public Time getBeginTime() {
        return this.getRequestFilter().start_time;
    }

    public void setBeginTime(Time time) {
        this.getRequestFilter().start_time = time;
        this.fireBeginTimeChangedEvent();
    }

    public MicroSecondDate getEndMicroSecondDate() {
        return new MicroSecondDate(this.getEndTime());
    }

    public Time getEndTime() {
        return this.getRequestFilter().end_time;
    }

    public void setEndTime(Time time) {
        this.getRequestFilter().end_time = time;
        this.fireEndTimeChangedEvent();
    }

    public RequestFilter getRequestFilter() {
        return this.requestFilter;
    }

    public ChannelId getChannelId() {
        return this.getRequestFilter().channel_id;
    }

    public void addRequestFilterChangeListener(RequestFilterChangeListener listener) {
        this.rfChangeListeners.add(listener);
    }

    public void removeRequestFilterChangeListener(RequestFilterChangeListener listener) {
        this.rfChangeListeners.remove(listener);
    }

    protected void fireEndTimeChangedEvent() {
        LinkedList tmp = new LinkedList(this.rfChangeListeners);
        Iterator iterator = tmp.iterator();
        while (iterator.hasNext()) {
            RequestFilterChangeListener listener = (RequestFilterChangeListener)iterator.next();
            listener.endTimeChanged();
        }
    }

    protected void fireBeginTimeChangedEvent() {
        LinkedList tmp = new LinkedList(this.rfChangeListeners);
        Iterator iterator = tmp.iterator();
        while (iterator.hasNext()) {
            RequestFilterChangeListener listener = (RequestFilterChangeListener)iterator.next();
            listener.beginTimeChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSeisDataChangeListener(SeisDataChangeListener dataListener) {
        List list = this.dssDataListeners;
        synchronized (list) {
            this.dssDataListeners.add(dataListener);
        }
    }

    public void removeSeisDataChangeListener(SeisDataChangeListener dataListener) {
        this.dssDataListeners.remove(dataListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireNewDataEvent(SeisDataChangeEvent event) {
        LinkedList tmp;
        List list = this.dssDataListeners;
        synchronized (list) {
            tmp = new LinkedList(this.dssDataListeners);
        }
        Iterator iterator = tmp.iterator();
        while (iterator.hasNext()) {
            SeisDataChangeListener dssDataListener = (SeisDataChangeListener)iterator.next();
            dssDataListener.pushData(event);
        }
    }

    protected void fireDataFinishedEvent(SeisDataChangeEvent event) {
        LinkedList tmp = new LinkedList(this.dssDataListeners);
        Iterator iterator = tmp.iterator();
        while (iterator.hasNext()) {
            SeisDataChangeListener dssDataListener = (SeisDataChangeListener)iterator.next();
            dssDataListener.finished(event);
        }
    }

    protected void fireDataErrorEvent(SeisDataErrorEvent event) {
        LinkedList tmp = new LinkedList(this.dssDataListeners);
        Iterator iterator = tmp.iterator();
        while (iterator.hasNext()) {
            SeisDataChangeListener dssDataListener = (SeisDataChangeListener)iterator.next();
            dssDataListener.error(event);
        }
    }

    public void pushData(LocalSeismogramImpl[] seismograms, SeisDataChangeListener initiator) {
        SeisDataChangeEvent event = new SeisDataChangeEvent(seismograms, this, initiator);
        this.addToCache(seismograms);
        if (initiator != null && !this.dssDataListeners.contains(initiator)) {
            initiator.pushData(event);
        }
        this.fireNewDataEvent(event);
    }

    protected void addToCache(LocalSeismogramImpl[] seismograms) {
        for (int i = 0; i < seismograms.length; ++i) {
            this.addToCache(seismograms[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToCache(LocalSeismogramImpl seismogram) {
        List list = this.seisCache;
        synchronized (list) {
            if (!this.cacheContains(seismogram)) {
                this.seisCache.add(new SoftReference<LocalSeismogramImpl>(seismogram));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cacheContains(LocalSeismogramImpl seismogram) {
        List list = this.seisCache;
        synchronized (list) {
            Iterator it = this.seisCache.iterator();
            while (it.hasNext()) {
                LocalSeismogramImpl current = (LocalSeismogramImpl)((SoftReference)it.next()).get();
                if (current == null) {
                    it.remove();
                    continue;
                }
                if (current.get_id().equals(seismogram.get_id()) || DataSetSeismogram.equalOrContains(current, seismogram)) {
                    return true;
                }
                if (!DataSetSeismogram.equalOrContains(seismogram, current)) continue;
                it.remove();
                return false;
            }
        }
        return false;
    }

    public static boolean equalOrContains(LocalSeismogramImpl one, LocalSeismogramImpl two) {
        return !(!one.getBeginTime().equals((Object)two.getBeginTime()) && !one.getBeginTime().before((Date)two.getBeginTime()) || !one.getEndTime().equals((Object)two.getEndTime()) && !one.getEndTime().after((Date)two.getEndTime()));
    }

    public void finished(SeisDataChangeListener initiator) {
        SeisDataChangeEvent event = new SeisDataChangeEvent(this, initiator);
        if (!this.dssDataListeners.contains(initiator)) {
            initiator.finished(event);
        }
        this.fireDataFinishedEvent(event);
    }

    public void error(SeisDataChangeListener initiator, Throwable e) {
        SeisDataErrorEvent event = new SeisDataErrorEvent(e, this, (Object)initiator);
        if (!this.dssDataListeners.contains(initiator)) {
            initiator.error(event);
        }
        this.fireDataErrorEvent(event);
    }

    public abstract void retrieveData(SeisDataChangeListener var1);

    public void addAuxillaryData(Object key, Object value) {
        this.auxillaryData.put(key, value);
    }

    public Object getAuxillaryData(Object key) {
        return this.auxillaryData.get(key);
    }

    public Object removeAuxillaryData(Object key) {
        return this.auxillaryData.remove(key);
    }

    public Collection getAuxillaryDataKeys() {
        return this.auxillaryData.keySet();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

