/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.time;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.database.plottable.PlottableChunk;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;

public class SortTool {
    private static final SortTool st = new SortTool();

    public static LocalSeismogramImpl[] byLengthAscending(LocalSeismogramImpl[] seis) {
        Arrays.sort(seis, st.new SeisSizeSorter());
        return seis;
    }

    public static LocalSeismogramImpl[] byBeginTimeAscending(LocalSeismogramImpl[] seis) {
        SortTool sortTool = st;
        sortTool.getClass();
        Arrays.sort(seis, sortTool.new SeisBeginSorter());
        return seis;
    }

    public static PlottableChunk[] byBeginTimeAscending(PlottableChunk[] pc) {
        SortTool sortTool = st;
        sortTool.getClass();
        Arrays.sort(pc, sortTool.new PCBeginSorter());
        return pc;
    }

    public static RequestFilter[] byBeginTimeAscending(RequestFilter[] rf) {
        SortTool sortTool = st;
        sortTool.getClass();
        Arrays.sort(rf, sortTool.new RFBeginSorter());
        return rf;
    }

    public static MicroSecondTimeRange[] byBeginTimeAscending(MicroSecondTimeRange[] ranges) {
        SortTool sortTool = st;
        sortTool.getClass();
        Arrays.sort(ranges, sortTool.new MSTRBeginSorter());
        return ranges;
    }

    private class MSTRBeginSorter
    extends AscendingTimeSorter {
        private MSTRBeginSorter() {
        }

        public MicroSecondDate getTime(Object o) {
            return ((MicroSecondTimeRange)o).getBeginTime();
        }
    }

    private class RFBeginSorter
    extends AscendingTimeSorter {
        private RFBeginSorter() {
        }

        public MicroSecondDate getTime(Object o) {
            return new MicroSecondDate(((RequestFilter)o).start_time);
        }
    }

    private class PCBeginSorter
    extends AscendingTimeSorter {
        private PCBeginSorter() {
        }

        public MicroSecondDate getTime(Object o) {
            return ((PlottableChunk)o).getBeginTime();
        }
    }

    private class SeisBeginSorter
    extends AscendingTimeSorter {
        private SeisBeginSorter() {
        }

        public MicroSecondDate getTime(Object o) {
            return ((LocalSeismogramImpl)o).getBeginTime();
        }
    }

    public static class AscendingTimeSorter
    implements Comparator {
        public int compare(Object o1, Object o2) {
            MicroSecondDate o2Begin;
            MicroSecondDate o1Begin = this.getTime(o1);
            if (o1Begin.before((Date)(o2Begin = this.getTime(o2)))) {
                return -1;
            }
            if (o1Begin.after((Date)o2Begin)) {
                return 1;
            }
            return 0;
        }

        public MicroSecondDate getTime(Object o) {
            return (MicroSecondDate)o;
        }
    }

    public class SeisSizeSorter
    extends AscendingSizeSorter {
        public TimeInterval getInterval(Object o) {
            return ((LocalSeismogramImpl)o).getTimeInterval();
        }
    }

    private class AscendingSizeSorter
    implements Comparator {
        private AscendingSizeSorter() {
        }

        public int compare(Object o1, Object o2) {
            TimeInterval int2;
            TimeInterval int1 = this.getInterval(o1);
            if (int1.lessThan((QuantityImpl)(int2 = this.getInterval(o2)))) {
                return -1;
            }
            if (int1.greaterThan((QuantityImpl)int2)) {
                return 1;
            }
            return 0;
        }

        public TimeInterval getInterval(Object o) {
            return (TimeInterval)o;
        }
    }
}

