/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.simple;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfSeismogramDC.DataCenterOperations;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.cache.BulletproofVestFactory;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import edu.sc.seis.fissuresUtil.simple.TestingClient;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class SimpleSeismogramClient
implements TestingClient {
    protected DataCenterOperations seisDC;
    private static final TimeInterval ONE_HOUR = new TimeInterval(1.0, UnitImpl.HOUR);
    private static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$simple$SimpleSeismogramClient == null ? (class$edu$sc$seis$fissuresUtil$simple$SimpleSeismogramClient = SimpleSeismogramClient.class$("edu.sc.seis.fissuresUtil.simple.SimpleSeismogramClient")) : class$edu$sc$seis$fissuresUtil$simple$SimpleSeismogramClient));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$simple$SimpleSeismogramClient;

    public SimpleSeismogramClient() {
        String serverDNS = "edu/iris/dmc";
        String serverName = "IRIS_BudDataCenter";
        try {
            Initializer.getNS().getSeismogramDCObject(serverDNS, serverName);
            logger.info((Object)"Got SeisDC as corba object, the name service is ok");
            this.seisDC = BulletproofVestFactory.vestSeismogramDC(serverDNS, serverName, Initializer.getNS());
            logger.info((Object)"got SeisDC");
        }
        catch (InvalidName e) {
            logger.error((Object)"Problem with name service: ", (Throwable)e);
        }
        catch (NotFound e) {
            logger.error((Object)"Problem with name service: ", (Throwable)e);
        }
        catch (CannotProceed e) {
            logger.error((Object)"Problem with name service: ", (Throwable)e);
        }
    }

    public void exercise() {
        this.available_data(true);
        this.retrieve_seismograms(true);
    }

    public void queuedRetrieve(String name) {
        try {
            String id = this.seisDC.queue_seismograms(SimpleSeismogramClient.createOldRF());
            logger.info((Object)("got id " + id + " for " + name));
            String status = this.seisDC.request_status(id);
            while (status.equals("Processing")) {
                status = this.seisDC.request_status(id);
                logger.info((Object)("Status is " + status + " for " + name));
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {}
            }
            logger.info((Object)("FINISHED " + name));
            logger.info((Object)(name + " status is " + status));
            if (status.equals("Finished")) {
                LocalSeismogram[] seis = this.seisDC.retrieve_queue(id);
                for (int i = 0; i < seis.length; ++i) {
                    System.out.println(name + " of " + i + " is " + seis[i].num_points + " points and starts at " + seis[i].begin_time.date_time);
                }
            }
        }
        catch (FissuresException e) {
            logger.info((Object)(name + " threw exception"));
            e.printStackTrace();
        }
    }

    public LocalSeismogram[] retrieve_seismograms() {
        return this.retrieve_seismograms(false);
    }

    public LocalSeismogram[] retrieve_seismograms(boolean verbose) {
        try {
            LocalSeismogram[] seis = this.seisDC.retrieve_seismograms(SimpleSeismogramClient.createCurrentRF());
            if (verbose) {
                logger.info((Object)("Got " + seis.length + " seismograms."));
                for (int i = 0; i < seis.length; ++i) {
                    logger.info((Object)("Seismogram " + i + " has " + seis[i].num_points + " points and starts at " + seis[i].begin_time.date_time));
                }
            }
            return seis;
        }
        catch (FissuresException e) {
            throw new RuntimeException(e);
        }
    }

    public RequestFilter[] available_data(boolean verbose) {
        return this.available_data(SimpleSeismogramClient.createCurrentRF(), verbose);
    }

    public RequestFilter[] available_data(RequestFilter[] request, boolean verbose) {
        RequestFilter[] rf = this.seisDC.available_data(request);
        if (verbose) {
            logger.info((Object)("Got " + rf.length + " request filters back for available data"));
        }
        return rf;
    }

    public static RequestFilter[] createCurrentRF() {
        MicroSecondDate now = ClockUtil.now();
        MicroSecondDate hourAgo = now.subtract(ONE_HOUR);
        RequestFilter[] request = new RequestFilter[]{new RequestFilter(Initializer.fakeChan, hourAgo.getFissuresTime(), now.getFissuresTime())};
        return request;
    }

    public static RequestFilter[] createOldRF() {
        RequestFilter[] rf = new RequestFilter[]{new RequestFilter()};
        Time[] queryTimes = new Time[2];
        SimpleDateFormat formatter = new SimpleDateFormat("G yyyy.MM.dd hh:mm:ss z");
        try {
            queryTimes[0] = new MicroSecondDate(formatter.parse("AD 2003.07.20 06:23:25 GMT")).getFissuresTime();
            queryTimes[1] = new MicroSecondDate(formatter.parse("AD 2003.09.20 06:46:29 GMT")).getFissuresTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        rf[0].channel_id = new ChannelId(new NetworkId("IU", queryTimes[1]), "*", "*", "BHZ", queryTimes[1]);
        rf[0].end_time = queryTimes[1];
        rf[0].start_time = queryTimes[0];
        return rf;
    }

    public static void main(String[] args) {
        Initializer.init(args);
        new SimpleSeismogramClient().exercise();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

