/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.sac;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfEvent.EventAttr;
import edu.iris.Fissures.IfEvent.Magnitude;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesDataSel;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.LocationType;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.event.EventAttrImpl;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.SiteImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.text.DecimalFormat;

public class SacToFissures {
    public static LocalSeismogramImpl getSeismogram(SacTimeSeries sac, SeismogramAttr attr) throws FissuresException {
        double error;
        LocalSeismogramImpl seis = new LocalSeismogramImpl(attr, sac.y);
        if (seis.getNumPoints() != sac.npts) {
            seis.num_points = sac.npts;
        }
        SamplingImpl samp = seis.getSampling();
        TimeInterval period = samp.getPeriod();
        if (sac.delta != 0.0f && (error = (period.convertTo(UnitImpl.SECOND).getValue() - (double)sac.delta) / (double)sac.delta) > 0.01) {
            seis.sampling_info = new SamplingImpl(1, new TimeInterval((double)sac.delta, UnitImpl.SECOND));
        }
        if (sac.b != -12345.0f) {
            MicroSecondDate beginTime = SacToFissures.getSeismogramBeginTime(sac);
            double error2 = seis.getBeginTime().subtract(beginTime).divideBy((QuantityImpl)period).getValue();
            if (Math.abs(error2) > 0.01) {
                seis.begin_time = beginTime.getFissuresTime();
            }
        }
        return seis;
    }

    public static LocalSeismogramImpl getSeismogram(SacTimeSeries sac) throws FissuresException {
        DecimalFormat df;
        ISOTime isoTime = new ISOTime(sac.nzyear, sac.nzjday, sac.nzhour, sac.nzmin, (float)sac.nzsec + (float)sac.nzmsec / 1000.0f);
        MicroSecondDate beginTime = SacToFissures.getSeismogramBeginTime(sac);
        Time time = beginTime.getFissuresTime();
        TimeSeriesDataSel data = new TimeSeriesDataSel();
        data.flt_values(sac.y);
        ChannelId chanId = SacToFissures.getChannelId(sac);
        String evtName = "   ";
        if (!sac.kevnm.equals(SacTimeSeries.STRING16_UNDEF)) {
            evtName = evtName + sac.kevnm.trim() + " ";
        }
        if (sac.evla != SacTimeSeries.FLOAT_UNDEF) {
            if (sac.evlo != SacTimeSeries.FLOAT_UNDEF) {
                if (sac.evdp != SacTimeSeries.FLOAT_UNDEF) {
                    evtName = evtName + "lat: " + sac.evla + " lon: " + sac.evlo + " depth: " + sac.evdp / 1000.0f + " km";
                }
            }
        }
        if (sac.gcarc != SacTimeSeries.FLOAT_UNDEF) {
            df = new DecimalFormat("##0.#");
            evtName = evtName + "  " + df.format(sac.gcarc) + " deg.";
        }
        if (sac.az != SacTimeSeries.FLOAT_UNDEF) {
            df = new DecimalFormat("##0.#");
            evtName = evtName + "  az " + df.format(sac.az) + " deg.";
        }
        String seisId = chanId.network_id.network_code + ":" + chanId.station_code + ":" + chanId.site_code + ":" + chanId.channel_code + ":" + time.date_time;
        return new LocalSeismogramImpl(seisId, time, sac.npts, (Sampling)new SamplingImpl(1, new TimeInterval((double)sac.delta, UnitImpl.SECOND)), (Unit)UnitImpl.COUNT, chanId, data);
    }

    public static ChannelId getChannelId(SacTimeSeries sac) {
        if (!sac.khole.equals(SacTimeSeries.STRING8_UNDEF) && sac.khole.trim().length() == 2) {
            return SacToFissures.getChannelId(sac, sac.khole.trim());
        }
        return SacToFissures.getChannelId(sac, "  ");
    }

    public static ChannelId getChannelId(SacTimeSeries sac, String siteCode) {
        MicroSecondDate nzTime = SacToFissures.getNZTime(sac);
        Time fisTime = nzTime.getFissuresTime();
        String netCode = "XX";
        if (!sac.knetwk.trim().equals("-12345")) {
            netCode = sac.knetwk.trim();
        }
        String staCode = "XXXXX";
        if (!sac.kstnm.trim().equals("-12345")) {
            staCode = sac.kstnm.trim();
        }
        String chanCode = "XXX";
        if (!sac.kcmpnm.trim().equals("-12345") && (chanCode = sac.kcmpnm.trim()).length() == 5) {
            siteCode = chanCode.substring(0, 2);
            chanCode = chanCode.substring(2, 5);
        }
        NetworkId netId = new NetworkId(netCode, fisTime);
        ChannelId id = new ChannelId(netId, staCode, siteCode, chanCode, fisTime);
        return id;
    }

    public static Channel getChannel(SacTimeSeries sac) {
        float stdp;
        ChannelId chanId = SacToFissures.getChannelId(sac);
        float stel = sac.stel;
        if (stel == -12345.0f) {
            stel = 0.0f;
        }
        if ((stdp = sac.stdp) == -12345.0f) {
            stdp = 0.0f;
        }
        Location loc = new Location(sac.stla, sac.stlo, (Quantity)new QuantityImpl((double)sac.stel, (Unit)UnitImpl.METER), (Quantity)new QuantityImpl((double)sac.stdp, (Unit)UnitImpl.METER), LocationType.GEOGRAPHIC);
        Orientation orient = new Orientation(sac.cmpaz, sac.cmpinc - 90.0f);
        SamplingImpl samp = new SamplingImpl(1, new TimeInterval((double)sac.delta, UnitImpl.SECOND));
        TimeRange effective = new TimeRange(chanId.network_id.begin_time, new Time("edu.iris.Fissures/Time/UNKNOWN", 0));
        NetworkAttrImpl netAttr = new NetworkAttrImpl(chanId.network_id, chanId.network_id.network_code, "", "", effective);
        StationId staId = new StationId(chanId.network_id, chanId.station_code, chanId.network_id.begin_time);
        StationImpl station = new StationImpl(staId, chanId.station_code, loc, effective, "", "", "from sac", (NetworkAttr)netAttr);
        SiteId siteId = new SiteId(chanId.network_id, chanId.station_code, chanId.site_code, chanId.network_id.begin_time);
        SiteImpl site = new SiteImpl(siteId, loc, effective, (Station)station, "from sac");
        return new ChannelImpl(chanId, chanId.channel_code, orient, (Sampling)samp, effective, (Site)site);
    }

    public static MicroSecondDate getNZTime(SacTimeSeries sac) {
        ISOTime isoTime = new ISOTime(sac.nzyear, sac.nzjday, sac.nzhour, sac.nzmin, (float)sac.nzsec + (float)sac.nzmsec / 1000.0f);
        MicroSecondDate originTime = isoTime.getDate();
        return originTime;
    }

    public static MicroSecondDate getEventOriginTime(SacTimeSeries sac) {
        MicroSecondDate originTime = SacToFissures.getNZTime(sac);
        TimeInterval sacOMarker = new TimeInterval((double)sac.o, UnitImpl.SECOND);
        originTime = originTime.add(sacOMarker);
        return originTime;
    }

    public static MicroSecondDate getSeismogramBeginTime(SacTimeSeries sac) {
        MicroSecondDate bTime = SacToFissures.getNZTime(sac);
        TimeInterval sacBMarker = new TimeInterval((double)sac.b, UnitImpl.SECOND);
        bTime = bTime.add(sacBMarker);
        return bTime;
    }

    public static CacheEvent getEvent(SacTimeSeries sac) {
        if (sac.o != SacTimeSeries.FLOAT_UNDEF) {
            if (sac.evla != SacTimeSeries.FLOAT_UNDEF) {
                if (sac.evlo != SacTimeSeries.FLOAT_UNDEF) {
                    if (sac.evdp != SacTimeSeries.FLOAT_UNDEF) {
                        MicroSecondDate beginTime = SacToFissures.getEventOriginTime(sac);
                        EventAttrImpl attr = new EventAttrImpl("SAC Event");
                        Origin[] origins = new Origin[1];
                        Location loc = sac.evdp > 1000.0f ? new Location(sac.evla, sac.evlo, (Quantity)new QuantityImpl(0.0, (Unit)UnitImpl.METER), (Quantity)new QuantityImpl((double)sac.evdp, (Unit)UnitImpl.METER), LocationType.GEOGRAPHIC) : new Location(sac.evla, sac.evlo, (Quantity)new QuantityImpl(0.0, (Unit)UnitImpl.METER), (Quantity)new QuantityImpl((double)sac.evdp, (Unit)UnitImpl.KILOMETER), LocationType.GEOGRAPHIC);
                        origins[0] = new OriginImpl("genid:" + Math.round(Math.random() * 2.147483647E9), "", "", beginTime.getFissuresTime(), loc, new Magnitude[0], new ParameterRef[0]);
                        return new CacheEvent((EventAttr)attr, origins, origins[0]);
                    }
                }
            }
        }
        return null;
    }
}

