/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.rt130.RT130FormatException;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.BasicConfigurator;

public class SimpleFileReader {
    public static void main(String[] args) throws IOException, RT130FormatException {
        BasicConfigurator.configure();
        Properties props = Initializer.loadProperties(args);
        ConnMgr.installDbProperties(props, args);
        boolean one = false;
        boolean two = false;
        boolean four = false;
        boolean eight = false;
        boolean sixteen = false;
        boolean thirtyTwo = false;
        boolean sixtyFour = false;
        boolean oneHundredTwentyEight = false;
        boolean twoHundredFiftySix = false;
        for (int i = 1; i < args.length; ++i) {
            if (args[i].equals("1")) {
                one = true;
                continue;
            }
            if (args[i].equals("2")) {
                two = true;
                continue;
            }
            if (args[i].equals("4")) {
                four = true;
                continue;
            }
            if (args[i].equals("8")) {
                eight = true;
                continue;
            }
            if (args[i].equals("16")) {
                sixteen = true;
                continue;
            }
            if (args[i].equals("32")) {
                thirtyTwo = true;
                continue;
            }
            if (args[i].equals("64")) {
                sixtyFour = true;
                continue;
            }
            if (args[i].equals("128")) {
                oneHundredTwentyEight = true;
                continue;
            }
            if (!args[i].equals("256")) continue;
            twoHundredFiftySix = true;
        }
        if (args.length > 0) {
            String fileLoc = args[args.length - 1];
            try {
                DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(new File(fileLoc))));
                dis.skipBytes(1048);
                int data = 0;
                for (int count = 0; count <= 1000; ++count) {
                    if (one) {
                        System.out.println();
                    } else if (two) {
                        if (count % 2 == 0) {
                            System.out.println();
                        }
                    } else if (four) {
                        if (count % 4 == 0) {
                            System.out.println();
                        }
                    } else if (eight) {
                        if (count % 8 == 0) {
                            System.out.println();
                        }
                    } else if (sixteen) {
                        if (count % 16 == 0) {
                            System.out.println();
                        }
                    } else if (thirtyTwo) {
                        if (count % 32 == 0) {
                            System.out.println();
                        }
                    } else if (sixtyFour) {
                        if (count % 64 == 0) {
                            System.out.println();
                        }
                    } else if (oneHundredTwentyEight) {
                        if (count % 128 == 0) {
                            System.out.println();
                        }
                    } else if (twoHundredFiftySix && count % 256 == 0) {
                        System.out.println();
                    }
                    data = dis.readUnsignedByte();
                    if (data >= -99) {
                        if (data < -9) {
                            System.out.print(" ");
                        } else if (data < 0) {
                            System.out.print("  ");
                        } else if (data < 10) {
                            System.out.print("   ");
                        } else if (data < 100) {
                            System.out.print("  ");
                        } else {
                            System.out.print(" ");
                        }
                    }
                    System.out.print(data);
                    System.out.print(" ");
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("Could not find file " + fileLoc);
            }
        }
    }

    private static byte[] readBytes(DataInput in, int numBytes) throws IOException {
        byte[] seqBytes = new byte[numBytes];
        in.readFully(seqBytes);
        return seqBytes;
    }

    private static MicroSecondDate stringToMicroSecondDate(String timeString, int yearInt) throws RT130FormatException {
        String fractionsOfSecond = "";
        String seconds = "";
        String minutes = "";
        String hours = "";
        String daysOfYearReversed = "";
        if (timeString.length() >= 1) {
            fractionsOfSecond = "" + timeString.charAt(timeString.length() - 3);
            fractionsOfSecond = fractionsOfSecond + timeString.charAt(timeString.length() - 2);
            fractionsOfSecond = fractionsOfSecond + timeString.charAt(timeString.length() - 1);
        }
        if (timeString.length() >= 5) {
            seconds = "" + timeString.charAt(timeString.length() - 5);
            seconds = seconds + timeString.charAt(timeString.length() - 4);
        }
        if (timeString.length() >= 7) {
            minutes = "" + timeString.charAt(timeString.length() - 7);
            minutes = minutes + timeString.charAt(timeString.length() - 6);
        }
        if (timeString.length() >= 9) {
            hours = "" + timeString.charAt(timeString.length() - 9);
            hours = hours + timeString.charAt(timeString.length() - 8);
        }
        if (timeString.length() >= 10) {
            daysOfYearReversed = "" + timeString.charAt(timeString.length() - 10);
        }
        if (timeString.length() >= 11) {
            daysOfYearReversed = daysOfYearReversed + timeString.charAt(timeString.length() - 11);
        }
        if (timeString.length() >= 12) {
            daysOfYearReversed = daysOfYearReversed + timeString.charAt(timeString.length() - 12);
        }
        if (timeString.length() > 12 || timeString.length() < 9) {
            System.err.println("Cannot read time field of Packet Header.");
            throw new RT130FormatException();
        }
        String daysOfYear = "0";
        for (int i = daysOfYearReversed.length() - 1; i >= 0; --i) {
            daysOfYear = daysOfYear.concat("" + daysOfYearReversed.charAt(i));
        }
        int daysOfYearInt = Integer.valueOf(daysOfYear);
        int hoursInt = Integer.valueOf(hours);
        int minutesInt = Integer.valueOf(minutes);
        seconds = seconds.concat(".");
        seconds = seconds.concat(fractionsOfSecond);
        float secondsInt = Float.valueOf(seconds).floatValue();
        ISOTime isoTime = new ISOTime(yearInt, daysOfYearInt, hoursInt, minutesInt, secondsInt);
        return isoTime.getDate();
    }
}

