/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.time.SortTool;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class NCFile {
    public MicroSecondDate network_begin_time;
    private List keyList;
    private Map timeAndDataHashMap;

    public NCFile(String ncFileLocation) throws IOException {
        File file = new File(ncFileLocation);
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis);
        DataInputStream dis = new DataInputStream(bis);
        this.readFile(dis);
    }

    public void readFile(DataInput in) throws IOException {
        this.timeAndDataHashMap = new HashMap();
        boolean done = false;
        String data = "";
        String line = "";
        while (!done) {
            try {
                line = in.readLine();
                if (line == null) {
                    done = true;
                    continue;
                }
                if (line.startsWith("#")) continue;
                data = data.concat(line);
                data = data + "\n";
            }
            catch (EOFException e) {
                done = true;
            }
        }
        StringTokenizer st = new StringTokenizer(data);
        String token = "";
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (!token.equals("START")) continue;
            MicroSecondDate time = this.stringToMicroSecondDate(st.nextToken());
            if (this.network_begin_time == null) {
                this.network_begin_time = time;
            }
            HashMap<String, String> dataHashMap = new HashMap<String, String>();
            while (!st.nextToken().startsWith("chan/dip/azi")) {
            }
            String temp = st.nextToken();
            while (!temp.startsWith("END")) {
                String unitName = temp;
                String unitId = st.nextToken().substring(0, 4);
                dataHashMap.put(unitId, unitName);
                st.nextToken();
                st.nextToken();
                temp = st.nextToken();
            }
            this.timeAndDataHashMap.put(time, dataHashMap);
        }
        Set keySet = this.timeAndDataHashMap.keySet();
        MicroSecondDate[] keyArray = keySet.toArray(new MicroSecondDate[0]);
        this.keyList = new ArrayList(keyArray.length);
        for (int i = 0; i < keyArray.length; ++i) {
            this.keyList.add(keyArray[i]);
        }
        Collections.sort(this.keyList, new SortTool.AscendingTimeSorter());
    }

    private MicroSecondDate stringToMicroSecondDate(String timeString) {
        StringTokenizer st = new StringTokenizer(timeString, ":");
        int yearInt = Integer.parseInt(st.nextToken());
        int daysOfYearInt = Integer.parseInt(st.nextToken());
        int hoursInt = Integer.parseInt(st.nextToken());
        ISOTime isoTime = new ISOTime(yearInt, daysOfYearInt, hoursInt, 0, 0.0f);
        return isoTime.getDate();
    }

    public String getUnitName(MicroSecondDate time, String unitId) {
        MicroSecondDate[] keyArray = this.keyList.toArray(new MicroSecondDate[0]);
        for (int i = 0; i < keyArray.length; ++i) {
            if (!time.before((Date)keyArray[i])) continue;
            Map dataHashMap = (Map)this.timeAndDataHashMap.get(keyArray[i - 1]);
            String unitName = (String)dataHashMap.get(unitId);
            return unitName;
        }
        return null;
    }
}

