/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.mockFissures.IfNetwork;

import edu.iris.Fissures.Area;
import edu.iris.Fissures.AuditElement;
import edu.iris.Fissures.IfNetwork.Calibration;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelIdIterHolder;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.OrientationRange;
import edu.iris.Fissures.IfNetwork.SamplingRange;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.IfNetwork.TimeCorrection;
import edu.iris.Fissures.NotImplemented;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockChannel;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockNetworkAttr;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockStation;

public class MockNetworkAccess
implements NetworkAccess {
    private NetworkAttr attributes;
    private Station[] stations;
    private Channel[][] channels;

    public static NetworkAccess createNetworkAccess() {
        Channel[] channels = new Channel[]{MockChannel.createChannel(), MockChannel.createNorthChannel(), MockChannel.createEastChannel()};
        return new MockNetworkAccess(MockNetworkAttr.createNetworkAttr(), MockStation.createStation(), channels);
    }

    public static NetworkAccess createOtherNetworkAccess() {
        return new MockNetworkAccess(MockNetworkAttr.createOtherNetworkAttr(), MockStation.createOtherStation(), new Channel[]{MockChannel.createOtherNetChan()});
    }

    public static NetworkAccess createManySplendoredNetworkAccess() {
        Station[] stations = MockStation.createMultiSplendoredStations();
        Channel[][] channels = new Channel[stations.length][];
        for (int i = 0; i < stations.length; ++i) {
            channels[i] = MockChannel.createMotionVector(stations[i]);
        }
        return new MockNetworkAccess(MockNetworkAttr.createMultiSplendoredAttr(), stations, channels);
    }

    private MockNetworkAccess(NetworkAttr attributes, Station station, Channel[] channels) {
        this(attributes, new Station[]{station}, MockNetworkAccess.make2DArray(channels));
    }

    private static Channel[][] make2DArray(Channel[] channels) {
        Channel[][] channels2d = new Channel[][]{channels};
        return channels2d;
    }

    private MockNetworkAccess(NetworkAttr attributes, Station[] station, Channel[][] channels) {
        this.attributes = attributes;
        this.stations = station;
        this.channels = channels;
    }

    public Station[] retrieve_stations() {
        return this.stations;
    }

    public Instrumentation retrieve_instrumentation(ChannelId p1, Time p2) throws ChannelNotFound {
        return null;
    }

    public Channel[] retrieve_channels_by_code(String p1, String p2, String p3) throws ChannelNotFound {
        return null;
    }

    public Channel retrieve_channel(ChannelId p1) throws ChannelNotFound {
        for (int j = 0; j < this.channels.length; ++j) {
            for (int i = 0; i < this.channels[j].length; ++i) {
                if (!ChannelIdUtil.areEqual((ChannelId)this.channels[j][i].get_id(), (ChannelId)p1)) continue;
                return this.channels[j][i];
            }
        }
        throw new ChannelNotFound();
    }

    public Channel[] retrieve_for_station(StationId p1) {
        for (int i = 0; i < this.stations.length; ++i) {
            if (!StationIdUtil.areEqual((StationId)p1, (StationId)this.stations[i].get_id())) continue;
            return this.channels[i];
        }
        return new Channel[0];
    }

    public AuditElement[] get_audit_trail() throws NotImplemented {
        return null;
    }

    public Calibration[] retrieve_calibrations(ChannelId p1, TimeRange p2) throws ChannelNotFound, NotImplemented {
        return null;
    }

    public AuditElement[] get_audit_trail_for_channel(ChannelId p1) throws ChannelNotFound, NotImplemented {
        return null;
    }

    public ChannelId[] retrieve_grouping(ChannelId p1) throws ChannelNotFound {
        return null;
    }

    public ChannelId[] retrieve_all_channels(int p1, ChannelIdIterHolder p2) {
        return null;
    }

    public TimeCorrection[] retrieve_time_corrections(ChannelId p1, TimeRange p2) throws ChannelNotFound, NotImplemented {
        return null;
    }

    public Channel[] locate_channels(Area p1, SamplingRange p2, OrientationRange p3) {
        return null;
    }

    public ChannelId[][] retrieve_groupings() {
        return null;
    }

    public NetworkAttr get_attributes() {
        return this.attributes;
    }
}

