/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.map.tools;

import com.bbn.openmap.proj.Proj;
import edu.sc.seis.fissuresUtil.map.OpenMap;
import edu.sc.seis.fissuresUtil.map.tools.OpenMapTool;
import java.awt.event.MouseEvent;

public class PanTool
extends OpenMapTool {
    private OpenMap openMap;
    private String id = "pan";
    private int[] startXYCoords;
    private int[] endXYCoords;
    private int[] centerXYCoords;

    public PanTool(OpenMap om) {
        this.openMap = om;
    }

    public String getID() {
        return this.id;
    }

    public void mousePressed(MouseEvent e) {
        if (this.isActive()) {
            super.mousePressed(e);
            this.startXYCoords = new int[]{e.getX(), e.getY()};
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.isActive()) {
            this.translate(e);
            this.startXYCoords = this.endXYCoords;
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.isActive()) {
            super.mouseReleased(e);
            this.translate(e);
        }
    }

    private void translate(MouseEvent e) {
        Proj proj = (Proj)this.openMap.getMapBean().getProjection();
        this.endXYCoords = new int[]{e.getX(), e.getY()};
        int[] diff = new int[]{this.endXYCoords[0] - this.startXYCoords[0], this.endXYCoords[1] - this.startXYCoords[1]};
        this.centerXYCoords = new int[]{proj.getWidth() / 2 - diff[0], proj.getHeight() / 2 - diff[1]};
        this.openMap.getMapBean().setCenter(proj.inverse(this.centerXYCoords[0], this.centerXYCoords[1]));
    }

    public String getPrettyName() {
        return "Pan";
    }
}

