/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.map.projections;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.Projection;
import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ProjectionHandler {
    private Projection proj;
    private static Map views = Collections.synchronizedMap(new HashMap());
    private static Properties viewProps = new Properties();
    private static final String VIEW_PROP_LOC = "edu/sc/seis/fissuresUtil/map/projections/view.props";
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$map$projections$ProjectionHandler;

    public ProjectionHandler(String view) {
        this(null, view);
    }

    public ProjectionHandler(Map customViews, String view) {
        if (customViews != null) {
            ProjectionHandler.addViews(customViews);
        }
        LatLonPoint center = new LatLonPoint(0.0f, 0.0f);
        float scale = Float.MAX_VALUE;
        this.proj = new Mercator(center, scale, 800, 550);
        if (!view.equals("World")) {
            LatLonPoint upperLeft = ProjectionHandler.getLatLonProp(view, "upperLeft");
            LatLonPoint lowerRight = ProjectionHandler.getLatLonProp(view, "lowerRight");
            Point upperLeftPix = new Point(0, 0);
            Point lowerRightPix = new Point(800, 550);
            scale = this.proj.getScale(upperLeft, lowerRight, upperLeftPix, lowerRightPix);
            this.proj = new Mercator(ProjectionHandler.getLatLonProp(view, "center"), scale, 800, 550);
        }
        views.put(view, this);
    }

    public static ProjectionHandler get(String viewName) {
        if (!views.containsKey(viewName)) {
            views.put(viewName, new ProjectionHandler(viewName));
        }
        return (ProjectionHandler)views.get(viewName);
    }

    public float[] inverse(int x, int y) {
        LatLonPoint llp = this.proj.inverse(x, y);
        return new float[]{llp.getLatitude(), llp.getLongitude()};
    }

    public static LatLonPoint getLatLonProp(String view, String type) {
        String viewType = view + '.' + type;
        double lat = Double.parseDouble(viewProps.getProperty(viewType + "Lat"));
        double lon = Double.parseDouble(viewProps.getProperty(viewType + "Lon"));
        return new LatLonPoint(lat, lon);
    }

    public static void addViews(Map newViews) {
        viewProps.putAll((Map<?, ?>)newViews);
    }

    public Projection getProjeciton() {
        return this.proj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ClassLoader cl = (class$edu$sc$seis$fissuresUtil$map$projections$ProjectionHandler == null ? (class$edu$sc$seis$fissuresUtil$map$projections$ProjectionHandler = ProjectionHandler.class$("edu.sc.seis.fissuresUtil.map.projections.ProjectionHandler")) : class$edu$sc$seis$fissuresUtil$map$projections$ProjectionHandler).getClassLoader();
        try {
            InputStream in = cl.getResourceAsStream(VIEW_PROP_LOC);
            if (in == null) {
                throw new IOException("Can't find edu/sc/seis/fissuresUtil/map/projections/view.props as resource");
            }
            viewProps.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to find edu/sc/seis/fissuresUtil/map/projections/view.props in jar", e);
        }
    }
}

