/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.map.layers;

import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.layer.etopo.ETOPOJarLayer;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import edu.sc.seis.fissuresUtil.map.layers.OverriddenOMLayer;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ColorMapEtopoLayer
extends ETOPOJarLayer
implements OverriddenOMLayer {
    private boolean overrideProjectionChanged = false;
    private int[] elevationLimit;
    private int[] redValues;
    private int[] greenValues;
    private int[] blueValues;
    private static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$map$layers$ColorMapEtopoLayer == null ? (class$edu$sc$seis$fissuresUtil$map$layers$ColorMapEtopoLayer = ColorMapEtopoLayer.class$("edu.sc.seis.fissuresUtil.map.layers.ColorMapEtopoLayer")) : class$edu$sc$seis$fissuresUtil$map$layers$ColorMapEtopoLayer));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$map$layers$ColorMapEtopoLayer;

    public ColorMapEtopoLayer() throws FileNotFoundException, IOException {
        this("edu/sc/seis/fissuresUtil/data/maps/ETOPOColorTable");
    }

    public ColorMapEtopoLayer(String colorMapFilename) throws FileNotFoundException, IOException {
        this.setName("ColorMap ETOPO Layer");
        this.setColorTable(colorMapFilename);
    }

    public void setOverrideProjectionChanged(boolean override) {
        this.overrideProjectionChanged = override;
    }

    public void projectionChanged(ProjectionEvent e) {
        if (this.overrideProjectionChanged) {
            this.doPrepare();
            this.repaint();
        } else {
            super.projectionChanged(e);
        }
    }

    public synchronized OMGraphicList prepare() {
        Projection projection = this.getProjection();
        if (projection == null) {
            return new OMGraphicList();
        }
        return super.prepare();
    }

    public void setColorTable(String colorMapFilename) throws FileNotFoundException, IOException {
        int[][] colorTable = ColorMapEtopoLayer.readInColorTable(colorMapFilename);
        this.elevationLimit = colorTable[0];
        this.redValues = colorTable[1];
        this.greenValues = colorTable[2];
        this.blueValues = colorTable[3];
        slopeColors = null;
    }

    protected Color getColor(short elevation, byte slopeVal) {
        if (slopeColors == null) {
            slopeColors = new Color[this.elevationLimit.length][8];
            for (int i = 0; i < this.elevationLimit.length; ++i) {
                Color base = new Color(this.redValues[i], this.greenValues[i], this.blueValues[i], this.opaqueness);
                for (int j = 4; j < 8; ++j) {
                    ColorMapEtopoLayer.slopeColors[i][j] = j == 4 ? base : slopeColors[i][j - 1].brighter();
                }
                for (int k = 3; k >= 0; --k) {
                    ColorMapEtopoLayer.slopeColors[i][k] = slopeColors[i][k + 1].darker();
                }
            }
        }
        int elIdx = this.getElevIndex(elevation);
        int slopeIdx = slopeVal + 127 >> 5;
        return slopeColors[elIdx][4];
    }

    protected int getElevIndex(short el) {
        for (int i = 0; i < this.elevationLimit.length - 1; ++i) {
            if (el >= this.elevationLimit[i + 1]) continue;
            return i;
        }
        return this.elevationLimit.length - 1;
    }

    private static int[][] readInColorTable(String filename) throws IOException, FileNotFoundException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream(filename)));
        }
        catch (Exception e) {
            logger.debug((Object)"reading from jar failed. checking to see if path is a valid non-jarred file");
            File cMapFile = new File(filename);
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(cMapFile)));
            logger.debug((Object)"it was indeed!");
        }
        ArrayList<String> colorRangeList = new ArrayList<String>();
        String line = null;
        while ((line = reader.readLine()) != null) {
            colorRangeList.add(line);
        }
        reader.close();
        int numValues = colorRangeList.size() + 1;
        int[] elevationLimit = new int[numValues];
        int[] redValues = new int[numValues];
        int[] greenValues = new int[numValues];
        int[] blueValues = new int[numValues];
        StringTokenizer tok = null;
        for (int i = 0; i <= colorRangeList.size(); ++i) {
            if (i < colorRangeList.size()) {
                String curLine = (String)colorRangeList.get(i);
                if (curLine.startsWith("#")) continue;
                tok = new StringTokenizer(curLine);
            }
            elevationLimit[i] = Integer.parseInt(tok.nextToken());
            redValues[i] = Integer.parseInt(tok.nextToken());
            greenValues[i] = Integer.parseInt(tok.nextToken());
            blueValues[i] = Integer.parseInt(tok.nextToken());
        }
        return new int[][]{elevationLimit, redValues, greenValues, blueValues};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

