/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.freq;

public class Cmplx {
    public double r;
    public double i;
    private static final double PI = Math.PI;
    private static final double TWOPI = Math.PI * 2;

    Cmplx() {
    }

    public Cmplx(double re, double im) {
        this.r = re;
        this.i = im;
    }

    public static final Cmplx add(double a, Cmplx b) {
        return Cmplx.add(new Cmplx(a, 0.0), b);
    }

    public static final Cmplx add(Cmplx a, double b) {
        return Cmplx.add(a, new Cmplx(b, 0.0));
    }

    public static final Cmplx add(Cmplx a, Cmplx b) {
        Cmplx c = new Cmplx();
        c.r = a.r + b.r;
        c.i = a.i + b.i;
        return c;
    }

    public static final Cmplx sub(double a, Cmplx b) {
        return Cmplx.sub(new Cmplx(a, 0.0), b);
    }

    public static final Cmplx sub(Cmplx a, double b) {
        return Cmplx.sub(a, new Cmplx(b, 0.0));
    }

    public static final Cmplx sub(Cmplx a, Cmplx b) {
        Cmplx c = new Cmplx();
        c.r = a.r - b.r;
        c.i = a.i - b.i;
        return c;
    }

    public static final Cmplx mul(double a, Cmplx b) {
        return Cmplx.mul(new Cmplx(a, 0.0), b);
    }

    public static final Cmplx mul(Cmplx a, double b) {
        return Cmplx.mul(a, new Cmplx(b, 0.0));
    }

    public static final Cmplx mul(Cmplx a, Cmplx b) {
        Cmplx c = new Cmplx();
        c.r = a.r * b.r - a.i * b.i;
        c.i = a.i * b.r + a.r * b.i;
        return c;
    }

    public static final Cmplx div(double a, Cmplx b) {
        return Cmplx.div(new Cmplx(a, 0.0), b);
    }

    public static final Cmplx div(Cmplx a, double b) {
        return Cmplx.div(a, new Cmplx(b, 0.0));
    }

    public static final Cmplx div(Cmplx a, Cmplx b) {
        Cmplx c = new Cmplx();
        if (Math.abs(b.r) >= Math.abs(b.i)) {
            double r = b.i / b.r;
            double den = b.r + r * b.i;
            c.r = (a.r + r * a.i) / den;
            c.i = (a.i - r * a.r) / den;
        } else {
            double r = b.r / b.i;
            double den = b.i + r * b.r;
            c.r = (a.r * r + a.i) / den;
            c.i = (a.i * r - a.r) / den;
        }
        return c;
    }

    public final double real() {
        double r = this.r;
        return r;
    }

    public final double imag() {
        double r = this.i;
        return r;
    }

    public final double mag() {
        return Math.sqrt(this.r * this.r + this.i * this.i);
    }

    public final double phs() {
        if (this.r == 0.0) {
            if (this.i == 0.0) {
                return 0.0;
            }
            return this.i / Math.abs(this.i) * 2.0 * Math.atan(1.0);
        }
        return Math.atan2(this.i, this.r);
    }

    public final Cmplx conjg() {
        Cmplx c = new Cmplx();
        c.r = this.r;
        c.i = -this.i;
        return c;
    }

    public static final Cmplx exp(Cmplx arg) {
        Cmplx c = new Cmplx();
        c.r = Math.exp(arg.r) * Math.cos(arg.i);
        c.i = Math.exp(arg.r) * Math.sin(arg.i);
        return c;
    }

    public final Cmplx sqrt() {
        double w;
        double y;
        Cmplx c = new Cmplx();
        if (this.r == 0.0 && this.i == 0.0) {
            c.i = 0.0;
            c.r = 0.0;
            return c;
        }
        double x = Math.abs(this.r);
        if (x >= (y = Math.abs(this.i))) {
            double r = y / x;
            w = Math.sqrt(x) * Math.sqrt(0.5 * (1.0 + Math.sqrt(1.0 + r * r)));
        } else {
            double r = x / y;
            w = Math.sqrt(y) * Math.sqrt(0.5 * (r + Math.sqrt(1.0 + r * r)));
        }
        if (this.r >= 0.0) {
            c.r = w;
            c.i = this.i / (2.0 * w);
        } else {
            c.i = this.i >= 0.0 ? w : -w;
            c.r = this.i / (2.0 * c.i);
        }
        return c;
    }

    public static final Cmplx[] fft(float[] fdata) {
        int i;
        int nPointsPow2;
        for (nPointsPow2 = 1; nPointsPow2 < fdata.length; nPointsPow2 *= 2) {
        }
        double[] data = new double[2 * nPointsPow2];
        int j = 0;
        for (i = 0; i < fdata.length; ++i) {
            data[j++] = fdata[i];
            data[j++] = 0.0;
        }
        while (j < 2 * nPointsPow2) {
            data[j] = 0.0;
            ++j;
        }
        data = Cmplx.four1(data, 1);
        Cmplx[] cdata = new Cmplx[nPointsPow2];
        i = 0;
        j = 0;
        while (i < nPointsPow2) {
            cdata[i] = new Cmplx(data[j], data[j + 1]);
            ++i;
            j += 2;
        }
        return cdata;
    }

    public static final float[] fftInverse(Cmplx[] cdata, int nPoints) {
        double[] data = new double[2 * cdata.length];
        int j = 0;
        for (int i = 0; i < cdata.length; ++i) {
            data[j++] = cdata[i].real();
            data[j++] = cdata[i].imag();
        }
        data = Cmplx.four1(data, -1);
        float[] fdata = new float[nPoints];
        int i = 0;
        int j2 = 0;
        while (i < nPoints) {
            fdata[i] = (float)data[j2];
            ++i;
            j2 += 2;
        }
        return fdata;
    }

    public static final float[] convolve(float[] fdata, float[] gdata, float delta) {
        if (fdata.length != gdata.length) {
            throw new IllegalArgumentException("fdata and gdata must have same length. " + fdata.length + " " + gdata.length);
        }
        Cmplx[] fTrans = Cmplx.fft(fdata);
        Cmplx[] gTrans = Cmplx.fft(gdata);
        for (int i = 0; i < fTrans.length; ++i) {
            fTrans[i] = Cmplx.mul(fTrans[i], gTrans[i]);
        }
        float[] ans = Cmplx.fftInverse(fTrans, fdata.length);
        int i = 0;
        while (i < ans.length) {
            int n = i++;
            ans[n] = ans[n] * delta;
        }
        return ans;
    }

    public static final float[] correlate(float[] fdata, float[] gdata) {
        if (fdata.length != gdata.length) {
            throw new IllegalArgumentException("fdata and gdata must have same length. " + fdata.length + " " + gdata.length);
        }
        Cmplx[] fTrans = Cmplx.fft(fdata);
        Cmplx[] gTrans = Cmplx.fft(gdata);
        for (int i = 0; i < fTrans.length; ++i) {
            fTrans[i] = Cmplx.mul(fTrans[i], gTrans[i].conjg());
        }
        return Cmplx.fftInverse(fTrans, fdata.length);
    }

    public static final double[] four1(double[] data, int isign) {
        int m;
        int i;
        int nn = data.length / 2;
        int n = nn << 1;
        int j = 0;
        for (i = 0; i < n; i += 2) {
            if (j > i) {
                double temp = data[j];
                data[j] = data[i];
                data[i] = temp;
                temp = data[j + 1];
                data[j + 1] = data[i + 1];
                data[i + 1] = temp;
            }
            for (m = n >> 1; m >= 2 && j > m - 1; j -= m, m >>= 1) {
            }
            j += m;
        }
        int mmax = 2;
        while (n > mmax) {
            int istep = 2 * mmax;
            double theta = Math.PI * 2 / (double)(isign * mmax);
            double wtemp = Math.sin(0.5 * theta);
            double wpr = -2.0 * wtemp * wtemp;
            double wpi = Math.sin(theta);
            double wr = 1.0;
            double wi = 0.0;
            for (m = 0; m < mmax; m += 2) {
                for (i = m; i < n; i += istep) {
                    j = i + mmax;
                    double tempr = wr * data[j] - wi * data[j + 1];
                    double tempi = wr * data[j + 1] + wi * data[j];
                    data[j] = data[i] - tempr;
                    data[j + 1] = data[i + 1] - tempi;
                    int n2 = i;
                    data[n2] = data[n2] + tempr;
                    int n3 = i + 1;
                    data[n3] = data[n3] + tempi;
                }
                wtemp = wr;
                wr = wtemp * wpr - wi * wpi + wr;
                wi = wi * wpr + wtemp * wpi + wi;
            }
            mmax = istep;
        }
        if (isign == -1) {
            for (m = 0; m < 2 * nn; m += 2) {
                int n4 = m;
                data[n4] = data[n4] / (double)nn;
            }
        }
        return data;
    }

    public String toString() {
        if (this.i >= 0.0) {
            return this.r + " + i " + this.i;
        }
        return this.r + " - i " + -1.0 * this.i;
    }
}

