/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.registrar;

import edu.iris.Fissures.model.TimeInterval;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.display.registrar.EmptyTimeEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeListener;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Category;

public class BasicTimeConfig
implements TimeConfig {
    private Set listeners = new HashSet();
    protected Map seismoTimes = new HashMap();
    protected DataSetSeismogram[] seismograms;
    protected double shift;
    protected double scale = 1.0;
    protected MicroSecondTimeRange time;
    protected MicroSecondTimeRange initialTime;
    private static Category logger = Category.getInstance((String)(class$edu$sc$seis$fissuresUtil$display$registrar$BasicTimeConfig == null ? (class$edu$sc$seis$fissuresUtil$display$registrar$BasicTimeConfig = BasicTimeConfig.class$("edu.sc.seis.fissuresUtil.display.registrar.BasicTimeConfig")) : class$edu$sc$seis$fissuresUtil$display$registrar$BasicTimeConfig).getName());
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$display$registrar$BasicTimeConfig;

    public BasicTimeConfig() {
    }

    public BasicTimeConfig(DataSetSeismogram[] seismos) {
        this.add(seismos);
    }

    public void add(DataSetSeismogram[] seismos) {
        for (int i = 0; i < seismos.length; ++i) {
            MicroSecondTimeRange seisTime;
            if (this.contains(seismos[i]) || (seisTime = this.getInitialTime(seismos[i])) == null) continue;
            if (this.time == null) {
                this.initialTime = this.time = seisTime;
            }
            this.seismoTimes.put(seismos[i], this.getInitialTime(seismos[i]));
        }
        this.seismograms = null;
        this.fireTimeEvent();
    }

    protected MicroSecondTimeRange getInitialTime(DataSetSeismogram seis) {
        if (this.time == null && seis != null) {
            this.initialTime = this.time = new MicroSecondTimeRange(seis.getRequestFilter());
        }
        return this.time;
    }

    public void remove(DataSetSeismogram[] seismos) {
        boolean someRemoved = false;
        for (int i = 0; i < seismos.length; ++i) {
            if (this.seismoTimes.remove(seismos[i]) == null) continue;
            someRemoved = true;
        }
        if (someRemoved) {
            this.seismograms = null;
            if (this.seismoTimes.size() == 0) {
                this.time = null;
                return;
            }
            this.fireTimeEvent();
        }
    }

    public void clear() {
        this.remove(this.getSeismograms());
    }

    public boolean contains(DataSetSeismogram seismo) {
        return this.seismoTimes.containsKey(seismo);
    }

    public DataSetSeismogram[] getSeismograms() {
        if (this.seismograms == null) {
            this.seismograms = this.seismoTimes.keySet().toArray(new DataSetSeismogram[this.seismoTimes.size()]);
        }
        return this.seismograms;
    }

    public void reset() {
        this.time = null;
        this.shift = 0.0;
        this.scale = 1.0;
        this.reset(this.getSeismograms());
    }

    public void reset(DataSetSeismogram[] seismos) {
        this.remove(seismos);
        this.add(seismos);
    }

    public void shaleTime(double shift, double scale) {
        this.shaleTime(shift, scale, this.getSeismograms());
    }

    public void shaleTime(double shift, double scale, DataSetSeismogram[] seismos) {
        this.shift += shift * this.scale;
        this.scale *= scale;
        if (this.time != null) {
            this.time = this.time.shale(shift, scale);
            for (int i = 0; i < seismos.length; ++i) {
                MicroSecondTimeRange seisTime = (MicroSecondTimeRange)this.seismoTimes.get(seismos[i]);
                this.seismoTimes.put(seismos[i], seisTime.shale(shift, scale));
            }
            this.fireTimeEvent();
        }
    }

    public double getShift() {
        return this.shift;
    }

    public double getScale() {
        return this.scale;
    }

    public TimeEvent fireTimeEvent() {
        if (this.seismoTimes.size() == 0 && this.time != null) {
            return this.fireTimeEvent(new EmptyTimeEvent(this.time));
        }
        DataSetSeismogram[] seismos = this.getSeismograms();
        MicroSecondTimeRange[] times = new MicroSecondTimeRange[seismos.length];
        for (int i = 0; i < seismos.length; ++i) {
            times[i] = (MicroSecondTimeRange)this.seismoTimes.get(seismos[i]);
        }
        return this.fireTimeEvent(new TimeEvent(seismos, times, this.time));
    }

    protected TimeEvent fireTimeEvent(TimeEvent event) {
        Iterator f = this.listeners.iterator();
        while (f.hasNext()) {
            ((TimeListener)f.next()).updateTime(event);
        }
        return event;
    }

    public MicroSecondTimeRange getTime() {
        if (this.time != null) {
            return this.time;
        }
        return DisplayUtils.ZERO_TIME;
    }

    public MicroSecondTimeRange getTime(DataSetSeismogram seis) {
        return (MicroSecondTimeRange)this.seismoTimes.get(seis);
    }

    public void addListener(TimeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
            this.fireTimeEvent();
        }
    }

    public void removeListener(TimeListener listener) {
        this.listeners.remove(listener);
    }

    protected TimeInterval getInterval(DataSetSeismogram seismo) {
        return new MicroSecondTimeRange(seismo.getRequestFilter()).getInterval();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

