/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.registrar;

import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.display.SeismogramIterator;
import edu.sc.seis.fissuresUtil.display.UnitDisplayUtil;
import edu.sc.seis.fissuresUtil.display.registrar.AmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.AmpConfigData;
import edu.sc.seis.fissuresUtil.display.registrar.AmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.AmpListener;
import edu.sc.seis.fissuresUtil.display.registrar.BasicAmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.LazyAmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeEvent;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.log4j.Category;

public class BasicAmpConfig
implements AmpConfig {
    private static int j = 0;
    private int i = j++;
    private Set listeners = Collections.synchronizedSet(new HashSet());
    private List ampData = Collections.synchronizedList(new ArrayList());
    private AmpConfigData[] dataArray;
    private AmpListener[] ampListeners;
    private DataSetSeismogram[] seisArray;
    private TimeEvent currentTimeEvent;
    private AmpEvent ampEvent = new LazyAmpEvent(this);
    private static Category logger = Category.getInstance((String)(class$edu$sc$seis$fissuresUtil$display$registrar$BasicAmpConfig == null ? (class$edu$sc$seis$fissuresUtil$display$registrar$BasicAmpConfig = BasicAmpConfig.class$("edu.sc.seis.fissuresUtil.display.registrar.BasicAmpConfig")) : class$edu$sc$seis$fissuresUtil$display$registrar$BasicAmpConfig).getName());
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$display$registrar$BasicAmpConfig;

    public BasicAmpConfig() {
    }

    public BasicAmpConfig(DataSetSeismogram[] seismos) {
        this.add(seismos);
    }

    public String toString() {
        return "Amp Config " + this.i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(DataSetSeismogram[] seismos) {
        boolean someAdded = false;
        List list = this.ampData;
        synchronized (list) {
            for (int i = 0; i < seismos.length; ++i) {
                if (this.contains(seismos[i])) continue;
                this.ampData.add(new AmpConfigData(seismos[i], this));
                someAdded = true;
            }
            if (someAdded) {
                this.dataArray = null;
                this.ampEvent = new LazyAmpEvent(this);
                this.seisArray = null;
            }
        }
        if (someAdded) {
            this.fireAmpEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DataSetSeismogram[] seismos) {
        boolean someRemoved = false;
        List list = this.ampData;
        synchronized (list) {
            for (int i = 0; i < seismos.length; ++i) {
                ListIterator lit = this.ampData.listIterator();
                while (lit.hasNext()) {
                    if (!((AmpConfigData)lit.next()).getDSS().equals(seismos[i])) continue;
                    lit.remove();
                    someRemoved = true;
                }
            }
            if (someRemoved) {
                this.dataArray = null;
                this.ampEvent = new LazyAmpEvent(this);
                this.seisArray = null;
            }
        }
        if (someRemoved) {
            this.fireAmpEvent();
        }
    }

    public void clear() {
        this.remove(this.getSeismograms());
    }

    public DataSetSeismogram[] getSeismograms() {
        return this.getSeismograms(this.getAmpData());
    }

    public DataSetSeismogram[] getSeismograms(AmpConfigData[] ampData) {
        if (this.seisArray == null) {
            this.seisArray = AmpConfigData.getSeismograms(ampData);
        }
        return this.seisArray;
    }

    public UnitRangeImpl getAmp() {
        return this.ampEvent.getAmp();
    }

    public UnitRangeImpl getAmp(DataSetSeismogram seis) {
        return this.ampEvent.getAmp(seis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmpConfigData[] getAmpData() {
        List list = this.ampData;
        synchronized (list) {
            if (this.dataArray == null) {
                this.dataArray = new AmpConfigData[this.ampData.size()];
                Iterator it = this.ampData.iterator();
                int i = 0;
                while (it.hasNext()) {
                    this.dataArray[i] = (AmpConfigData)it.next();
                    ++i;
                }
            }
            return this.dataArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmpConfigData getAmpData(DataSetSeismogram seis) {
        List list = this.ampData;
        synchronized (list) {
            Iterator it = this.ampData.iterator();
            while (it.hasNext()) {
                AmpConfigData current = (AmpConfigData)it.next();
                if (!current.getDSS().equals(seis)) continue;
                return current;
            }
        }
        return null;
    }

    public boolean contains(DataSetSeismogram seismo) {
        return this.getAmpData(seismo) != null;
    }

    public void reset() {
        this.reset(this.getSeismograms());
    }

    public void reset(DataSetSeismogram[] seismos) {
        boolean someReset = false;
        for (int i = 0; i < seismos.length; ++i) {
            if (!this.contains(seismos[i])) continue;
            this.getAmpData(seismos[i]).reset();
            someReset = true;
        }
        if (someReset) {
            this.fireAmpEvent();
        }
    }

    public void shaleAmp(double shift, double scale) {
        this.shaleAmp(shift, scale, this.getSeismograms());
    }

    public void shaleAmp(double shift, double scale, DataSetSeismogram[] seismos) {
        for (int i = 0; i < seismos.length; ++i) {
            this.getAmpData(seismos[i]).shale(shift, scale);
        }
        this.fireAmpEvent();
    }

    public void fireAmpEvent() {
        this.fireAmpEvent(new LazyAmpEvent(this));
    }

    private void fireAmpEvent(AmpEvent event) {
        AmpListener[] al = this.getAmpListeners();
        for (int i = 0; i < al.length; ++i) {
            al[i].updateAmp(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AmpListener listener) {
        if (listener != null) {
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.add(listener);
                this.ampListeners = null;
            }
            this.fireAmpEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(AmpListener listener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
            this.ampListeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AmpListener[] getAmpListeners() {
        Set set = this.listeners;
        synchronized (set) {
            if (this.ampListeners == null) {
                this.ampListeners = new AmpListener[this.listeners.size()];
                this.listeners.toArray(this.ampListeners);
            }
        }
        return this.ampListeners;
    }

    public void updateTime(TimeEvent timeEvent) {
        this.currentTimeEvent = timeEvent;
        this.ampEvent = new LazyAmpEvent(this);
        this.fireAmpEvent(this.ampEvent);
    }

    public AmpEvent calculate() {
        boolean changed = false;
        AmpConfigData[] ad = this.getAmpData();
        for (int i = 0; i < ad.length; ++i) {
            if (ad[i] != null && ad[i].setTime(this.getTime(ad[i].getDSS()))) {
                if (!this.setAmpRange(ad[i])) continue;
                changed = true;
                continue;
            }
            if (ad[i] == null || !ad[i].hasNewData()) continue;
            this.setAmpRange(ad[i]);
            changed = true;
        }
        if (changed || this.ampEvent instanceof LazyAmpEvent) {
            this.ampEvent = this.recalculate();
        }
        return this.ampEvent;
    }

    public AmpEvent recalculate() {
        AmpConfigData[] ad = this.getAmpData();
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < ad.length; ++i) {
            UnitRangeImpl current = ad[i].getRange();
            if (current == null) continue;
            if (current.getMaxValue() > max) {
                max = current.getMaxValue();
            }
            if (!(current.getMinValue() < min)) continue;
            min = current.getMinValue();
        }
        UnitRangeImpl fullRange = new UnitRangeImpl(min, max, (Unit)UnitImpl.COUNT);
        UnitRangeImpl[] amps = new UnitRangeImpl[ad.length];
        for (int i = 0; i < ad.length; ++i) {
            amps[i] = fullRange;
        }
        UnitRangeImpl genericRange = DisplayUtils.ONE_RANGE;
        if (ad.length == 1) {
            genericRange = UnitDisplayUtil.getRealWorldUnitRange(fullRange, ad[0].getDSS());
        }
        return new BasicAmpEvent(this.getSeismograms(ad), amps, genericRange);
    }

    protected boolean setAmpRange(AmpConfigData data) {
        SeismogramIterator it = data.getIterator();
        if (!it.hasNext()) {
            return data.setRange(DisplayUtils.ONE_RANGE);
        }
        double[] minMaxMean = it.minMaxMean();
        return data.setRange(UnitDisplayUtil.getBestForDisplay(new UnitRangeImpl(minMaxMean[0], minMaxMean[1], (Unit)it.getUnit())));
    }

    private MicroSecondTimeRange getTime(DataSetSeismogram seismo) {
        if (this.currentTimeEvent != null) {
            return this.currentTimeEvent.getTime(seismo);
        }
        return new MicroSecondTimeRange(seismo.getRequestFilter());
    }

    private void checkSeismogramUnits(AmpConfigData data) {
        LocalSeismogramImpl[] seismograms = data.getIterator().getSeismograms();
        UnitImpl seisUnit = null;
        for (int i = 0; i < seismograms.length; ++i) {
            LocalSeismogramImpl seis = seismograms[i];
            if (seisUnit == null) {
                seisUnit = seis.getUnit();
            }
            if (seis.getUnit().equals((Object)seisUnit)) continue;
            throw new IllegalArgumentException("Seismograms in the same DataSetSeismogram do not have the same units!");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

