/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.drawable;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.fissuresUtil.display.PlottableDisplay;
import edu.sc.seis.fissuresUtil.display.drawable.EventFlag;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EventBoxes
extends EventFlag {
    public EventBoxes(PlottableDisplay plottableDisplay, EventAccessOperations eventAccess, Arrival[] arrivals) {
        super(plottableDisplay, eventAccess, arrivals);
    }

    public void draw(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setStroke(new BasicStroke(3.0f));
        g2.setPaint(this.getColor());
        List boxes = this.getBoxes();
        Iterator it = boxes.iterator();
        while (it.hasNext()) {
            g2.draw((Rectangle)it.next());
        }
    }

    public List getBoxes() {
        ArrayList<Rectangle> boxes = new ArrayList<Rectangle>();
        int originX = this.getOriginX();
        int originY = this.getOriginY();
        Arrival kmpsArrival = this.get4kmpsArrival();
        int lastX = this.getX(kmpsArrival);
        int lastY = this.getY(kmpsArrival);
        if (kmpsArrival.getTime() < 300.0) {
            MicroSecondDate arrivalTime = this.getOriginTime().add(new TimeInterval(5.0, UnitImpl.MINUTE));
            lastX = this.getX(arrivalTime);
            lastY = this.getY(this.getRow(arrivalTime));
        }
        if (originY == lastY) {
            boxes.add(this.makeRect(originX, lastX, originY));
        } else {
            int rowRightEdge = 50 + this.getDisplay().getRowWidth();
            boxes.add(this.makeRect(originX, rowRightEdge, originY));
            originY += this.getDisplay().getRowOffset();
            while (originY != lastY) {
                boxes.add(this.makeRect(50, rowRightEdge, originY));
                originY += this.getDisplay().getRowOffset();
            }
            if (lastX != 50) {
                boxes.add(this.makeRect(50, lastX, originY));
            }
        }
        return boxes;
    }

    private Arrival get4kmpsArrival() {
        Arrival kmpsArrival = null;
        for (int i = 0; i < this.arrivals.length; ++i) {
            if (!this.arrivals[i].getName().equals("3kmps")) continue;
            if (kmpsArrival == null) {
                kmpsArrival = this.arrivals[i];
                continue;
            }
            if (!(kmpsArrival.getDist() > this.arrivals[i].getDist())) continue;
            kmpsArrival = this.arrivals[i];
        }
        if (kmpsArrival == null) {
            throw new IllegalStateException("To use Event boxes, a 3kmps arrival must be included with the arrivals passed into PlottableDisplay");
        }
        return kmpsArrival;
    }

    private Rectangle makeRect(int leftX, int rightX, int centerY) {
        int halfOffset = this.getDisplay().getRowOffset() / 2;
        return new Rectangle(leftX, centerY - halfOffset, rightX - leftX, this.getDisplay().getRowOffset());
    }
}

