/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.drawable;

import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.NamedColor;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplayListener;
import edu.sc.seis.fissuresUtil.display.drawable.Drawable;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableIterator;
import edu.sc.seis.fissuresUtil.display.drawable.Event;
import edu.sc.seis.fissuresUtil.display.drawable.NamedDrawable;
import edu.sc.seis.fissuresUtil.display.drawable.SeismogramRemover;
import edu.sc.seis.fissuresUtil.display.drawable.SeismogramShape;
import edu.sc.seis.fissuresUtil.display.registrar.AmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.AmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeEvent;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DrawableSeismogram
implements NamedDrawable,
SeismogramDisplayListener {
    private boolean firstPaint = true;
    private SeismogramDisplay parent;
    private List children = Collections.synchronizedList(new ArrayList());
    private Color color;
    private String name;
    protected SeismogramShape shape;
    private static boolean defaultVisibility = true;
    private boolean visible;
    private SeismogramRemover remover;
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$display$drawable$DrawableSeismogram;

    public DrawableSeismogram(SeismogramDisplay parent, DataSetSeismogram seis, Color color) {
        this(parent, new SeismogramShape(parent, seis), seis.getName(), color);
    }

    public DrawableSeismogram(SeismogramDisplay parent, DataSetSeismogram seis, String name) {
        this(parent, new SeismogramShape(parent, seis), name, null);
    }

    protected DrawableSeismogram(SeismogramDisplay parent, SeismogramShape shape) {
        this(parent, shape, shape.getSeismogram().getName(), null);
    }

    protected DrawableSeismogram(SeismogramDisplay parent, SeismogramShape shape, String name, Color color) {
        this.parent = parent;
        this.color = color != null ? color : parent.getNextColor(class$edu$sc$seis$fissuresUtil$display$drawable$DrawableSeismogram == null ? (class$edu$sc$seis$fissuresUtil$display$drawable$DrawableSeismogram = DrawableSeismogram.class$("edu.sc.seis.fissuresUtil.display.drawable.DrawableSeismogram")) : class$edu$sc$seis$fissuresUtil$display$drawable$DrawableSeismogram);
        this.name = name;
        if (color instanceof NamedColor) {
            this.name = this.name + "." + color;
            this.color = ((NamedColor)color).getColor();
        }
        this.shape = shape;
        this.setRemover(new SeismogramRemover(shape.getSeismogram(), parent));
        this.setVisibility(defaultVisibility);
        parent.add(this);
    }

    protected void setRemover(SeismogramRemover remover) {
        this.remover = remover;
    }

    public SeismogramDisplay getParent() {
        return this.parent;
    }

    public void setVisibility(boolean vis) {
        DataSetSeismogram[] seis = new DataSetSeismogram[]{this.getSeismogram()};
        if (vis) {
            this.parent.getTimeConfig().add(seis);
            this.parent.getAmpConfig().add(seis);
        } else {
            this.parent.getTimeConfig().remove(seis);
            this.parent.getAmpConfig().remove(seis);
        }
        if (this.visible != vis) {
            this.parent.repaint();
        }
        this.visible = vis;
    }

    public boolean getVisiblity() {
        return this.visible;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public void addToTimeAndAmp() {
        DataSetSeismogram[] seis = new DataSetSeismogram[]{this.getSeismogram()};
        this.parent.getTimeConfig().add(seis);
        this.parent.getAmpConfig().add(seis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D canvas, Dimension size, TimeEvent currentTime, AmpEvent currentAmp) {
        if (this.visible && size.width > 0 && size.height > 0) {
            DataSetSeismogram[] seis;
            if (!currentTime.contains(this.getSeismogram())) {
                seis = new DataSetSeismogram[]{this.getSeismogram()};
                this.parent.getTimeConfig().add(seis);
            } else if (!currentAmp.contains(this.getSeismogram())) {
                seis = new DataSetSeismogram[]{this.getSeismogram()};
                this.parent.getAmpConfig().add(seis);
            } else if (this.shape.update(currentTime.getTime(this.getSeismogram()), currentAmp.getAmp(this.getSeismogram()), size)) {
                canvas.setPaint(this.color);
                canvas.setStroke(DisplayUtils.ONE_PIXEL_STROKE);
                canvas.draw(this.shape);
                if (this.firstPaint) {
                    this.parent.repaint();
                    this.firstPaint = false;
                }
            }
        }
        List list = this.children;
        synchronized (list) {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                Drawable cur = (Drawable)it.next();
                cur.draw(canvas, size, currentTime, currentAmp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle2D drawName(Graphics2D canvas, int xPosition, int yPosition) {
        this.remover.draw(canvas, xPosition, yPosition - 7);
        String name = this.getName() + " " + this.shape.getDataStatus();
        FontMetrics fm = canvas.getFontMetrics();
        Rectangle2D stringBounds = fm.getStringBounds(name, canvas);
        stringBounds.setRect(stringBounds.getX() + (double)(xPosition += 10), stringBounds.getY() + (double)yPosition, stringBounds.getWidth(), stringBounds.getHeight());
        canvas.setColor(this.color);
        canvas.setFont(DisplayUtils.DEFAULT_FONT);
        if (!this.visible) {
            canvas.setPaint(Color.GRAY);
        }
        if (this.remover.getDrawColor() == Color.RED) {
            canvas.setFont(DisplayUtils.BOLD_FONT);
            canvas.setColor(Color.RED);
        }
        canvas.drawString(name, xPosition, yPosition);
        canvas.setFont(DisplayUtils.DEFAULT_FONT);
        List list = this.children;
        synchronized (list) {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                Drawable cur = (Drawable)it.next();
                if (!(cur instanceof NamedDrawable)) continue;
                stringBounds.add(((NamedDrawable)cur).drawName(canvas, (int)((double)xPosition + stringBounds.getWidth()), yPosition));
            }
        }
        return stringBounds;
    }

    public void add(Drawable child) {
        if (child instanceof Event) {
            ((Event)child).setColor(this.color);
        }
        this.children.add(child);
        this.parent.repaint();
    }

    public void add(Drawable child, Color color) {
        this.add(child);
        if (child instanceof Event) {
            ((Event)child).setColor(color);
        }
    }

    public void remove(Drawable child) {
        if (this.children.remove(child)) {
            this.parent.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(Class drawableClass) {
        List list = this.children;
        synchronized (list) {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                if (!drawableClass.isInstance(it.next())) continue;
                it.remove();
            }
        }
        this.parent.repaint();
    }

    public DrawableIterator iterator(Class drawableClass) {
        return new DrawableIterator(drawableClass, this.children);
    }

    public void added(SeismogramDisplay recipient, Drawable drawable) {
    }

    public void removed(SeismogramDisplay bereaved, Drawable drawable) {
    }

    public void switching(SeismogramDisplay from, SeismogramDisplay to) {
        this.parent = to;
        this.setVisibility(this.visible);
    }

    public void switching(AmpConfig from, AmpConfig to) {
    }

    public void switching(TimeConfig from, TimeConfig to) {
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public DataSetSeismogram getSeismogram() {
        return this.shape.getSeismogram();
    }

    public String getDataStatus() {
        return this.shape.getDataStatus();
    }

    public void getData() {
        this.shape.getData();
    }

    public static void setDefaultVisibility(boolean visible) {
        defaultVisibility = visible;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

