/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.IfNetwork.Response;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.StdAuxillaryDataNames;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.log4j.Logger;

public class UnitDisplayUtil {
    public static final String mu = "\u03bc";
    static final DecimalFormat quantityFormat = new DecimalFormat("#,###,##0.0##; -#,###,##0.0##");
    static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$display$UnitDisplayUtil == null ? (class$edu$sc$seis$fissuresUtil$display$UnitDisplayUtil = UnitDisplayUtil.class$("edu.sc.seis.fissuresUtil.display.UnitDisplayUtil")) : class$edu$sc$seis$fissuresUtil$display$UnitDisplayUtil));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$display$UnitDisplayUtil;

    public static QuantityImpl getBestForDisplay(QuantityImpl quantity) {
        UnitRangeImpl inRange = new UnitRangeImpl(quantity.getValue(), quantity.getValue(), (Unit)quantity.getUnit());
        inRange = UnitDisplayUtil.getBestForDisplay(inRange);
        return new QuantityImpl(inRange.getMinValue(), (Unit)inRange.getUnit());
    }

    public static UnitRangeImpl getBestForDisplay(UnitRangeImpl inRange) {
        UnitRangeImpl outRange = inRange;
        if (inRange.getUnit().isConvertableTo(UnitImpl.METER_PER_SECOND)) {
            if (Math.abs((inRange = inRange.convertTo(UnitImpl.METER_PER_SECOND)).getMinValue()) < 1.0E-6 && Math.abs(inRange.getMaxValue()) < 1.0E-6) {
                outRange = inRange.convertTo(UnitImpl.NANOMETER_PER_SECOND);
            } else if (Math.abs(inRange.getMinValue()) < 0.001 && Math.abs(inRange.getMaxValue()) < 0.001) {
                outRange = inRange.convertTo(UnitImpl.MICRON_PER_SECOND);
            } else if (Math.abs(inRange.getMinValue()) < 1.0 && Math.abs(inRange.getMaxValue()) < 1.0) {
                outRange = inRange.convertTo(UnitImpl.MILLIMETER_PER_SECOND);
            }
        } else if (inRange.getUnit().isConvertableTo(UnitImpl.METER)) {
            if (Math.abs((inRange = inRange.convertTo(UnitImpl.METER)).getMinValue()) < 1.0E-6 && Math.abs(inRange.getMaxValue()) < 1.0E-6) {
                outRange = inRange.convertTo(UnitImpl.NANOMETER);
            } else if (Math.abs(inRange.getMinValue()) < 0.001 && Math.abs(inRange.getMaxValue()) < 0.001) {
                outRange = inRange.convertTo(UnitImpl.MICRON);
            } else if (Math.abs(inRange.getMinValue()) < 1.0 && Math.abs(inRange.getMaxValue()) < 1.0) {
                outRange = inRange.convertTo(UnitImpl.MILLIMETER);
            }
        } else if (inRange.getUnit().isConvertableTo(UnitImpl.METER_PER_SECOND_PER_SECOND)) {
            if (Math.abs((inRange = inRange.convertTo(UnitImpl.METER_PER_SECOND_PER_SECOND)).getMinValue()) < 1.0E-6 && Math.abs(inRange.getMaxValue()) < 1.0E-6) {
                outRange = inRange.convertTo(UnitImpl.NANOMETER_PER_SECOND_PER_SECOND);
            } else if (Math.abs(inRange.getMinValue()) < 0.001 && Math.abs(inRange.getMaxValue()) < 0.001) {
                outRange = inRange.convertTo(UnitImpl.MICROMETER_PER_SECOND_PER_SECOND);
            } else if (Math.abs(inRange.getMinValue()) < 1.0 && Math.abs(inRange.getMaxValue()) < 1.0) {
                outRange = inRange.convertTo(UnitImpl.MILLIMETER_PER_SECOND_PER_SECOND);
            }
        } else if (inRange.getUnit().isConvertableTo(UnitImpl.COUNT)) {
            outRange = Math.abs((inRange = inRange.convertTo(UnitImpl.COUNT)).getMinValue()) < 0.001 && Math.abs(inRange.getMaxValue()) < 0.001 ? inRange.convertTo(UnitImpl.MICROCOUNT) : (Math.abs(inRange.getMinValue()) < 1.0 && Math.abs(inRange.getMaxValue()) < 1.0 ? inRange.convertTo(UnitImpl.MILLICOUNT) : (Math.abs(inRange.getMinValue()) < 1000.0 && Math.abs(inRange.getMaxValue()) < 1000.0 ? inRange.convertTo(UnitImpl.COUNT) : (Math.abs(inRange.getMinValue()) < 1000000.0 && Math.abs(inRange.getMaxValue()) < 1000000.0 ? inRange.convertTo(UnitImpl.KILOCOUNT) : inRange.convertTo(UnitImpl.MEGACOUNT))));
        }
        return outRange;
    }

    public static UnitRangeImpl getRealWorldUnitRange(UnitRangeImpl ur, DataSetSeismogram seismo) {
        Object responseObj;
        UnitRangeImpl out = ur;
        if (ur.getUnit().isConvertableTo(UnitImpl.COUNT) && (responseObj = seismo.getAuxillaryData(StdAuxillaryDataNames.RESPONSE)) != null && responseObj instanceof Response) {
            Response response = (Response)responseObj;
            UnitImpl realWorldUnit = (UnitImpl)response.stages[0].input_units;
            float sensitivity = response.the_sensitivity.sensitivity_factor;
            if (sensitivity > 0.0f) {
                out = new UnitRangeImpl(ur.getMinValue() / (double)sensitivity, ur.getMaxValue() / (double)sensitivity, (Unit)realWorldUnit);
            } else {
                out = new UnitRangeImpl(ur.getMaxValue() / (double)sensitivity, ur.getMinValue() / (double)sensitivity, (Unit)realWorldUnit);
                seismo.addAuxillaryData("sensitivity", response.the_sensitivity);
            }
        }
        return UnitDisplayUtil.getBestForDisplay(out);
    }

    public static String getNameForUnit(UnitImpl unit) {
        if (unit.equals((Object)UnitImpl.METER_PER_SECOND)) {
            return "m/s";
        }
        if (unit.equals((Object)UnitImpl.MICRON_PER_SECOND)) {
            return "microns/sec";
        }
        if (unit.equals((Object)UnitImpl.MILLIMETER_PER_SECOND)) {
            return "mm/s";
        }
        if (unit.equals((Object)UnitImpl.NANOMETER_PER_SECOND)) {
            return "nm/s";
        }
        if (unit.equals((Object)UnitImpl.KILOMETER_PER_SECOND)) {
            return "km/s";
        }
        if (unit.equals((Object)UnitImpl.KILOMETER)) {
            return "km";
        }
        if (unit.equals((Object)UnitImpl.METER)) {
            return "m";
        }
        if (unit.equals((Object)UnitImpl.MILLIMETER)) {
            return "mm";
        }
        if (unit.equals((Object)UnitImpl.MICROMETER)) {
            return "micrometers";
        }
        if (unit.equals((Object)UnitImpl.NANOMETER)) {
            return "nanometers";
        }
        if (unit.equals((Object)UnitImpl.METER_PER_SECOND_PER_SECOND)) {
            return "m/s/s";
        }
        if (unit.equals((Object)UnitImpl.MILLIMETER_PER_SECOND_PER_SECOND)) {
            return "mm/s/s";
        }
        if (unit.equals((Object)UnitImpl.MICROMETER_PER_SECOND_PER_SECOND)) {
            return "microns/s/s";
        }
        if (unit.equals((Object)UnitImpl.NANOMETER_PER_SECOND_PER_SECOND)) {
            return "nm/s/s";
        }
        if (unit.equals((Object)UnitImpl.SECOND)) {
            return "s";
        }
        if (unit.equals((Object)UnitImpl.DEGREE)) {
            return "deg";
        }
        if (unit.equals((Object)UnitImpl.COUNT)) {
            return "COUNTS";
        }
        if (unit.equals((Object)UnitImpl.MILLICOUNT)) {
            return "COUNTS x 10^-3";
        }
        if (unit.equals((Object)UnitImpl.MICROCOUNT)) {
            return "COUNTS x 10^-6";
        }
        if (unit.equals((Object)UnitImpl.KILOCOUNT)) {
            return "COUNTS x 10^3";
        }
        if (unit.equals((Object)UnitImpl.MEGACOUNT)) {
            return "COUNTS x 10^6";
        }
        return unit.toString();
    }

    public static String formatQuantityImpl(Quantity quantity) {
        return UnitDisplayUtil.formatQuantityImpl(quantity, quantityFormat);
    }

    public static String formatQuantityImpl(Quantity quantity, NumberFormat format) {
        if (quantity != null) {
            return format.format(quantity.value) + " " + UnitDisplayUtil.getNameForUnit((UnitImpl)quantity.the_units).toLowerCase();
        }
        return "...";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

