/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.fissuresUtil.display.AbstractSeismogramContainer;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.display.SeismogramContainerListener;
import edu.sc.seis.fissuresUtil.display.SeismogramIterator;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.time.CoverageTool;
import edu.sc.seis.fissuresUtil.time.RangeTool;
import edu.sc.seis.fissuresUtil.xml.DCDataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.MemoryDataSetSeismogram;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SoftRefSeismogramContainer
extends AbstractSeismogramContainer {
    private List softSeis = Collections.synchronizedList(new ArrayList());
    private Map threadToIterator = Collections.synchronizedMap(new HashMap());
    private static final LocalSeismogramImpl[] EMPTY_ARRAY = new LocalSeismogramImpl[0];
    private MicroSecondTimeRange time;

    public SoftRefSeismogramContainer(DataSetSeismogram seismogram) {
        this(null, seismogram);
    }

    public SoftRefSeismogramContainer(SeismogramContainerListener initialListener, DataSetSeismogram seismogram) {
        super(initialListener, seismogram);
    }

    public SeismogramIterator getIterator() {
        MicroSecondTimeRange fullTime = this.time;
        if (fullTime == null) {
            this.time = fullTime = RangeTool.getFullTime(this.getSeismograms());
        }
        return this.getIterator(fullTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeismogramIterator getIterator(MicroSecondTimeRange timeRange) {
        SeismogramIterator it;
        SoftReference iteratorReference = null;
        Map map = this.threadToIterator;
        synchronized (map) {
            iteratorReference = (SoftReference)this.threadToIterator.get(Thread.currentThread());
        }
        if (iteratorReference != null && (it = (SeismogramIterator)iteratorReference.get()) != null && it.hasNext()) {
            if (it.getTimeRange().equals(timeRange)) {
                return it;
            }
            if (timeRange != null) {
                it.setTimeRange(timeRange);
                return it;
            }
        }
        it = new SeismogramIterator(this.getDataSetSeismogram().getName(), this.getSeismograms(), timeRange);
        Map map2 = this.threadToIterator;
        synchronized (map2) {
            this.threadToIterator.put(Thread.currentThread(), new SoftReference<SeismogramIterator>(it));
        }
        return it;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTimeChanged() {
        List list = this.softSeis;
        synchronized (list) {
            Map map = this.threadToIterator;
            synchronized (map) {
                this.softSeis.clear();
                this.threadToIterator.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTimeChanged() {
        List list = this.softSeis;
        synchronized (list) {
            Map map = this.threadToIterator;
            synchronized (map) {
                this.softSeis.clear();
                this.threadToIterator.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSeismograms(LocalSeismogramImpl[] seismograms) {
        boolean newData = false;
        LinkedList<LocalSeismogramImpl> badSeis = null;
        List list = this.softSeis;
        synchronized (list) {
            for (int j = 0; j < seismograms.length; ++j) {
                LocalSeismogramImpl[] curSeis = this.getSeismograms(false);
                RequestFilter[] needed = new RequestFilter[]{this.getDataSetSeismogram().getRequestFilter()};
                RequestFilter[] uncovered = CoverageTool.notCovered(needed, curSeis);
                boolean satisfiesUncovered = false;
                for (int i = 0; i < uncovered.length; ++i) {
                    if (!DCDataSetSeismogram.intersects(uncovered[i], seismograms[j])) continue;
                    satisfiesUncovered = true;
                }
                if (!satisfiesUncovered) continue;
                Iterator it = this.softSeis.iterator();
                while (it.hasNext()) {
                    LocalSeismogramImpl cur = (LocalSeismogramImpl)((SoftReference)it.next()).get();
                    if (cur == null || !DataSetSeismogram.equalOrContains(cur, seismograms[j])) continue;
                    it.remove();
                }
                if (seismograms[j].isDataDecodable()) {
                    this.softSeis.add(new SoftReference<LocalSeismogramImpl>(seismograms[j]));
                    newData = true;
                    continue;
                }
                if (badSeis == null) {
                    badSeis = new LinkedList<LocalSeismogramImpl>();
                }
                badSeis.add(seismograms[j]);
            }
        }
        if (newData) {
            SeismogramContainerListener[] listArray;
            this.time = null;
            this.noData = false;
            List j = this.listeners;
            synchronized (j) {
                listArray = new SeismogramContainerListener[this.listeners.size()];
                this.listeners.toArray(listArray);
            }
            for (int i = 0; i < listArray.length; ++i) {
                listArray[i].updateData();
            }
            Map i = this.threadToIterator;
            synchronized (i) {
                this.threadToIterator.clear();
            }
            for (int i2 = 0; i2 < listArray.length; ++i2) {
                listArray[i2].updateData();
            }
        }
        if (badSeis != null) {
            GlobalExceptionHandler.handle(new CodecException("Got " + badSeis.size() + " seismograms that couldn't be decompressed for " + ChannelIdUtil.toString((ChannelId)this.getDataSetSeismogram().getRequestFilter().channel_id)));
        }
    }

    public LocalSeismogramImpl[] getSeismograms() {
        return this.getSeismograms(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalSeismogramImpl[] getSeismograms(boolean retrieveOnEmpty) {
        if (this.getDataSetSeismogram() instanceof MemoryDataSetSeismogram) {
            this.noData = false;
            return ((MemoryDataSetSeismogram)this.getDataSetSeismogram()).getCache();
        }
        boolean callRetrieve = false;
        ArrayList existant = new ArrayList();
        LocalSeismogramImpl[] seis = EMPTY_ARRAY;
        List list = this.softSeis;
        synchronized (list) {
            if (this.softSeis.size() == 0 && retrieveOnEmpty) {
                callRetrieve = true;
            } else {
                Iterator it = this.softSeis.iterator();
                while (it.hasNext()) {
                    SoftReference current = (SoftReference)it.next();
                    Object o = current.get();
                    if (o != null) {
                        existant.add(o);
                        continue;
                    }
                    callRetrieve = true;
                    it.remove();
                }
                seis = new LocalSeismogramImpl[existant.size()];
                existant.toArray(seis);
            }
        }
        if (callRetrieve) {
            this.time = null;
            this.getDataSetSeismogram().retrieveData(this);
        }
        return seis;
    }
}

