/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.DistAz;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.display.SeismogramIterator;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableFilteredSeismogram;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableIterator;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableSeismogram;
import edu.sc.seis.fissuresUtil.freq.NamedFilter;
import edu.sc.seis.fissuresUtil.time.RangeTool;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class DisplayUtils {
    public static final String UP = "Up";
    public static final String EAST = "East";
    public static final String NORTH = "North";
    public static final String NORTHEAST = "North-East";
    public static final String UPEAST = "Up-East";
    public static final String UPNORTH = "Up-North";
    public static Font DEFAULT_FONT = new Font("Serif", 0, 12);
    public static Font MONOSPACED_FONT = new Font("Monospaced", 0, 12);
    public static final Font BORDER_FONT = new Font("Serif", 0, 11);
    public static Font BOLD_FONT = new Font("Serif", 1, 12);
    public static Font BIG_BOLD_FONT = new Font("Serif", 1, 16);
    public static final Stroke ONE_PIXEL_STROKE = new BasicStroke(1.0f);
    public static final Stroke TWO_PIXEL_STROKE = new BasicStroke(2.0f);
    public static final Stroke THREE_PIXEL_STROKE = new BasicStroke(3.0f);
    public static final UnitRangeImpl ONE_RANGE = new UnitRangeImpl(-1.0, 1.0, (Unit)UnitImpl.COUNT);
    public static final MicroSecondTimeRange ZERO_TIME = new MicroSecondTimeRange(new MicroSecondDate(0L), new MicroSecondDate(0L));
    public static final MicroSecondTimeRange ONE_TIME = new MicroSecondTimeRange(new MicroSecondDate(0L), new MicroSecondDate(1L));
    public static final Rectangle2D EMPTY_RECTANGLE = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
    public static final Color EVENT_RED = new Color(243, 33, 78);
    public static final Color EVENT_ORANGE = new Color(246, 185, 42);
    public static final Color EVENT_YELLOW = new Color(245, 249, 27);
    public static final Color STATION = new Color(43, 33, 243);
    public static final Color NO_STATUS_STATION = Color.WHITE;
    public static final Color DOWN_STATION = new Color(183, 183, 183);
    private static final Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$display$DisplayUtils == null ? (class$edu$sc$seis$fissuresUtil$display$DisplayUtils = DisplayUtils.class$("edu.sc.seis.fissuresUtil.display.DisplayUtils")) : class$edu$sc$seis$fissuresUtil$display$DisplayUtils));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$display$drawable$DrawableFilteredSeismogram;
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$display$DisplayUtils;

    public static DataSetSeismogram[] getComponents(DataSetSeismogram seismogram) {
        DataSet dataSet = seismogram.getDataSet();
        RequestFilter rf = seismogram.getRequestFilter();
        return DisplayUtils.getComponents(dataSet, rf);
    }

    public static DataSetSeismogram[] getComponents(DataSet dataSet, RequestFilter rf) {
        MicroSecondTimeRange curTr;
        RequestFilter currentRF;
        DataSetSeismogram currentSeis;
        int i;
        HashSet<DataSetSeismogram> componentSeismograms = new HashSet<DataSetSeismogram>();
        MicroSecondTimeRange tr = new MicroSecondTimeRange(rf);
        ChannelId chanId = rf.channel_id;
        String[] names = dataSet.getDataSetSeismogramNames();
        for (i = 0; i < names.length; ++i) {
            currentSeis = dataSet.getDataSetSeismogram(names[i]);
            currentRF = currentSeis.getRequestFilter();
            curTr = new MicroSecondTimeRange(currentRF);
            if (!DisplayUtils.areFriends(chanId, currentRF.channel_id) || !tr.equals(curTr)) continue;
            componentSeismograms.add(currentSeis);
        }
        if (componentSeismograms.size() < 3) {
            for (i = 0; i < names.length; ++i) {
                currentSeis = dataSet.getDataSetSeismogram(names[i]);
                currentRF = currentSeis.getRequestFilter();
                curTr = new MicroSecondTimeRange(currentRF);
                if (!DisplayUtils.areFriends(chanId, currentRF.channel_id) || !RangeTool.areOverlapping(tr, curTr)) continue;
                componentSeismograms.add(currentSeis);
            }
        }
        DataSetSeismogram[] components = new DataSetSeismogram[componentSeismograms.size()];
        componentSeismograms.toArray(components);
        return components;
    }

    public static boolean areFriends(DataSetSeismogram seis, DataSetSeismogram otherSeis) {
        return DisplayUtils.areFriends(seis.getRequestFilter().channel_id, otherSeis.getRequestFilter().channel_id);
    }

    public static boolean areFriends(ChannelId a, ChannelId b) {
        MicroSecondDate aBeginMSD = new MicroSecondDate(a.begin_time);
        MicroSecondDate bBeginMSD = new MicroSecondDate(b.begin_time);
        return NetworkIdUtil.areEqual((NetworkId)a.network_id, (NetworkId)b.network_id) && a.station_code.equals(b.station_code) && a.site_code.equals(b.site_code) && a.channel_code.substring(0, 2).equals(b.channel_code.substring(0, 2)) && aBeginMSD.equals((Object)bBeginMSD);
    }

    public static void applyFilter(NamedFilter filter, DrawableIterator it) {
        while (it.hasNext()) {
            DrawableSeismogram seis = (DrawableSeismogram)it.next();
            DrawableIterator filterIt = seis.iterator(class$edu$sc$seis$fissuresUtil$display$drawable$DrawableFilteredSeismogram == null ? DisplayUtils.class$("edu.sc.seis.fissuresUtil.display.drawable.DrawableFilteredSeismogram") : class$edu$sc$seis$fissuresUtil$display$drawable$DrawableFilteredSeismogram);
            boolean found = false;
            DrawableFilteredSeismogram filterSeis = null;
            while (filterIt.hasNext() && !found) {
                filterSeis = (DrawableFilteredSeismogram)filterIt.next();
                if (!filterSeis.getFilter().equals(filter)) continue;
                found = true;
            }
            if (!found && filter.getVisibility()) {
                seis.add(new DrawableFilteredSeismogram(seis.getParent(), seis.getSeismogram(), filter));
                continue;
            }
            if (!found || filter.getVisibility()) continue;
            seis.remove(filterSeis);
        }
    }

    public static UnitRangeImpl getShaledRange(UnitRangeImpl ampRange, double shift, double scale) {
        if (shift == 0.0 && scale == 1.0) {
            return ampRange;
        }
        double range = ampRange.getMaxValue() - ampRange.getMinValue();
        double minValue = ampRange.getMinValue() + range * shift;
        return new UnitRangeImpl(minValue, minValue + range * scale, (Unit)ampRange.getUnit());
    }

    public static final int[] getSeisPoints(LocalSeismogramImpl seis, MicroSecondTimeRange time) {
        long seisBegin = seis.getBeginTime().getMicroSecondTime();
        long seisEnd = seis.getEndTime().getMicroSecondTime();
        int numValues = seis.getNumPoints();
        int[] values = new int[]{(int)DisplayUtils.linearInterp(seisBegin, seisEnd, numValues, time.getBeginTime().getMicroSecondTime()), (int)DisplayUtils.linearInterp(seisBegin, seisEnd, numValues, time.getEndTime().getMicroSecondTime())};
        return values;
    }

    public static final int[] getPoints(SeismogramIterator it, MicroSecondTimeRange time) {
        long seisBegin = it.getSeisTime().getBeginTime().getMicroSecondTime();
        long seisEnd = it.getSeisTime().getEndTime().getMicroSecondTime();
        int numValues = it.getNumPoints();
        int[] values = new int[]{(int)DisplayUtils.linearInterp(seisBegin, seisEnd, numValues, time.getBeginTime().getMicroSecondTime()), (int)DisplayUtils.linearInterp(seisBegin, seisEnd, numValues, time.getEndTime().getMicroSecondTime())};
        return values;
    }

    public static String[] getSeismogramNames(DataSetSeismogram[] dss) {
        String[] names = new String[dss.length];
        for (int i = 0; i < dss.length; ++i) {
            names[i] = dss[i].getName();
        }
        return names;
    }

    public static String getOrientationName(DataSetSeismogram dss) {
        return DisplayUtils.getOrientationName(dss.getRequestFilter().channel_id.channel_code);
    }

    public static String getOrientationName(String orientation) {
        char ch = orientation.charAt(2);
        if (ch == 'E' || ch == '1' || ch == 'U') {
            return EAST;
        }
        if (ch == 'N' || ch == '2' || ch == 'V') {
            return NORTH;
        }
        return UP;
    }

    public static DataSetSeismogram[][] sortByComponents(DataSetSeismogram[] seismos) {
        ArrayList<DataSetSeismogram> north = new ArrayList<DataSetSeismogram>();
        ArrayList<DataSetSeismogram> east = new ArrayList<DataSetSeismogram>();
        ArrayList<DataSetSeismogram> z = new ArrayList<DataSetSeismogram>();
        for (int i = 0; i < seismos.length; ++i) {
            if (DisplayUtils.getOrientationName(seismos[i]).equals(NORTH)) {
                north.add(seismos[i]);
                continue;
            }
            if (DisplayUtils.getOrientationName(seismos[i]).equals(EAST)) {
                east.add(seismos[i]);
                continue;
            }
            z.add(seismos[i]);
        }
        DataSetSeismogram[][] sortedSeismos = new DataSetSeismogram[][]{north.toArray(new DataSetSeismogram[north.size()]), east.toArray(new DataSetSeismogram[east.size()]), z.toArray(new DataSetSeismogram[z.size()])};
        return sortedSeismos;
    }

    public static DataSetSeismogram[][] getComponents(DataSetSeismogram[] dss) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<DataSetSeismogram> north = new ArrayList<DataSetSeismogram>();
        ArrayList<DataSetSeismogram> east = new ArrayList<DataSetSeismogram>();
        ArrayList<DataSetSeismogram> z = new ArrayList<DataSetSeismogram>();
        for (int i = 0; i < dss.length; ++i) {
            if (names.contains(dss[i].getName())) continue;
            DataSetSeismogram[] newSeismograms = DisplayUtils.getComponents(dss[i]);
            for (int j = 0; j < newSeismograms.length; ++j) {
                DataSetSeismogram current = newSeismograms[j];
                if (DisplayUtils.getOrientationName(current).equals(NORTH)) {
                    north.add(current);
                } else if (DisplayUtils.getOrientationName(current).equals(EAST)) {
                    east.add(current);
                } else {
                    z.add(current);
                }
                names.add(current.getName());
            }
        }
        DataSetSeismogram[][] sortedSeismos = new DataSetSeismogram[][]{north.toArray(new DataSetSeismogram[north.size()]), east.toArray(new DataSetSeismogram[east.size()]), z.toArray(new DataSetSeismogram[z.size()])};
        return sortedSeismos;
    }

    public static boolean allNull(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            return false;
        }
        return true;
    }

    public static boolean inInsets(MouseEvent me) {
        JComponent comp = (JComponent)me.getComponent();
        Insets insets = comp.getInsets();
        return me.getX() < insets.left || me.getX() > comp.getSize().width - insets.right || me.getY() < insets.top || me.getY() > comp.getSize().height - insets.bottom;
    }

    public static final double linearInterp(long firstPoint, long lastPoint, int numValues, long currentPoint) {
        return (double)(currentPoint - firstPoint) / (double)(lastPoint - firstPoint) * (double)(numValues - 1);
    }

    public static DistAz calculateDistAz(DataSetSeismogram seis) {
        EventAccessOperations event = seis.getDataSet().getEvent();
        Channel channel = seis.getChannel();
        if (channel != null && event != null) {
            return new DistAz(channel, event);
        }
        return null;
    }

    public static QuantityImpl calculateBackAzimuth(DataSetSeismogram seis) {
        DistAz distAz = DisplayUtils.calculateDistAz(seis);
        if (distAz != null) {
            return new QuantityImpl(distAz.getBaz(), (Unit)UnitImpl.DEGREE);
        }
        return null;
    }

    public static QuantityImpl calculateAzimuth(DataSetSeismogram seis) {
        DistAz distAz = DisplayUtils.calculateDistAz(seis);
        if (distAz != null) {
            return new QuantityImpl(distAz.getAz(), (Unit)UnitImpl.DEGREE);
        }
        return null;
    }

    public static QuantityImpl calculateDistance(DataSetSeismogram seis) {
        DistAz distAz = DisplayUtils.calculateDistAz(seis);
        if (distAz != null) {
            return new QuantityImpl(distAz.getDelta(), (Unit)UnitImpl.DEGREE);
        }
        return null;
    }

    public static MicroSecondDate firstBeginDate(RequestFilter[] request) {
        MicroSecondDate begin = new MicroSecondDate(request[0].start_time);
        for (int i = 0; i < request.length; ++i) {
            MicroSecondDate tmp = new MicroSecondDate(request[i].start_time);
            if (!tmp.before((Date)begin)) continue;
            begin = tmp;
        }
        return begin;
    }

    public static MicroSecondDate lastEndDate(RequestFilter[] request) {
        MicroSecondDate end = new MicroSecondDate(request[0].end_time);
        for (int i = 0; i < request.length; ++i) {
            MicroSecondDate tmp = new MicroSecondDate(request[i].end_time);
            if (!tmp.after((Date)end)) continue;
            end = tmp;
        }
        return end;
    }

    public static Color getColorFromHex(String hexString) {
        hexString = DisplayUtils.stripPoundSign(hexString);
        int[] argb = new int[]{255, 0, 0, 0};
        int pos = 0;
        switch (hexString.length()) {
            case 4: {
                argb[0] = DisplayUtils.getDecimalFromHexSubstring(DisplayUtils.doubleSubstring(hexString, pos++, pos));
            }
            case 3: {
                for (int i = 1; i < argb.length; ++i) {
                    argb[i] = DisplayUtils.getDecimalFromHexSubstring(DisplayUtils.doubleSubstring(hexString, pos++, pos));
                }
                break;
            }
            case 8: {
                argb[0] = DisplayUtils.getDecimalFromHexSubstring(hexString.substring(pos, pos += 2));
            }
            case 6: {
                for (int i = 1; i < argb.length; ++i) {
                    argb[i] = DisplayUtils.getDecimalFromHexSubstring(hexString.substring(pos, pos += 2));
                }
                break;
            }
            default: {
                throw new NumberFormatException("hex string provided not in proper format");
            }
        }
        return new Color(argb[1], argb[2], argb[3], argb[0]);
    }

    private static String doubleSubstring(String string, int start, int end) {
        String substring = string.substring(start, end);
        return substring + substring;
    }

    private static String stripPoundSign(String string) {
        if (string.startsWith("#")) {
            return string.substring(1);
        }
        return string;
    }

    public static int getDecimalFromHexSubstring(String hexSubstring) {
        hexSubstring = DisplayUtils.stripPoundSign(hexSubstring.toLowerCase());
        char[] hexChars = hexSubstring.toCharArray();
        int total = 0;
        for (int i = 0; i < hexChars.length; ++i) {
            total = (int)((double)total + (double)DisplayUtils.getDecimalFromHexChar(hexChars[i]) * Math.pow(16.0, hexChars.length - 1 - i));
        }
        return total;
    }

    public static int getDecimalFromHexChar(char hexChar) {
        int theInt = 15 + (hexChar - 102);
        if (theInt < 10 || theInt > 15) {
            theInt = Integer.parseInt(hexChar + "");
        }
        return theInt;
    }

    public static double[] getShiftAndScale(MicroSecondTimeRange newRange, MicroSecondTimeRange curRange) {
        MicroSecondDate newBegin = newRange.getBeginTime();
        MicroSecondDate currentBegin = curRange.getBeginTime();
        double currentInterval = DisplayUtils.valAsMicro(curRange.getInterval());
        double shift = (double)(newBegin.getMicroSecondTime() - currentBegin.getMicroSecondTime()) / currentInterval;
        double scale = DisplayUtils.valAsMicro(newRange.getInterval()) / currentInterval;
        return new double[]{shift, scale};
    }

    private static double valAsMicro(TimeInterval timeInt) {
        return timeInt.convertTo(UnitImpl.MICROSECOND).getValue();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

