/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.seismogram;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.database.ConnectionCreator;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.network.JDBCChannel;
import edu.sc.seis.fissuresUtil.database.seismogram.JDBCSeismogramFiles;
import edu.sc.seis.fissuresUtil.mseed.FissuresConvert;
import edu.sc.seis.fissuresUtil.rt130.NCFile;
import edu.sc.seis.fissuresUtil.rt130.PacketType;
import edu.sc.seis.fissuresUtil.rt130.RT130FileReader;
import edu.sc.seis.fissuresUtil.rt130.RT130FormatException;
import edu.sc.seis.fissuresUtil.rt130.RT130ToLocalSeismogram;
import edu.sc.seis.fissuresUtil.sac.SacToFissures;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import edu.sc.seis.fissuresUtil.xml.SeismogramFileTypes;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.MiniSeedRead;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.BasicConfigurator;

public class PopulateDatabaseFromDirectory {
    public static void main(String[] args) throws FissuresException, IOException, SeedFormatException, SQLException, NotFound {
        int i;
        BasicConfigurator.configure();
        Properties props = Initializer.loadProperties(args);
        boolean verbose = false;
        boolean finished = false;
        boolean batch = false;
        NCFile ncFile = null;
        for (i = 1; i < args.length; ++i) {
            if (!args[i].equals("-v")) continue;
            verbose = true;
            System.out.println("Verbose messages: ON");
            System.out.println();
        }
        for (i = 1; i < args.length - 1; ++i) {
            if (!args[i].equals("-nc")) continue;
            String ncFileLocation = args[i + 1];
            ncFile = new NCFile(ncFileLocation);
            if (!verbose) continue;
            File file = new File(ncFileLocation);
            System.out.println("NC file location: " + file.getCanonicalPath());
            System.out.println();
        }
        for (i = 1; i < args.length; ++i) {
            if (!args[i].equals("-rt")) continue;
            batch = true;
            if (!verbose) continue;
            System.out.println("Batch process of RT130 data: ON");
            System.out.println();
        }
        if (args.length > 0) {
            ConnectionCreator connCreator = new ConnectionCreator(props);
            Connection conn = connCreator.createConnection();
            String fileLoc = args[args.length - 1];
            File file = new File(fileLoc);
            JDBCSeismogramFiles jdbcSeisFile = new JDBCSeismogramFiles(conn);
            JDBCChannel chanTable = new JDBCChannel(conn);
            finished = batch ? PopulateDatabaseFromDirectory.processBatchRefTek(file, verbose, conn, ncFile, jdbcSeisFile, chanTable) : (file.isDirectory() ? PopulateDatabaseFromDirectory.readEntireDirectory(fileLoc, verbose, conn, ncFile, jdbcSeisFile, chanTable, props) : PopulateDatabaseFromDirectory.readSingleFile(fileLoc, verbose, conn, ncFile, jdbcSeisFile, chanTable, props));
        } else {
            PopulateDatabaseFromDirectory.printHelp();
        }
        if (finished) {
            System.out.println();
            System.out.println("Database population complete.");
            System.out.println();
        } else {
            PopulateDatabaseFromDirectory.printHelp();
        }
    }

    private static boolean readSingleFile(String fileLoc, boolean verbose, Connection conn, NCFile ncFile, JDBCSeismogramFiles jdbcSeisFile, JDBCChannel chanTable, Properties props) throws IOException, FissuresException, SeedFormatException, SQLException, NotFound {
        boolean finished = false;
        StringTokenizer t = new StringTokenizer(fileLoc, "/\\");
        String fileName = "";
        while (t.hasMoreTokens()) {
            fileName = t.nextToken();
        }
        if (fileName.length() == 18 && fileName.charAt(9) == '_') {
            finished = PopulateDatabaseFromDirectory.processSingleRefTek(jdbcSeisFile, conn, fileLoc, fileName, verbose, ncFile, chanTable, props);
        } else if (fileName.endsWith(".mseed")) {
            finished = PopulateDatabaseFromDirectory.processMSeed(jdbcSeisFile, fileLoc, fileName, verbose);
        } else if (fileName.endsWith(".sac")) {
            finished = PopulateDatabaseFromDirectory.processSac(jdbcSeisFile, fileLoc, fileName, verbose);
        } else if (verbose) {
            if (fileName.equals("SOH.RT")) {
                System.out.println("Ignoring file: " + fileName + ".");
            } else if (fileName.equals(".DS_Store")) {
                System.out.println("Ignoring Mac OS X file: " + fileName + ".");
            } else {
                System.out.println(fileName + " can not be processed because it's file" + " name is not formatted correctly, and therefore" + " is assumed to be an invalid file format. If" + " the data file format is valid (mini seed, sac, rt130)" + " try renaming the file.");
            }
        }
        return finished;
    }

    private static boolean readEntireDirectory(String baseDirectory, boolean verbose, Connection conn, NCFile ncFile, JDBCSeismogramFiles jdbcSeisFile, JDBCChannel chanTable, Properties props) throws FissuresException, IOException, SeedFormatException, SQLException, NotFound {
        File[] files = new File(baseDirectory).listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                PopulateDatabaseFromDirectory.readEntireDirectory(baseDirectory + files[i].getName() + "/", verbose, conn, ncFile, jdbcSeisFile, chanTable, props);
                continue;
            }
            PopulateDatabaseFromDirectory.readSingleFile(files[i].getCanonicalPath(), verbose, conn, ncFile, jdbcSeisFile, chanTable, props);
        }
        return true;
    }

    private static boolean readEntireBatchDirectory(String baseDirectory, boolean verbose, Connection conn, NCFile ncFile, JDBCSeismogramFiles jdbcSeisFile, JDBCChannel chanTable) throws FissuresException, IOException, SeedFormatException, SQLException, NotFound {
        boolean finished = true;
        File[] files = new File(baseDirectory).listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory() && files[i].getParentFile().getParentFile().getName().length() == 7 && files[i].getParentFile().getName().length() == 4 && files[i].getName().length() == 1) {
                finished = PopulateDatabaseFromDirectory.processDatastreamDirectory(files[i], verbose, conn, ncFile, jdbcSeisFile, chanTable);
                continue;
            }
            if (!files[i].isDirectory()) continue;
            finished = PopulateDatabaseFromDirectory.readEntireBatchDirectory(baseDirectory + files[i].getName() + "/", verbose, conn, ncFile, jdbcSeisFile, chanTable);
            System.out.println("Directory found.");
        }
        return finished;
    }

    private static boolean processDatastreamDirectory(File datastreamDirectoryFile, boolean verbose, Connection conn, NCFile ncFile, JDBCSeismogramFiles jdbcSeisFile, JDBCChannel chanTable) {
        boolean finished = false;
        String yearAndDay = datastreamDirectoryFile.getParentFile().getParent();
        String unitIdNumber = datastreamDirectoryFile.getParent();
        System.out.println("Year and day: " + yearAndDay);
        System.out.println("Unit ID number: " + unitIdNumber);
        return finished;
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("    The last argument must be a directory or file location.");
        System.out.println("    The default SOD properties file is server.properties.");
        System.out.println("    The default database properties file is server.properties.");
        System.out.println();
        System.out.println("    -props   | Accepts alternate SOD properties file");
        System.out.println("    -hsql    | Accepts alternate database properties file");
        System.out.println("    -v       | Turn verbose messages on");
        System.out.println("    -rt      | Batch process of RT130 data");
        System.out.println("             |   No other types of data can be processed");
        System.out.println();
        System.out.println("    Props file time format | yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        System.out.println();
        System.out.println("Program finished before database population was completed.");
        System.out.println();
    }

    private static boolean processSac(JDBCSeismogramFiles jdbcSeisFile, String fileLoc, String fileName, boolean verbose) throws IOException, FissuresException, SQLException {
        SacTimeSeries sacTime = new SacTimeSeries();
        try {
            sacTime.read(new DataInputStream(new BufferedInputStream(new FileInputStream(fileLoc))));
        }
        catch (EOFException e) {
            System.err.println(fileName + " seems to be an invalid sac file.");
            return false;
        }
        catch (FileNotFoundException e) {
            System.err.println("Unable to find file " + fileName);
            return false;
        }
        LocalSeismogramImpl seis = SacToFissures.getSeismogram(sacTime);
        jdbcSeisFile.saveSeismogramToDatabase(SacToFissures.getChannel(sacTime), seis, fileLoc, SeismogramFileTypes.SAC);
        if (verbose) {
            System.out.println("SAC file " + fileName + " added to the database.");
        }
        return true;
    }

    private static boolean processMSeed(JDBCSeismogramFiles jdbcSeisFile, String fileLoc, String fileName, boolean verbose) throws IOException, SeedFormatException, FissuresException, SQLException {
        MiniSeedRead mseedRead = null;
        try {
            mseedRead = new MiniSeedRead((DataInput)new DataInputStream(new BufferedInputStream(new FileInputStream(fileLoc))));
        }
        catch (EOFException e) {
            System.err.println(fileName + " seems to  be an invalid mseed file.");
            return false;
        }
        catch (FileNotFoundException e) {
            System.err.println("Unable to find file " + fileName);
            return false;
        }
        LinkedList<DataRecord> list = new LinkedList<DataRecord>();
        try {
            DataRecord dr = mseedRead.getNextRecord();
            list.add(dr);
        }
        catch (EOFException e) {
            // empty catch block
        }
        LocalSeismogramImpl seis = FissuresConvert.toFissures(list.toArray(new DataRecord[0]));
        jdbcSeisFile.saveSeismogramToDatabase(seis.channel_id, seis, fileLoc, SeismogramFileTypes.MSEED);
        if (verbose) {
            System.out.println("MSEED file " + fileName + " added to the database.");
        }
        return true;
    }

    private static boolean processSingleRefTek(JDBCSeismogramFiles jdbcSeisFile, Connection conn, String fileLoc, String fileName, boolean verbose, NCFile ncFile, JDBCChannel chanTable, Properties props) throws IOException, SQLException, NotFound {
        if ((ncFile == null || conn == null) && verbose) {
            System.out.println("No NC (Network Configuration) file was specified.");
            System.out.println("The channel IDs created will not be correct.");
        }
        RT130FileReader toSeismogramDataPackets = new RT130FileReader(fileLoc, false);
        PacketType[] seismogramDataPacketArray = null;
        try {
            seismogramDataPacketArray = toSeismogramDataPackets.processRT130Data();
        }
        catch (RT130FormatException e) {
            System.err.println(fileName + " seems to be an invalid rt130 file.");
            return false;
        }
        RT130ToLocalSeismogram toSeismogram = new RT130ToLocalSeismogram(conn, ncFile, props);
        LocalSeismogramImpl[] seismogramArray = toSeismogram.ConvertRT130ToLocalSeismogram(seismogramDataPacketArray);
        Channel[] channel = toSeismogram.getChannels();
        for (int i = 0; i < seismogramArray.length; ++i) {
            Channel closeChannel = jdbcSeisFile.findCloseChannel(channel[i], new QuantityImpl(1.0, (Unit)UnitImpl.KILOMETER));
            if (closeChannel == null) {
                jdbcSeisFile.saveSeismogramToDatabase(channel[i], seismogramArray[i], fileLoc, SeismogramFileTypes.RT_130);
                continue;
            }
            jdbcSeisFile.setChannelBeginTimeToEarliest(closeChannel, channel[i]);
            jdbcSeisFile.saveSeismogramToDatabase(chanTable.getDBId(closeChannel.get_id()), seismogramArray[i], fileLoc, SeismogramFileTypes.RT_130);
        }
        if (verbose) {
            System.out.println("RT130 file " + fileName + " added to the database.");
        }
        return true;
    }

    private static boolean processBatchRefTek(File file, boolean verbose, Connection conn, NCFile ncFile, JDBCSeismogramFiles jdbcSeisFile, JDBCChannel chanTable) throws FissuresException, IOException, SeedFormatException, SQLException, NotFound {
        boolean finished = false;
        if (file.isDirectory()) {
            finished = PopulateDatabaseFromDirectory.readEntireBatchDirectory(file.getCanonicalPath() + "/", verbose, conn, ncFile, jdbcSeisFile, chanTable);
        } else {
            System.out.println("Single files can not be processed using the -rt batch feature.");
            PopulateDatabaseFromDirectory.printHelp();
            finished = true;
        }
        return finished;
    }
}

