/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.seismogram;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.DistAz;
import edu.sc.seis.fissuresUtil.database.JDBCTable;
import edu.sc.seis.fissuresUtil.database.JDBCTime;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.network.JDBCChannel;
import edu.sc.seis.fissuresUtil.database.util.TableSetup;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.rt130.PacketType;
import edu.sc.seis.fissuresUtil.rt130.RT130FileReader;
import edu.sc.seis.fissuresUtil.rt130.RT130FormatException;
import edu.sc.seis.fissuresUtil.rt130.RT130ToLocalSeismogram;
import edu.sc.seis.fissuresUtil.xml.SeismogramFileTypes;
import edu.sc.seis.fissuresUtil.xml.URLDataSetSeismogram;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class JDBCSeismogramFiles
extends JDBCTable {
    private Map chanIdToChannel = new HashMap();
    private static final TimeInterval ONE_SECOND = new TimeInterval(1.0, UnitImpl.SECOND);
    private static final Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$database$seismogram$JDBCSeismogramFiles == null ? (class$edu$sc$seis$fissuresUtil$database$seismogram$JDBCSeismogramFiles = JDBCSeismogramFiles.class$("edu.sc.seis.fissuresUtil.database.seismogram.JDBCSeismogramFiles")) : class$edu$sc$seis$fissuresUtil$database$seismogram$JDBCSeismogramFiles));
    private PreparedStatement insert;
    private PreparedStatement select;
    private PreparedStatement updateChannelBeginTime;
    private PreparedStatement selectSeismogram;
    private PreparedStatement tableIndex;
    private ResultSet databaseResults;
    private JDBCChannel chanTable;
    private JDBCTime timeTable;
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$database$seismogram$JDBCSeismogramFiles;

    public JDBCSeismogramFiles(Connection conn) throws SQLException {
        super("seisfilereference", conn);
        this.timeTable = new JDBCTime(conn);
        this.chanTable = new JDBCChannel(conn);
        TableSetup.setup(this, "edu/sc/seis/fissuresUtil/database/seismogram/seisfilereference.vm");
    }

    public void saveSeismogramToDatabase(ChannelId channelId, LocalSeismogramImpl seis, String fileLocation, SeismogramFileTypes filetype) throws SQLException, IOException {
        int channel_id = this.chanTable.put(channelId);
        int begin_time_id = this.timeTable.put(seis.getBeginTime().getFissuresTime());
        int end_time_id = this.timeTable.put(seis.getEndTime().getFissuresTime());
        File seismogramFile = new File(fileLocation);
        String filePath = seismogramFile.getPath();
        int fileTypeInt = filetype.getIntValue();
        this.selectSeismogram.setInt(1, channel_id);
        this.selectSeismogram.setString(2, filePath);
        ResultSet results = this.selectSeismogram.executeQuery();
        if (!results.next()) {
            this.insert.setInt(1, channel_id);
            this.insert.setInt(2, begin_time_id);
            this.insert.setInt(3, end_time_id);
            this.insert.setString(4, filePath);
            this.insert.setInt(5, fileTypeInt);
            this.insert.executeUpdate();
        }
    }

    public void saveSeismogramToDatabase(Channel channel, LocalSeismogramImpl seis, String fileLocation, SeismogramFileTypes filetype) throws SQLException, IOException {
        int channel_id = this.chanTable.put(channel);
        int begin_time_id = this.timeTable.put(seis.getBeginTime().getFissuresTime());
        int end_time_id = this.timeTable.put(seis.getEndTime().getFissuresTime());
        File seismogramFile = new File(fileLocation);
        String filePath = seismogramFile.getPath();
        int fileTypeInt = filetype.getIntValue();
        this.selectSeismogram.setInt(1, channel_id);
        this.selectSeismogram.setString(2, filePath);
        ResultSet results = this.selectSeismogram.executeQuery();
        if (!results.next()) {
            this.insert.setInt(1, channel_id);
            this.insert.setInt(2, begin_time_id);
            this.insert.setInt(3, end_time_id);
            this.insert.setString(4, filePath);
            this.insert.setInt(5, fileTypeInt);
            this.insert.executeUpdate();
        }
    }

    public void saveSeismogramToDatabase(int channelDbId, LocalSeismogramImpl seis, String fileLocation, SeismogramFileTypes filetype) throws SQLException, IOException {
        int begin_time_id = this.timeTable.put(seis.getBeginTime().getFissuresTime());
        int end_time_id = this.timeTable.put(seis.getEndTime().getFissuresTime());
        File seismogramFile = new File(fileLocation);
        String filePath = seismogramFile.getPath();
        int fileTypeInt = filetype.getIntValue();
        this.selectSeismogram.setInt(1, channelDbId);
        this.selectSeismogram.setString(2, filePath);
        ResultSet results = this.selectSeismogram.executeQuery();
        if (!results.next()) {
            this.insert.setInt(1, channelDbId);
            this.insert.setInt(2, begin_time_id);
            this.insert.setInt(3, end_time_id);
            this.insert.setString(4, filePath);
            this.insert.setInt(5, fileTypeInt);
            this.insert.executeUpdate();
        }
    }

    public RequestFilter[] findMatchingSeismograms(RequestFilter[] requestArray, boolean ignoreNetworkTimes) throws SQLException {
        List matchingSeismogramsResultList = this.queryDatabaseForSeismograms(requestArray, false, ignoreNetworkTimes);
        return matchingSeismogramsResultList.toArray(new RequestFilter[matchingSeismogramsResultList.size()]);
    }

    public LocalSeismogram[] getMatchingSeismograms(RequestFilter[] requestArray, boolean ignoreNetworkTimes) throws SQLException {
        List matchingSeismogramsResultList = this.queryDatabaseForSeismograms(requestArray, true, ignoreNetworkTimes);
        return matchingSeismogramsResultList.toArray(new LocalSeismogram[matchingSeismogramsResultList.size()]);
    }

    public List queryDatabaseForSeismograms(RequestFilter[] requestArray, boolean returnSeismograms, boolean ignoreNetworkTimes) throws SQLException {
        ArrayList matchingSeismogramsResultList = new ArrayList();
        for (int i = 0; i < requestArray.length; ++i) {
            this.queryDatabaseForSeismogram(matchingSeismogramsResultList, requestArray[i], returnSeismograms, ignoreNetworkTimes);
        }
        return matchingSeismogramsResultList;
    }

    public Channel findCloseChannel(Channel newChannel, QuantityImpl distance) throws SQLException, NotFound {
        ChannelId[] channelId;
        try {
            channelId = this.chanTable.getIdsByCode(newChannel.get_id().network_id, newChannel.get_id().station_code, newChannel.get_id().site_code, newChannel.get_code());
        }
        catch (NotFound e) {
            return null;
        }
        ChannelId newChannelId = newChannel.get_id();
        for (int i = 0; i < channelId.length; ++i) {
            if (!ChannelIdUtil.areEqualExceptForBeginTime((ChannelId)newChannelId, (ChannelId)channelId[i])) continue;
            Channel closeChannel = this.getChannel(channelId[i]);
            Location locationFromDatabase = closeChannel.my_site.my_location;
            DistAz da = new DistAz(locationFromDatabase, newChannel.my_site.my_location);
            QuantityImpl siteDistance = new QuantityImpl(DistAz.degreesToKilometers(da.getDelta()), (Unit)UnitImpl.KILOMETER);
            if (!siteDistance.lessThan(distance)) continue;
            return closeChannel;
        }
        return null;
    }

    private Channel getChannel(ChannelId channelId) throws SQLException, NotFound {
        String chanIdString = ChannelIdUtil.toString((ChannelId)channelId);
        Channel closeChannel = (Channel)this.chanIdToChannel.get(chanIdString);
        if (closeChannel == null) {
            closeChannel = this.chanTable.get(channelId);
            this.chanIdToChannel.put(chanIdString, closeChannel);
        }
        return closeChannel;
    }

    public void setChannelBeginTimeToEarliest(Channel channelFromDatabase, Channel newChannel) throws SQLException, NotFound {
        MicroSecondDate newChannelBeginTime = new MicroSecondDate(newChannel.get_id().begin_time);
        MicroSecondDate newChannelEndTime = new MicroSecondDate(newChannel.effective_time.end_time);
        MicroSecondDate channelFromDatabaseBeginTime = new MicroSecondDate(channelFromDatabase.get_id().begin_time);
        MicroSecondDate channelFromDatabaseEndTime = new MicroSecondDate(channelFromDatabase.effective_time.end_time);
        if (newChannelBeginTime.before((Date)channelFromDatabaseBeginTime) && newChannelEndTime.equals((Object)channelFromDatabaseEndTime)) {
            this.updateChannelBeginTime.setInt(1, this.timeTable.put(newChannel.get_id().begin_time));
            this.updateChannelBeginTime.setInt(2, this.chanTable.getDBId(channelFromDatabase.get_id()));
            this.updateChannelBeginTime.executeUpdate();
            channelFromDatabase.get_id().begin_time = newChannel.get_id().begin_time;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void queryDatabaseForSeismogram(List matchingSeismogramsResultList, RequestFilter request, boolean returnSeismograms, boolean ignoreNetworkTimes) throws SQLException {
        try {
            chanId = ignoreNetworkTimes ? this.chanTable.getDBIdIgnoringNetworkId(request.channel_id.network_id.network_code, request.channel_id.station_code, request.channel_id.site_code, request.channel_id.channel_code) : new int[]{this.chanTable.getDBId(request.channel_id)};
        }
        catch (NotFound e) {
            JDBCSeismogramFiles.logger.debug((Object)"Can not find channel ID in database.");
            return;
        }
        adjustedBeginTime = new MicroSecondDate(request.start_time).subtract(JDBCSeismogramFiles.ONE_SECOND);
        adjustedEndTime = new MicroSecondDate(request.end_time).add(JDBCSeismogramFiles.ONE_SECOND);
        for (i = 0; i < chanId.length; ++i) {
            block11: {
                this.select.setInt(1, chanId[i]);
                this.select.setTimestamp(2, adjustedEndTime.getTimestamp());
                this.select.setTimestamp(3, adjustedBeginTime.getTimestamp());
                this.databaseResults = this.select.executeQuery();
                if (!returnSeismograms) break block11;
lbl15:
                // 3 sources

                try {
                    while (this.databaseResults.next()) {
                        block12: {
                            seismogramFile = new File(this.databaseResults.getString(4));
                            filetype = SeismogramFileTypes.fromInt(this.databaseResults.getInt("filetype"));
                            if (!filetype.equals(SeismogramFileTypes.RT_130)) break block12;
                            refTekSeismogramsList = this.getMatchingSeismogramsFromRefTek(seismogramFile.getCanonicalPath(), request.channel_id, adjustedBeginTime, adjustedEndTime);
                            refTekSeismogramsArray = refTekSeismogramsList.toArray(new LocalSeismogramImpl[refTekSeismogramsList.size()]);
                            for (j = 0; j < refTekSeismogramsArray.length; ++j) {
                                matchingSeismogramsResultList.add(refTekSeismogramsArray[j]);
                            }
                            ** GOTO lbl15
                        }
                        urlSeis = new URLDataSetSeismogram(seismogramFile.toURL(), filetype);
                        result = urlSeis.getSeismograms();
                        for (j = 0; j < result.length; ++j) {
                            matchingSeismogramsResultList.add(result[j]);
                        }
                        ** GOTO lbl15
                    }
                    continue;
                }
                catch (Exception e) {
                    GlobalExceptionHandler.handle("Problem occured while returning seismograms from the database.", e);
                    continue;
                }
            }
            try {
                while (this.databaseResults.next()) {
                    resultSetToRequestFilter = new RequestFilter();
                    resultSetToRequestFilter.channel_id = this.chanTable.getId(this.databaseResults.getInt(1));
                    resultSetToRequestFilter.start_time = this.timeTable.get(this.databaseResults.getInt(2));
                    resultSetToRequestFilter.end_time = this.timeTable.get(this.databaseResults.getInt(3));
                    matchingSeismogramsResultList.add(resultSetToRequestFilter);
                }
                continue;
            }
            catch (Exception e) {
                GlobalExceptionHandler.handle("Problem occured while querying the database for seismograms.");
            }
        }
    }

    private List getMatchingSeismogramsFromRefTek(String seismogramFile, ChannelId chanId, MicroSecondDate beginTime, MicroSecondDate endTime) throws IOException {
        LocalSeismogramImpl[] seismogramArray;
        RT130FileReader toSeismogramDataPacket = new RT130FileReader(seismogramFile, true);
        try {
            PacketType[] seismogramDataPacketArray = toSeismogramDataPacket.processRT130Data();
            RT130ToLocalSeismogram toSeismogram = new RT130ToLocalSeismogram();
            seismogramArray = toSeismogram.ConvertRT130ToLocalSeismogram(seismogramDataPacketArray);
        }
        catch (RT130FormatException e) {
            logger.debug((Object)"Problem occured while returning rt130 seismograms from the file listed in the database.");
            return new ArrayList(0);
        }
        ArrayList<LocalSeismogramImpl> matchingSeismogramsResultList = new ArrayList<LocalSeismogramImpl>(0);
        for (int i = 0; i < seismogramArray.length; ++i) {
            if (!seismogramArray[i].channel_id.channel_code.equals(chanId.channel_code) || !seismogramArray[i].getBeginTime().before((Date)endTime) || !seismogramArray[i].getEndTime().after((Date)beginTime)) continue;
            seismogramArray[i].channel_id = chanId;
            matchingSeismogramsResultList.add(seismogramArray[i]);
        }
        return matchingSeismogramsResultList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

