/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.network;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.database.JDBCQuantity;
import edu.sc.seis.fissuresUtil.database.JDBCSequence;
import edu.sc.seis.fissuresUtil.database.JDBCTime;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.network.JDBCNetwork;
import edu.sc.seis.fissuresUtil.database.network.JDBCSite;
import edu.sc.seis.fissuresUtil.database.network.JDBCStation;
import edu.sc.seis.fissuresUtil.database.network.NetworkTable;
import edu.sc.seis.fissuresUtil.database.util.TableSetup;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class JDBCChannel
extends NetworkTable {
    private PreparedStatement getAllChans;
    private PreparedStatement getAllChansForStation;
    private PreparedStatement getAllChansForNetwork;
    private PreparedStatement getByDBId;
    private PreparedStatement putAll;
    private PreparedStatement updateNonId;
    private PreparedStatement putId;
    private PreparedStatement getAllIds;
    private PreparedStatement getAllIdsForStation;
    private PreparedStatement getAllIdsForNetwork;
    private PreparedStatement getByCodes;
    private PreparedStatement getIdsByCodes;
    private PreparedStatement getStationDbId;
    private JDBCNetwork netTable;
    private JDBCQuantity quantityTable;
    private JDBCSequence seq;
    private JDBCSite siteTable;
    private JDBCStation stationTable;
    private JDBCTime time;
    private static final Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$database$network$JDBCChannel == null ? (class$edu$sc$seis$fissuresUtil$database$network$JDBCChannel = JDBCChannel.class$("edu.sc.seis.fissuresUtil.database.network.JDBCChannel")) : class$edu$sc$seis$fissuresUtil$database$network$JDBCChannel));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$database$network$JDBCChannel;

    public JDBCChannel() throws SQLException {
        this(ConnMgr.createConnection());
    }

    public JDBCChannel(Connection conn) throws SQLException {
        this(conn, new JDBCQuantity(conn), new JDBCSite(conn), new JDBCTime(conn));
    }

    public JDBCChannel(Connection conn, JDBCQuantity quantityTable, JDBCSite siteTable, JDBCTime time) throws SQLException {
        super("channel", conn);
        this.quantityTable = quantityTable;
        this.time = time;
        this.siteTable = siteTable;
        this.stationTable = siteTable.getStationTable();
        this.netTable = this.stationTable.getNetTable();
        this.seq = new JDBCSequence(conn, "ChannelSeq");
        TableSetup.setup(this, "edu/sc/seis/fissuresUtil/database/props/network/default.props");
    }

    private ChannelId[] extractAllChanIds(PreparedStatement query) throws SQLException {
        ResultSet rs = query.executeQuery();
        ArrayList<ChannelId> aList = new ArrayList<ChannelId>();
        while (rs.next()) {
            aList.add(JDBCChannel.extractId(rs, this.siteTable, this.time));
        }
        return aList.toArray(new ChannelId[aList.size()]);
    }

    public Channel[] extractAllChans(PreparedStatement query) throws SQLException, NotFound {
        ResultSet rs = query.executeQuery();
        ArrayList<Channel> aList = new ArrayList<Channel>();
        while (rs.next()) {
            aList.add(JDBCChannel.extract(rs, this.siteTable, this.time, this.quantityTable));
        }
        return aList.toArray(new Channel[aList.size()]);
    }

    public Channel get(ChannelId id) throws SQLException, NotFound {
        return this.get(this.getDBId(id));
    }

    public ChannelId getId(int dbid) throws SQLException, NotFound {
        this.getByDBId.setInt(1, dbid);
        ResultSet rs = this.getByDBId.executeQuery();
        if (rs.next()) {
            return JDBCChannel.extractId(rs, this.siteTable, this.time);
        }
        throw new NotFound("No ChannelId found for database id = " + dbid);
    }

    public Channel get(int dbid) throws SQLException, NotFound {
        this.getByDBId.setInt(1, dbid);
        ResultSet rs = this.getByDBId.executeQuery();
        if (rs.next()) {
            return JDBCChannel.extract(rs, this.siteTable, this.time, this.quantityTable);
        }
        throw new NotFound("No Channel found for database id = " + dbid);
    }

    public int getStationDbId(int channelDbId) throws SQLException, NotFound {
        this.getStationDbId.setInt(1, channelDbId);
        ResultSet rs = this.getStationDbId.executeQuery();
        if (rs.next()) {
            return rs.getInt("sta_id");
        }
        throw new NotFound("No such channel " + channelDbId);
    }

    public ChannelId[] getAllChannelIds() throws SQLException {
        return this.extractAllChanIds(this.getAllIds);
    }

    public ChannelId[] getAllChannelIds(NetworkId network) throws NotFound, SQLException {
        int net_id = this.netTable.getDbId(network);
        this.getAllIdsForNetwork.setInt(1, net_id);
        return this.extractAllChanIds(this.getAllIdsForNetwork);
    }

    public ChannelId[] getAllChannelIds(StationId station) throws NotFound, SQLException {
        int sta_id = this.stationTable.getDBId(station);
        this.getAllIdsForStation.setInt(1, sta_id);
        return this.extractAllChanIds(this.getAllIdsForStation);
    }

    public Channel[] getAllChannels() throws NotFound, SQLException {
        return this.extractAllChans(this.getAllChans);
    }

    public Channel[] getAllChannels(NetworkId network) throws NotFound, SQLException {
        int net_id = this.netTable.getDbId(network);
        this.getAllChansForNetwork.setInt(1, net_id);
        return this.extractAllChans(this.getAllChansForNetwork);
    }

    public Channel[] getAllChannels(StationId station) throws NotFound, SQLException {
        int sta_id = this.stationTable.getDBId(station);
        this.getAllChansForStation.setInt(1, sta_id);
        return this.extractAllChans(this.getAllChansForStation);
    }

    public Channel[] getByCode(NetworkId networkId, String station_code, String site_code, String channel_code) throws SQLException, NotFound {
        int net_id = this.netTable.getDbId(networkId);
        int index = 1;
        this.getByCodes.setInt(index++, net_id);
        this.getByCodes.setString(index++, station_code);
        this.getByCodes.setString(index++, site_code);
        this.getByCodes.setString(index++, channel_code);
        return this.extractAllChans(this.getByCodes);
    }

    public ChannelId[] getIdsByCode(NetworkId networkId, String station_code, String site_code, String channel_code) throws SQLException, NotFound {
        int net_id = this.netTable.getDbId(networkId);
        int index = 1;
        this.getIdsByCodes.setInt(index++, net_id);
        this.getIdsByCodes.setString(index++, station_code);
        this.getIdsByCodes.setString(index++, site_code);
        this.getIdsByCodes.setString(index++, channel_code);
        ResultSet rs = this.getIdsByCodes.executeQuery();
        ArrayList<ChannelId> aList = new ArrayList<ChannelId>();
        while (rs.next()) {
            try {
                aList.add(new ChannelId(networkId, station_code, site_code, channel_code, this.time.get(rs.getInt("chan_begin_id"))));
            }
            catch (NotFound e) {
                throw new RuntimeException(e);
            }
        }
        return aList.toArray(new ChannelId[aList.size()]);
    }

    public int[] getDBIdIgnoringNetworkId(String network_code, String station_code, String site_code, String channel_code) throws SQLException, NotFound {
        String query = "SELECT chan_id FROM channel, site, station, network WHERE chan_code = '" + channel_code + "'" + " AND channel.site_id = site.site_id AND site_code = '" + site_code + "'" + " AND site.sta_id = station.sta_id AND sta_code = '" + station_code + "'" + " AND station.net_id = network.net_id AND net_code = '" + network_code + "'";
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        if (rs.next()) {
            resultList.add(new Integer(rs.getInt("chan_id")));
            while (rs.next()) {
                resultList.add(new Integer(rs.getInt("chan_id")));
            }
            Iterator it = resultList.iterator();
            int[] result = new int[resultList.size()];
            int i = 0;
            while (it.hasNext()) {
                result[i] = (Integer)it.next();
                ++i;
            }
            return result;
        }
        throw new NotFound("No such channel id in the db");
    }

    public int getDBId(ChannelId id) throws SQLException, NotFound {
        int netDbId = this.netTable.getDbId(id.network_id);
        int[] possibleStaDbIds = this.stationTable.getDBIds(netDbId, id.station_code);
        int[] possibleSiteIds = this.siteTable.getDBIds(possibleStaDbIds, id.site_code);
        int beginId = this.time.put(id.begin_time);
        String query = "SELECT chan_id FROM channel WHERE chan_begin_id = " + beginId + " and chan_code = '" + id.channel_code + "'" + " and site_id IN (";
        for (int i = 0; i < possibleSiteIds.length - 1; ++i) {
            query = query + possibleSiteIds[i] + ", ";
        }
        query = query + possibleSiteIds[possibleSiteIds.length - 1] + ")";
        Statement stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        if (rs.next()) {
            return rs.getInt("chan_id");
        }
        throw new NotFound("No such channel id in the db");
    }

    public JDBCSite getSiteTable() {
        return this.siteTable;
    }

    public JDBCNetwork getNetworkTable() {
        return this.netTable;
    }

    public JDBCStation getStationTable() {
        return this.stationTable;
    }

    private void insertAdditonalChannelStuff(int chanDbId, int newSiteId, Channel chan) throws SQLException {
        int index = 1;
        this.updateNonId.setInt(index++, newSiteId);
        index = JDBCChannel.insertOnlyChannel(chan, this.updateNonId, index, this.quantityTable, this.time);
        this.updateNonId.setInt(index++, chanDbId);
        this.updateNonId.executeUpdate();
    }

    public int put(Channel chan) throws SQLException {
        int dbid;
        try {
            dbid = this.getDBId(chan.get_id());
            this.reuniteChannelAndIdIfIdIsLonely(chan, dbid);
        }
        catch (NotFound notFound) {
            dbid = this.seq.next();
            this.putAll.setInt(1, dbid);
            JDBCChannel.insertAll(chan, this.putAll, 2, this.siteTable, this.quantityTable, this.time);
            this.putAll.executeUpdate();
        }
        return dbid;
    }

    public int put(ChannelId id) throws SQLException {
        int dbid;
        try {
            dbid = this.getDBId(id);
        }
        catch (NotFound notFound) {
            dbid = this.seq.next();
            this.putId.setInt(1, dbid);
            this.putId.setInt(2, this.siteTable.put(id));
            this.putId.setString(3, id.channel_code);
            this.putId.setInt(4, this.time.put(id.begin_time));
            this.putId.executeUpdate();
        }
        return dbid;
    }

    private void reuniteChannelAndIdIfIdIsLonely(Channel chan, int dbid) throws SQLException {
        int siteDbIdForChannel = this.siteTable.put(chan.my_site);
        this.getByDBId.setInt(1, dbid);
        ResultSet rs = this.getByDBId.executeQuery();
        rs.next();
        int currentSiteId = rs.getInt("site_id");
        if (siteDbIdForChannel != currentSiteId) {
            this.insertAdditonalChannelStuff(dbid, siteDbIdForChannel, chan);
            this.siteTable.cleanupVestigesOfLonelyChannelId(currentSiteId);
        }
    }

    public static Channel extract(ResultSet rs, JDBCSite siteTable, JDBCTime time, JDBCQuantity quantityTable) throws SQLException, NotFound {
        Orientation ori = new Orientation(rs.getFloat("chan_orientation_az"), rs.getFloat("chan_orientation_dip"));
        TimeInterval t = new TimeInterval((Quantity)quantityTable.get(rs.getInt("chan_sampling_interval_id")));
        SamplingImpl sampling = new SamplingImpl(rs.getInt("chan_sampling_numpoints"), t);
        ChannelId id = JDBCChannel.extractId(rs, siteTable, time);
        return new ChannelImpl(id, rs.getString("chan_name"), ori, (Sampling)sampling, new TimeRange(id.begin_time, time.get(rs.getInt("chan_end_id"))), siteTable.get(rs.getInt("site_id")));
    }

    public static ChannelId extractId(ResultSet rs, JDBCSite siteTable, JDBCTime time) throws SQLException {
        try {
            SiteId siteId = siteTable.getSiteId(rs.getInt("site_id"));
            return new ChannelId(siteId.network_id, siteId.station_code, siteId.site_code, rs.getString("chan_code"), time.get(rs.getInt("chan_begin_id")));
        }
        catch (NotFound e) {
            throw new RuntimeException(e);
        }
    }

    public static int insertAll(Channel chan, PreparedStatement stmt, int index, JDBCSite siteTable, JDBCQuantity quantityTable, JDBCTime time) throws SQLException {
        index = JDBCChannel.insertId(chan.get_id(), chan.my_site, stmt, index, siteTable, time);
        index = JDBCChannel.insertOnlyChannel(chan, stmt, index, quantityTable, time);
        return index;
    }

    public static int insertId(ChannelId id, int siteDbId, PreparedStatement stmt, int index, JDBCSite siteTable, JDBCTime time) throws SQLException {
        stmt.setInt(index++, siteDbId);
        stmt.setString(index++, id.channel_code);
        stmt.setInt(index++, time.put(id.begin_time));
        return index;
    }

    public static int insertId(ChannelId id, PreparedStatement stmt, int index, JDBCSite siteTable, JDBCTime time) throws SQLException {
        return JDBCChannel.insertId(id, null, stmt, index, null, time);
    }

    public static int insertId(ChannelId id, Site site, PreparedStatement stmt, int index, JDBCSite siteTable, JDBCTime time) throws SQLException {
        return JDBCChannel.insertId(id, siteTable.put(site), stmt, index, siteTable, time);
    }

    public static int insertOnlyChannel(Channel chan, PreparedStatement stmt, int index, JDBCQuantity quantityTable, JDBCTime time) throws SQLException {
        stmt.setInt(index++, time.put(chan.effective_time.end_time));
        stmt.setString(index++, chan.name);
        stmt.setFloat(index++, chan.an_orientation.azimuth);
        stmt.setFloat(index++, chan.an_orientation.dip);
        stmt.setInt(index++, quantityTable.put(chan.sampling_info.interval));
        stmt.setInt(index++, chan.sampling_info.numPoints);
        return index;
    }

    public JDBCQuantity getQuantityTable() {
        return this.quantityTable;
    }

    public JDBCTime getTimeTable() {
        return this.time;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

