/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.event;

import edu.iris.Fissures.IfEvent.Magnitude;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.database.event.EventTable;
import edu.sc.seis.fissuresUtil.database.event.JDBCContributor;
import edu.sc.seis.fissuresUtil.database.util.TableSetup;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class JDBCMagnitude
extends EventTable {
    protected JDBCContributor jdbcContributor;
    protected PreparedStatement getStmt;
    protected PreparedStatement exists;
    protected PreparedStatement putStmt;
    protected PreparedStatement dropAll;

    public JDBCMagnitude(Connection conn) throws SQLException {
        this(conn, new JDBCContributor(conn));
    }

    public JDBCMagnitude(Connection conn, JDBCContributor jdbcContributor) throws SQLException {
        super("magnitude", conn);
        this.jdbcContributor = jdbcContributor;
        Statement stmt = conn.createStatement();
        String props = "edu/sc/seis/fissuresUtil/database/props/event/default.props";
        TableSetup.setup(this.getTableName(), conn, this, props);
    }

    public boolean exists(Magnitude magnitude, int originId) throws SQLException, NotFound {
        this.insert(magnitude, originId, this.exists);
        ResultSet rs = this.exists.executeQuery();
        if (rs.next()) {
            return true;
        }
        throw new NotFound("magnitude is not found");
    }

    public void insert(Magnitude magnitude, int originId, PreparedStatement stmt) throws SQLException {
        stmt.setString(1, magnitude.type);
        stmt.setFloat(2, magnitude.value);
        stmt.setInt(3, this.jdbcContributor.put(magnitude.contributor));
        stmt.setInt(4, originId);
    }

    public void put(Magnitude magnitude, int originId) throws SQLException {
        try {
            this.exists(magnitude, originId);
        }
        catch (NotFound e) {
            this.insert(magnitude, originId, this.putStmt);
            this.putStmt.executeUpdate();
        }
    }

    public void put(Magnitude[] magnitudes, int originId) throws SQLException {
        for (int i = 0; i < magnitudes.length; ++i) {
            this.put(magnitudes[i], originId);
        }
    }

    public Magnitude[] get(int id) throws SQLException, NotFound {
        this.getStmt.setInt(1, id);
        ResultSet rs = this.getStmt.executeQuery();
        ArrayList<Magnitude> mags = new ArrayList<Magnitude>();
        while (rs.next()) {
            mags.add(this.extract(rs));
        }
        return mags.toArray(new Magnitude[mags.size()]);
    }

    public Magnitude extract(ResultSet rs) throws SQLException, NotFound {
        return new Magnitude(rs.getString("magnitudetype"), rs.getFloat("magnitudevalue"), this.jdbcContributor.extract(rs));
    }

    public void clean() throws SQLException {
        this.dropAll.executeUpdate();
    }
}

