/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database;

import edu.sc.seis.fissuresUtil.database.ConnMgr;
import edu.sc.seis.fissuresUtil.database.DBUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class JDBCSequence {
    private PreparedStatement nextVal;
    private static final Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$database$JDBCSequence == null ? (class$edu$sc$seis$fissuresUtil$database$JDBCSequence = JDBCSequence.class$("edu.sc.seis.fissuresUtil.database.JDBCSequence")) : class$edu$sc$seis$fissuresUtil$database$JDBCSequence));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$database$JDBCSequence;

    public JDBCSequence(Connection conn, String name) throws SQLException {
        try {
            if (!DBUtil.sequenceExists(name, conn)) {
                conn.createStatement().executeUpdate(JDBCSequence.initCreateStmt(conn, name));
            }
        }
        catch (SQLException e) {
            logger.info((Object)("Sequence must already exist for " + name), (Throwable)e);
        }
        this.nextVal = conn.prepareStatement(JDBCSequence.initNextValStmt(conn, name));
    }

    public int next() throws SQLException {
        ResultSet rs = this.nextVal.executeQuery();
        rs.next();
        return rs.getInt(1);
    }

    private static String initNextValStmt(Connection conn, String seqName) throws SQLException {
        if (conn.getMetaData().getURL().startsWith("jdbc:postgresql:")) {
            return "SELECT NEXTVAL ('" + seqName + "')";
        }
        if (conn.getMetaData().getURL().startsWith("jdbc:hsqldb:")) {
            return "CALL NEXT VALUE FOR " + seqName;
        }
        return ConnMgr.getSQL(seqName + ".nextVal");
    }

    private static String initCreateStmt(Connection conn, String seqName) throws SQLException {
        if (conn.getMetaData().getURL().startsWith("jdbc:postgresql:") || conn.getMetaData().getURL().startsWith("jdbc:hsqldb:")) {
            return "CREATE SEQUENCE " + seqName;
        }
        return ConnMgr.getSQL(seqName + ".create");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

