/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfRealTimeCollector.DataChunk;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.IfTimeSeries.EncodedData;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesDataSel;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesType;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Category;

public class DataCenterUtil {
    static Category logger = Category.getInstance((String)(class$edu$sc$seis$fissuresUtil$database$DataCenterUtil == null ? (class$edu$sc$seis$fissuresUtil$database$DataCenterUtil = DataCenterUtil.class$("edu.sc.seis.fissuresUtil.database.DataCenterUtil")) : class$edu$sc$seis$fissuresUtil$database$DataCenterUtil).getName());
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$database$DataCenterUtil;

    public static RequestFilter[] makeRequestFilter(float tolerance, List chunks) {
        List splitList = DataCenterUtil.splitGaps(tolerance, chunks);
        Iterator it = splitList.iterator();
        LinkedList<RequestFilter> seisList = new LinkedList<RequestFilter>();
        while (it.hasNext()) {
            seisList.add(DataCenterUtil.getRequestFilter((List)it.next()));
        }
        logger.debug((Object)("original chunks=" + chunks.size() + "  rf size=" + seisList.size()));
        RequestFilter[] tmpRF = new RequestFilter[]{};
        return seisList.toArray(tmpRF);
    }

    public static LocalSeismogram[] makeSeismograms(float tolerance, List chunks) {
        List splitList = DataCenterUtil.splitGaps(tolerance, chunks);
        Iterator it = splitList.iterator();
        LinkedList<LocalSeismogramImpl> seisList = new LinkedList<LocalSeismogramImpl>();
        while (it.hasNext()) {
            seisList.add(DataCenterUtil.getSeismogram((List)it.next()));
        }
        LocalSeismogram[] tmpSeis = new LocalSeismogram[]{};
        return seisList.toArray(tmpSeis);
    }

    public static List splitGaps(float tolerance, List chunks) {
        DataChunk currChunk;
        LinkedList<List> out = new LinkedList<List>();
        LinkedList<DataChunk> currList = new LinkedList<DataChunk>();
        Iterator it = chunks.iterator();
        DataChunk prevChunk = currChunk = null;
        if (!it.hasNext()) {
            return out;
        }
        currChunk = (DataChunk)it.next();
        MicroSecondDate curr = new MicroSecondDate(currChunk.begin_time);
        currList.add(currChunk);
        if (!it.hasNext()) {
            out.add(chunks);
            return out;
        }
        while (it.hasNext()) {
            prevChunk = currChunk;
            MicroSecondDate prev = new MicroSecondDate(prevChunk.end_time);
            currChunk = (DataChunk)it.next();
            curr = new MicroSecondDate(currChunk.begin_time);
            TimeInterval gap = curr.subtract(prev);
            SamplingImpl samps = DataCenterUtil.getSampling(prevChunk);
            TimeInterval period = samps.getPeriod();
            QuantityImpl ratio = (gap = gap.subtract(period)).divideBy((QuantityImpl)period);
            if (Math.abs(ratio.getValue()) > (double)tolerance) {
                logger.warn((Object)("Gap found in seismogram, ratio=" + ratio + " > " + tolerance + " " + prevChunk.end_time.date_time + " " + currChunk.begin_time.date_time + " " + samps + " gap=" + gap + " period=" + period));
                out.add(currList);
                currList = new LinkedList();
            }
            currList.add(currChunk);
        }
        out.add(currList);
        return out;
    }

    public static SamplingImpl getSampling(DataChunk chunk) {
        int npts = 0;
        if (chunk.data.discriminator() == TimeSeriesType.TYPE_SHORT) {
            npts = chunk.data.sht_values().length;
        } else if (chunk.data.discriminator() == TimeSeriesType.TYPE_LONG) {
            npts = chunk.data.int_values().length;
        } else if (chunk.data.discriminator() == TimeSeriesType.TYPE_FLOAT) {
            npts = chunk.data.flt_values().length;
        } else if (chunk.data.discriminator() == TimeSeriesType.TYPE_DOUBLE) {
            npts = chunk.data.dbl_values().length;
        } else if (chunk.data.discriminator() == TimeSeriesType.TYPE_ENCODED) {
            EncodedData[] encoded = chunk.data.encoded_values();
            for (int i = 0; i < encoded.length; ++i) {
                npts += encoded[i].num_points;
            }
        } else {
            throw new RuntimeException("Unknown data type! " + chunk.data.discriminator().value());
        }
        MicroSecondDate b = new MicroSecondDate(chunk.begin_time);
        MicroSecondDate e = new MicroSecondDate(chunk.end_time);
        TimeInterval t = e.subtract(b);
        SamplingImpl samps = new SamplingImpl(npts - 1, t);
        return samps;
    }

    public static LocalSeismogramImpl getSeismogram(List chunks) {
        Object[] whole;
        ArrayList<Object> eData = new ArrayList<Object>();
        int numPoints = 0;
        DataChunk currChunk = null;
        MicroSecondDate begin = null;
        ChannelId channelId = null;
        Iterator it = chunks.iterator();
        if (!it.hasNext()) {
            return null;
        }
        while (it.hasNext()) {
            currChunk = (DataChunk)it.next();
            if (begin == null) {
                begin = new MicroSecondDate(currChunk.begin_time);
                channelId = currChunk.channel;
            }
            if (currChunk.data.discriminator() == TimeSeriesType.TYPE_SHORT) {
                numPoints += currChunk.data.sht_values().length;
                eData.add(currChunk.data.sht_values());
                continue;
            }
            if (currChunk.data.discriminator() == TimeSeriesType.TYPE_LONG) {
                numPoints += currChunk.data.int_values().length;
                eData.add(currChunk.data.int_values());
                continue;
            }
            if (currChunk.data.discriminator() == TimeSeriesType.TYPE_FLOAT) {
                numPoints += currChunk.data.flt_values().length;
                eData.add(currChunk.data.flt_values());
                continue;
            }
            if (currChunk.data.discriminator() == TimeSeriesType.TYPE_DOUBLE) {
                numPoints += currChunk.data.dbl_values().length;
                eData.add(currChunk.data.dbl_values());
                continue;
            }
            if (currChunk.data.discriminator() == TimeSeriesType.TYPE_ENCODED) {
                EncodedData[] encoded = currChunk.data.encoded_values();
                for (int i = 0; i < encoded.length; ++i) {
                    numPoints += encoded[i].num_points;
                    eData.add(encoded[i]);
                }
                continue;
            }
            throw new RuntimeException("Unknown data type! " + currChunk.data.discriminator().value());
        }
        MicroSecondDate end = new MicroSecondDate(currChunk.end_time);
        SamplingImpl samps = new SamplingImpl(numPoints - 1, end.subtract(begin));
        TimeSeriesDataSel sel = new TimeSeriesDataSel();
        if (currChunk.data.discriminator() == TimeSeriesType.TYPE_SHORT) {
            whole = new short[numPoints];
            int pos = 0;
            Iterator dataIt = eData.iterator();
            while (dataIt.hasNext()) {
                short[] segment = (short[])dataIt.next();
                System.arraycopy(segment, 0, whole, pos, segment.length);
                pos += segment.length;
            }
            sel.sht_values(whole);
        } else if (currChunk.data.discriminator() == TimeSeriesType.TYPE_LONG) {
            whole = new int[numPoints];
            int pos = 0;
            Iterator dataIt = eData.iterator();
            while (dataIt.hasNext()) {
                int[] segment = (int[])dataIt.next();
                System.arraycopy(segment, 0, whole, pos, segment.length);
                pos += segment.length;
            }
            sel.int_values((int[])whole);
        } else if (currChunk.data.discriminator() == TimeSeriesType.TYPE_FLOAT) {
            whole = new float[numPoints];
            int pos = 0;
            Iterator dataIt = eData.iterator();
            while (dataIt.hasNext()) {
                float[] segment = (float[])dataIt.next();
                System.arraycopy(segment, 0, whole, pos, segment.length);
                pos += segment.length;
            }
            sel.flt_values((float[])whole);
        } else if (currChunk.data.discriminator() == TimeSeriesType.TYPE_DOUBLE) {
            whole = new double[numPoints];
            int pos = 0;
            Iterator dataIt = eData.iterator();
            while (dataIt.hasNext()) {
                double[] segment = (double[])dataIt.next();
                System.arraycopy(segment, 0, whole, pos, segment.length);
                pos += segment.length;
            }
            sel.dbl_values((double[])whole);
        } else if (currChunk.data.discriminator() == TimeSeriesType.TYPE_ENCODED) {
            whole = eData.toArray(new EncodedData[eData.size()]);
            sel.encoded_values((EncodedData[])whole);
        } else {
            throw new RuntimeException("Unknown data type! " + currChunk.data.discriminator().value());
        }
        LocalSeismogramImpl ls = new LocalSeismogramImpl(ChannelIdUtil.toString((ChannelId)channelId) + ":" + begin.getFissuresTime().date_time + "/" + numPoints + "/" + new Date().getTime(), begin.getFissuresTime(), numPoints, (Sampling)samps, (Unit)UnitImpl.COUNT, channelId, sel);
        return ls;
    }

    public static RequestFilter getRequestFilter(List chunks) {
        ArrayList<Object> eData = new ArrayList<Object>();
        int numPoints = 0;
        DataChunk currChunk = null;
        MicroSecondDate begin = null;
        ChannelId channelId = null;
        Iterator it = chunks.iterator();
        if (!it.hasNext()) {
            return null;
        }
        while (it.hasNext()) {
            currChunk = (DataChunk)it.next();
            if (begin == null) {
                begin = new MicroSecondDate(currChunk.begin_time);
                channelId = currChunk.channel;
            }
            if (currChunk.data.discriminator() == TimeSeriesType.TYPE_SHORT) {
                numPoints += currChunk.data.sht_values().length;
                eData.add(currChunk.data.sht_values());
                continue;
            }
            if (currChunk.data.discriminator() == TimeSeriesType.TYPE_LONG) {
                numPoints += currChunk.data.int_values().length;
                eData.add(currChunk.data.int_values());
                continue;
            }
            if (currChunk.data.discriminator() == TimeSeriesType.TYPE_FLOAT) {
                numPoints += currChunk.data.flt_values().length;
                eData.add(currChunk.data.flt_values());
                continue;
            }
            if (currChunk.data.discriminator() == TimeSeriesType.TYPE_DOUBLE) {
                numPoints += currChunk.data.dbl_values().length;
                eData.add(currChunk.data.dbl_values());
                continue;
            }
            if (currChunk.data.discriminator() == TimeSeriesType.TYPE_ENCODED) {
                EncodedData[] encoded = currChunk.data.encoded_values();
                for (int i = 0; i < encoded.length; ++i) {
                    numPoints += encoded[i].num_points;
                    eData.add(encoded[i]);
                }
                continue;
            }
            throw new RuntimeException("Unknown data type! " + currChunk.data.discriminator().value());
        }
        MicroSecondDate end = new MicroSecondDate(currChunk.end_time);
        RequestFilter rf = new RequestFilter(channelId, begin.getFissuresTime(), end.getFissuresTime());
        return rf;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

