/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.log4j.Logger;

public class WorkerThreadPool {
    private int totalNumCreated = 0;
    private int poolSize;
    private ThreadGroup tg;
    private LinkedList queue = new LinkedList();
    private Set idle = Collections.synchronizedSet(new HashSet());
    private static WorkerThreadPool defaultPool;
    private static Logger logger;
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$cache$WorkerThreadPool;

    public WorkerThreadPool(String name, int numThreads) {
        this(name, numThreads, 5);
    }

    public WorkerThreadPool(String name, int numThreads, int priority) {
        this.poolSize = numThreads;
        this.tg = new ThreadGroup(name);
        this.tg.setMaxPriority(priority);
        this.fillPool();
    }

    public synchronized void invokeLater(Runnable runnable) {
        if (!this.queue.contains(runnable)) {
            this.queue.addFirst(runnable);
        }
        this.fillPool();
        this.notifyAll();
    }

    private void fillPool() {
        int numNewThreads = this.poolSize - this.tg.activeCount();
        for (int i = 0; i < numNewThreads; ++i) {
            BackgroundWorker bw = new BackgroundWorker(this.tg, "" + this.totalNumCreated++, this.tg.getMaxPriority());
            this.idle.add(bw);
            bw.start();
        }
    }

    public static WorkerThreadPool getDefaultPool() {
        if (defaultPool == null) {
            defaultPool = new WorkerThreadPool("default workers", 2);
        }
        return defaultPool;
    }

    private synchronized Runnable getFromQueue() throws InterruptedException {
        while (this.queue.isEmpty()) {
            this.wait();
        }
        this.idle.remove(Thread.currentThread());
        return (Runnable)this.queue.removeLast();
    }

    public synchronized int getNumWaiting() {
        return this.queue.size();
    }

    public int getNumIdle() {
        return this.idle.size();
    }

    public synchronized boolean isEmployed() {
        return this.getNumWaiting() != 0 || this.getNumIdle() < this.poolSize;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$cache$WorkerThreadPool == null ? (class$edu$sc$seis$fissuresUtil$cache$WorkerThreadPool = WorkerThreadPool.class$("edu.sc.seis.fissuresUtil.cache.WorkerThreadPool")) : class$edu$sc$seis$fissuresUtil$cache$WorkerThreadPool));
    }

    private class BackgroundWorker
    extends Thread {
        protected BackgroundWorker(ThreadGroup group, String name, int priority) {
            super(group, name);
            this.setPriority(priority);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    WorkerThreadPool.this.getFromQueue().run();
                    continue;
                }
                catch (Throwable e) {
                    GlobalExceptionHandler.handle(e);
                    continue;
                }
                finally {
                    WorkerThreadPool.this.idle.add(this);
                    continue;
                }
                break;
            }
        }
    }
}

