/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.DataCenterOperations;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.sc.seis.fissuresUtil.cache.SeismogramBackgroundLoader;
import edu.sc.seis.fissuresUtil.cache.SeismogramLoadedListener;
import edu.sc.seis.fissuresUtil.cache.SeismogramQueueElement;
import java.util.LinkedList;
import javax.swing.event.EventListenerList;

public class SeismogramBackgroundLoaderPool {
    private EventListenerList listenerList = new EventListenerList();
    private LinkedList queue = new LinkedList();
    private LinkedList idleWorkers = new LinkedList();
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$cache$SeismogramLoadedListener;

    public SeismogramBackgroundLoaderPool(int numWorkers) {
        for (int i = 0; i < numWorkers; ++i) {
            this.idleWorker(new SeismogramBackgroundLoader(this));
        }
    }

    public SeismogramBackgroundLoaderPool(int numWorkers, SeismogramLoadedListener listener) {
        this(numWorkers);
        this.addSeismogramLoadedListener(listener);
    }

    public void getSeismogram(DataCenterOperations seisDC, RequestFilter request, SeismogramLoadedListener listener) {
        this.addToQueue(seisDC, request, listener);
    }

    public void addSeismogramLoadedListener(SeismogramLoadedListener listener) {
        this.listenerList.add(class$edu$sc$seis$fissuresUtil$cache$SeismogramLoadedListener == null ? (class$edu$sc$seis$fissuresUtil$cache$SeismogramLoadedListener = SeismogramBackgroundLoaderPool.class$("edu.sc.seis.fissuresUtil.cache.SeismogramLoadedListener")) : class$edu$sc$seis$fissuresUtil$cache$SeismogramLoadedListener, listener);
    }

    public void removeFooListener(SeismogramLoadedListener listener) {
        this.listenerList.remove(class$edu$sc$seis$fissuresUtil$cache$SeismogramLoadedListener == null ? (class$edu$sc$seis$fissuresUtil$cache$SeismogramLoadedListener = SeismogramBackgroundLoaderPool.class$("edu.sc.seis.fissuresUtil.cache.SeismogramLoadedListener")) : class$edu$sc$seis$fissuresUtil$cache$SeismogramLoadedListener, listener);
    }

    protected void fireSeismogramLoaded(RequestFilter filter, LocalSeismogram[] seis) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$sc$seis$fissuresUtil$cache$SeismogramLoadedListener == null ? SeismogramBackgroundLoaderPool.class$("edu.sc.seis.fissuresUtil.cache.SeismogramLoadedListener") : class$edu$sc$seis$fissuresUtil$cache$SeismogramLoadedListener)) continue;
            ((SeismogramLoadedListener)listeners[i + 1]).seismogramLoaded(filter, seis);
        }
    }

    protected void fireSeismogramError(RequestFilter filter, FissuresException e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$sc$seis$fissuresUtil$cache$SeismogramLoadedListener == null ? SeismogramBackgroundLoaderPool.class$("edu.sc.seis.fissuresUtil.cache.SeismogramLoadedListener") : class$edu$sc$seis$fissuresUtil$cache$SeismogramLoadedListener)) continue;
            ((SeismogramLoadedListener)listeners[i + 1]).seismogramError(filter, e);
        }
    }

    protected synchronized void idleWorker(SeismogramBackgroundLoader loader) {
        this.idleWorkers.add(loader);
        this.notifyAll();
    }

    protected synchronized boolean isEmpty() {
        return this.queue.isEmpty();
    }

    protected synchronized SeismogramQueueElement getFromQueue() throws InterruptedException {
        while (this.queue.isEmpty()) {
            this.wait();
        }
        return (SeismogramQueueElement)this.queue.removeLast();
    }

    protected synchronized SeismogramBackgroundLoader getWorker() throws InterruptedException {
        while (this.idleWorkers.isEmpty()) {
            this.wait();
        }
        return (SeismogramBackgroundLoader)this.idleWorkers.removeLast();
    }

    protected synchronized void addToQueue(DataCenterOperations seisDC, RequestFilter request, SeismogramLoadedListener listener) {
        this.queue.addFirst(new SeismogramQueueElement(seisDC, request, listener));
        this.notifyAll();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

